"use strict";

/* jshint ignore:start */



/* jshint ignore:end */

define('cornerstone/adapters/cs-adapter-with-ids', ['exports', 'cornerstone/adapters/cs-adapter', 'npm:uuid'], function (exports, _cornerstoneAdaptersCsAdapter, _npmUuid) {
  exports['default'] = _cornerstoneAdaptersCsAdapter['default'].extend({

    generateIdForRecord: function generateIdForRecord() {
      return _npmUuid['default'].v4();
    }

  });
});
// import Ember from 'ember';
define('cornerstone/adapters/cs-adapter', ['exports', 'ember', 'ember-data/adapters/json-api'], function (exports, _ember, _emberDataAdaptersJsonApi) {
  // import { AdapterError, InvalidError } from 'ember-data/adapters/errors';

  exports['default'] = _emberDataAdaptersJsonApi['default'].extend({

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_findAll
    findAll: function findAll(store, type) {
      return this.get('csAjax').modelRequest(type.modelName);
    },

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_findRecord
    findRecord: function findRecord(store, type, id) {
      return this._request(type.modelName, {
        params: { query: { id: id }, single: true }
      });
    },

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_query
    query: function query(store, type, _query) {
      return this._request(type.modelName, {
        params: { query: _query }
      });
    },

    // should404: false,

    _request: function _request(type, request) {
      var _this = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        _this.get('csAjax').modelRequest(type, request).then(function (success) {

          var status = success.errors ? success.errors[0].status : 200;
          var response = _this.handleResponse(status, [], success, request);

          if (response.errors) {
            reject(response);
          } else {
            _ember['default'].run(function () {
              resolve(response);
            });
          }
        }, reject);
      });
    },

    //
    // Caching
    //

    // shouldReloadRecord(store, snapshot) {
    //   return false;
    // },

    // shouldBackgroundReloadRecord(store, snapshot) {
    //   console.log("Calling shouldBackgroundReloadRecord");
    //   const loadedAt = snapshot.record.get('loadedAt');

    //   // if it was loaded more than an hour ago
    //   if (Date.now() - loadedAt > 3600000) {
    //     return true;
    //   } else {
    //     return false;
    //   }
    // },

    createRecord: function createRecord(store, type, snapshot) {
      return this._updateRequest('create', store, type, snapshot);
    },

    updateRecord: function updateRecord(store, type, snapshot) {
      return this._updateRequest('update', store, type, snapshot);
    },

    deleteRecord: function deleteRecord(store, type, snapshot) {
      return this._updateRequest('delete', store, type, snapshot);
    },

    _updateRequest: function _updateRequest(action, store, type, snapshot) {
      return this.get('csAjax').request('adapter::' + type.modelName, {
        action: action,
        params: {
          model: this.serialize(snapshot, { includeId: true }),
          id: snapshot.id
        }
      });
    }

  });
});
define('cornerstone/adapters/cs-client-side-adapter', ['exports', 'ember', 'cornerstone/adapters/cs-read-only-adapter', 'npm:uuid'], function (exports, _ember, _cornerstoneAdaptersCsReadOnlyAdapter, _npmUuid) {
  exports['default'] = _cornerstoneAdaptersCsReadOnlyAdapter['default'].extend({

    firstLoad: false,
    generateIdForRecord: function generateIdForRecord() {
      return _npmUuid['default'].v4();
    },

    shouldBackgroundReloadAll: function shouldBackgroundReloadAll() {
      return false;
    },

    shouldReloadAll: function shouldReloadAll(store, snapshotArray) {
      return _ember['default'].isEmpty(_ember['default'].get(store.peekAll(snapshotArray.type.modelName), 'content'));
    },

    shouldReloadRecord: function shouldReloadRecord() {
      return false;
    },

    shouldBackgroundReloadRecord: function shouldBackgroundReloadRecord() {
      return false;
    }

  });
});
define('cornerstone/adapters/cs-longevity-adapter', ['exports', 'ember', 'cornerstone/adapters/cs-read-only-adapter'], function (exports, _ember, _cornerstoneAdaptersCsReadOnlyAdapter) {
  exports['default'] = _cornerstoneAdaptersCsReadOnlyAdapter['default'].extend({
    csBackgroundReloadRefreshRate: 300000,

    shouldReloadRecord: function shouldReloadRecord() {
      return false;
    },

    shouldBackgroundReloadRecord: function shouldBackgroundReloadRecord(store, snapshot) {

      var loadedAt = snapshot.record.get('loadedAt');
      var now = Date.now();
      if (now - loadedAt > this.csBackgroundReloadRefreshRate) {
        snapshot.record.set('loadedAt', now);
        _ember['default'].Logger.info('Background reloading ' + snapshot.modelName + ' ' + snapshot.id);
        return true;
      } else {
        return false;
      }
    }

  });
});
define('cornerstone/adapters/cs-option-list-adapter', ['exports', 'ember', 'ember-data/adapters/json-api', 'npm:uuid'], function (exports, _ember, _emberDataAdaptersJsonApi, _npmUuid) {
  exports['default'] = _emberDataAdaptersJsonApi['default'].extend({

    filterResponse: function filterResponse(store, type, response) {
      return response;
    },

    // Set this to the option model we're proxying through
    option: null,

    generateIdForRecord: function generateIdForRecord() {
      return _npmUuid['default'].v4();
    },

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_findAll
    findAll: function findAll(store, type) {
      var _this = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        store.findRecord('option', _this.get('option')).then(function (record) {
          resolve(_this.filterResponse(store, type, record.serialize().data.attributes.value));
        }, reject);
      });
    },

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_findRecord
    findRecord: function findRecord(store, type, id) {
      var _this2 = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        _this2.findAll(store).then(function () {
          resolve(store.peekRecord(type.modelName, id));
        }, reject);
      });
    },

    // http://emberjs.com/api/data/classes/DS.Adapter.html#method_query
    query: function query() {
      console.warn('This adapter does not support query');
    },

    shouldReloadRecord: function shouldReloadRecord() {
      return false;
    },

    shouldBackgroundReloadRecord: function shouldBackgroundReloadRecord() {
      return false;
    },

    createRecord: function createRecord(store, type, snapshot) {
      return this._updateRequest('create', store, type, snapshot);
    },

    updateRecord: function updateRecord(store, type, snapshot) {
      return this._updateRequest('update', store, type, snapshot);
    },

    deleteRecord: function deleteRecord(store, type, snapshot) {
      return this._updateRequest('delete', store, type, snapshot);
    },

    _updateRequest: function _updateRequest(action, store, type /*, snapshot */) {
      var _this3 = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {

        var option = store.peekRecord('option', _this3.get('option'));

        var value = store.peekAll(type.modelName).filter(function (record) {
          return !record.get('isDeleted');
        }).sortBy('order').map(function (record) {
          return record.serialize({ includeId: true });
        });

        option.set('value', value);

        option.save().then(function () {
          resolve();
        }, reject);
      });
    }

  });
});
define('cornerstone/adapters/cs-read-only-adapter', ['exports', 'ember', 'cornerstone/adapters/cs-adapter'], function (exports, _ember, _cornerstoneAdaptersCsAdapter) {
  exports['default'] = _cornerstoneAdaptersCsAdapter['default'].extend({

    //
    // Fake persistence
    //

    createRecord: function createRecord() {
      return new _ember['default'].RSVP.Promise(function (resolve) {
        return resolve(undefined);
      });
    },

    updateRecord: function updateRecord() {
      return new _ember['default'].RSVP.Promise(function (resolve) {
        return resolve(undefined);
      });
    },

    deleteRecord: function deleteRecord() {
      return new _ember['default'].RSVP.Promise(function (resolve) {
        return resolve(undefined);
      });
    }

  });
});
define('cornerstone/app', ['exports', 'ember', 'cornerstone/resolver', 'ember-load-initializers', 'cornerstone/config/environment'], function (exports, _ember, _cornerstoneResolver, _emberLoadInitializers, _cornerstoneConfigEnvironment) {

  var App = undefined;

  _ember['default'].MODEL_FACTORY_INJECTIONS = true;

  App = _ember['default'].Application.extend({
    modulePrefix: _cornerstoneConfigEnvironment['default'].modulePrefix,
    podModulePrefix: _cornerstoneConfigEnvironment['default'].podModulePrefix,
    Resolver: _cornerstoneResolver['default']
  });

  (0, _emberLoadInitializers['default'])(App, _cornerstoneConfigEnvironment['default'].modulePrefix);

  exports['default'] = App;
});
define('cornerstone/application/adapter', ['exports', 'cornerstone/adapters/cs-read-only-adapter'], function (exports, _cornerstoneAdaptersCsReadOnlyAdapter) {
  exports['default'] = _cornerstoneAdaptersCsReadOnlyAdapter['default'].extend({});
});
// import Ember from 'ember';
define('cornerstone/application/route', ['exports', 'ember', 'cornerstone/mixins/keyboard-shortcuts/route'], function (exports, _ember, _cornerstoneMixinsKeyboardShortcutsRoute) {
  exports['default'] = _ember['default'].Route.extend(_cornerstoneMixinsKeyboardShortcutsRoute['default'], {

    ui: _ember['default'].inject.service(),
    preview: _ember['default'].inject.service(),

    keyboardShortcuts: {
      'save': 'save',
      'delete-confirm': {
        action: 'deleteConfirm',
        global: false
      },
      'delete-release': 'deleteRelease',
      'mod-key-press': {
        action: 'modKeyPress',
        global: false
      },
      'mod-key-release': 'modKeyRelease',
      'esc': 'cancel'
    },

    shouldBindKeyboardShortcuts: _ember['default'].computed.not('preview.isPreview'),

    shouldLoadPreview: _ember['default'].observer('preview.ready', function () {
      if (this.get('preview.isPreview') && this.get('preview.ready')) {
        this.transitionTo(this.get('preview.initialRoute'));
      }
    }),

    init: function init() {
      this._super.apply(this, arguments);
      this.get('preview').setupPort();
    },

    setupController: function setupController(controller) {
      this._super.apply(this, arguments);
      controller.set('isPreview', this.get('preview.isPreview'));
    },

    actions: {

      save: function save() {
        // Prevent native browser save dialog when this event isn't handled by a child route
      },

      error: function error(_error, transition) {
        console.warn('Transition Error', _error, transition);
      },

      cancel: function cancel() {

        if (this.get('preview.isPreview')) {
          return;
        }

        var $focus = _ember['default'].$('<input type="text" style="opacity:0;position:absolute;">');
        _ember['default'].$('body').append($focus);
        $focus.focus();
        $focus.remove();
      },

      modKeyPress: function modKeyPress() {
        this.set('ui.modKey', true);
      },

      modKeyRelease: function modKeyRelease() {
        this.set('ui.modKey', false);
      },

      deleteConfirm: function deleteConfirm() {
        this.set('ui.deleteConfirm', true);
      },

      deleteRelease: function deleteRelease() {
        this.set('ui.deleteConfirm', false);
      },

      loading: function loading(transition /* , originRoute */) {
        this.set('ui.transitioning', true);
        transition.promise['finally']((function () {
          this.set('ui.transitioning', false);
        }).bind(this));
      },

      didTransition: function didTransition() {
        var _this = this;

        _ember['default'].run.next(this, function () {
          _this.set('ui.currentRouteName', _this.get('router.currentRouteName'));
        });
        return true;
      }

    }

  });
});
define('cornerstone/application/serializer', ['exports', 'ember-data/serializers/json-api'], function (exports, _emberDataSerializersJsonApi) {
  exports['default'] = _emberDataSerializersJsonApi['default'].extend({
    // keyForAttribute(key) {
    //   if ( 'controlGroups' === key ) {
    //     debugger;
    //   }
    //
    // },
    // normalizeResponse(store, primaryModelClass, payload) {
    //   console.log(payload);
    //   debugger;
    //   return this._super(...arguments);
    // }
    // normalizeFindRecordResponse(store, type, payload) {
    //   console.log(type,payload);
    //   return this._super(...arguments)
    // }
    // normalizeFindRecordResponse(store, type, payload) {
    //   console.log(payload);
    //   return {
    //     data: {
    //       id: payload.id,
    //       type: type.modelName,
    //       attributes: {
    //         // name: payload.name,
    //         // publicRepos: payload.public_repos
    //       }
    //     }
    //   }
    // }
  });
});
define("cornerstone/application/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 3,
                  "column": 2
                },
                "end": {
                  "line": 5,
                  "column": 2
                }
              },
              "moduleName": "cornerstone/application/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("    ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "outlet", ["bar"], [], ["loc", [null, [4, 4], [4, 20]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 7,
                  "column": 2
                },
                "end": {
                  "line": 9,
                  "column": 2
                }
              },
              "moduleName": "cornerstone/application/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("    ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "common/tab-modal", [], ["panels", ["subexpr", "@mut", [["get", "ui.cheatsheetItems", ["loc", [null, [8, 30], [8, 48]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "@mut", [["get", "ui.showCheatsheet", ["loc", [null, [8, 56], [8, 73]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [8, 4], [8, 75]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 2,
                "column": 0
              },
              "end": {
                "line": 14,
                "column": 0
              }
            },
            "moduleName": "cornerstone/application/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(7);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 6, 6, contextualElement);
            morphs[4] = dom.createMorphAt(fragment, 8, 8, contextualElement);
            morphs[5] = dom.createMorphAt(fragment, 10, 10, contextualElement);
            morphs[6] = dom.createMorphAt(fragment, 12, 12, contextualElement);
            dom.insertBoundary(fragment, 0);
            return morphs;
          },
          statements: [["block", "global/cs-bar", [], [], 0, null, ["loc", [null, [3, 2], [5, 20]]]], ["inline", "outlet", ["global"], [], ["loc", [null, [6, 2], [6, 21]]], 0, 0], ["block", "if", [["get", "ui.routeEnabledCheatsheet", ["loc", [null, [7, 8], [7, 33]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [7, 2], [9, 9]]]], ["content", "global/notification-queue", ["loc", [null, [10, 2], [10, 31]]], 0, 0, 0, 0], ["inline", "common/confirm-modal", [], ["screen", "global"], ["loc", [null, [11, 2], [11, 42]]], 0, 0], ["inline", "global/progress-bar", [], ["saving", ["subexpr", "@mut", [["get", "ui.saving", ["loc", [null, [12, 31], [12, 40]]], 0, 0, 0, 0]], [], [], 0, 0], "transitioning", ["subexpr", "@mut", [["get", "ui.transitioning", ["loc", [null, [12, 55], [12, 71]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [12, 2], [12, 73]]], 0, 0], ["content", "cs-islands", ["loc", [null, [13, 2], [13, 16]]], 0, 0, 0, 0]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 16,
              "column": 0
            }
          },
          "moduleName": "cornerstone/application/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "unless", [["get", "isPreview", ["loc", [null, [2, 10], [2, 19]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 0], [14, 11]]]], ["content", "outlet", ["loc", [null, [15, 0], [15, 10]]], 0, 0, 0, 0]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 17,
            "column": 0
          }
        },
        "moduleName": "cornerstone/application/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "global/top-level", [], [], 0, null, ["loc", [null, [1, 0], [16, 21]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/classic-template/adapter', ['exports', 'cornerstone/adapters/cs-adapter'], function (exports, _cornerstoneAdaptersCsAdapter) {
  exports['default'] = _cornerstoneAdaptersCsAdapter['default'].extend({});
});
define('cornerstone/classic-template/model', ['exports', 'ember-data/model', 'ember-data/attr'], function (exports, _emberDataModel, _emberDataAttr) {
  exports['default'] = _emberDataModel['default'].extend({

    title: (0, _emberDataAttr['default'])(),
    section: (0, _emberDataAttr['default'])(),
    type: (0, _emberDataAttr['default'])(),
    elements: (0, _emberDataAttr['default'])()

  });
});
// import Ember from 'ember';
define('cornerstone/components/app-version', ['exports', 'ember-cli-app-version/components/app-version', 'cornerstone/config/environment'], function (exports, _emberCliAppVersionComponentsAppVersion, _cornerstoneConfigEnvironment) {

  var name = _cornerstoneConfigEnvironment['default'].APP.name;
  var version = _cornerstoneConfigEnvironment['default'].APP.version;

  exports['default'] = _emberCliAppVersionComponentsAppVersion['default'].extend({
    version: version,
    name: name
  });
});
define('cornerstone/components/bars/region-manager/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-workspace-content', 'cs-hf-layout'],

    store: _ember['default'].inject.service(),

    orderSort: ['order'],
    titleSort: ['title'],
    sortedBars: _ember['default'].computed.sort('selectedRegion.availableChildren', 'orderSort'),
    sortedContainers: _ember['default'].computed.sort('selectedBar.availableChildren', 'orderSort'),
    sortedModules: _ember['default'].computed.sort('selectedContainer.availableChildren', 'orderSort'),

    elementLibrary: _ember['default'].computed.filter('moduleDefinitions', function (item) {
      if (item.get('isClassic')) {
        return false;
      }
      return item.getWithDefault('showInLibrary', false);
    }),

    sortedElementLibrary: _ember['default'].computed.sort('elementLibrary', 'titleSort'),

    unsetSelectedContainer: _ember['default'].observer('selectedContainer.isDeleted', function () {
      if (this.get('selectedContainer.isDeleted')) {
        this.set('selectedContainer', null);
      }
    }),

    unsetSelectedBar: _ember['default'].observer('selectedBar.isDeleted', function () {
      if (this.get('selectedBar.isDeleted')) {
        this.set('selectedBar', null);
      }
    }),

    init: function init() {
      this._super.apply(this, arguments);
      this.firstOpen();
    },

    showRegionSelect: _ember['default'].computed.gt('regions.length', 1),

    singleBarRegions: _ember['default'].computed('regions.[]', function () {
      return this.get('regions').filter(function (region) {
        return _ember['default'].get(region, 'oneBar');
      }).map(function (region) {
        return region.value;
      });
    }),

    canAddBar: _ember['default'].computed('selectedRegion', 'sortedBars', 'singleBarRegions.[]', function () {
      return !(this.get('singleBarRegions').includes(this.get('selectedRegion.atts._region')) && this.get('sortedBars.length') > 0);
    }),

    maxBarsMessage: _ember['default'].computed('canAddBar', function () {
      return 'This region only supports a single bar.';
    }),

    moduleSelectorIsShowing: false,

    firstOpen: function firstOpen() {

      if (this.get('inspecting')) {
        this.send('selectModule', this.get('inspecting'));
        return;
      }

      this.sendAction('onFirstOpen');

      var first = this.get('activeRoot.availableChildren').find(function (item) {
        return item.get('availableChildren.length') > 0;
      });

      var defaultRegion = this.get('regions.firstObject.value');

      this.send('selectRegion', _ember['default'].isNone(first) ? defaultRegion : _ember['default'].getWithDefault(first, 'atts._region', defaultRegion));
    },

    actions: {

      // TODO: Many of these actions should be moved up to the route

      _addAndSelect: function _addAndSelect(parentKey, type, sibling, after) {
        var _this = this;

        var atts = {
          title: this.get('i18n').t('app.indexed', {
            label: this.get('store').peekRecord('element/definition', type).get('title'),
            index: this.get(parentKey + '.availableChildren.length') + 1
          }).toString()
        };

        if (sibling) {
          this.send('_newModuleFromSibling', type, sibling, atts, after);
        } else {
          this.send('_newModule', this.get(parentKey), type, atts, null, function (module) {
            if (1 === _this.get(parentKey + '.availableChildren.length')) {
              _this.send('selectModule', module);
            }
          });
        }
      },

      _newModule: function _newModule(parent, type, atts, index, success) {
        var _this2 = this;

        var addChild = parent.get('addChild');

        if ('function' !== _ember['default'].typeOf(addChild)) {
          return;
        }

        var module = addChild(_ember['default'].merge(atts, {
          _type: type,
          _region: this.get('selectedRegion.atts._region')
        }), index);

        if (module) {
          module.then(function (record) {
            _this2.get('ui.preview.xfr').message('preview:new:element', record.get('id'));
            _this2.sendAction('onNewElement', record);
            if ('function' === _ember['default'].typeOf(success)) {
              success(record);
            }
          });
        }
      },

      _newModuleFromSibling: function _newModuleFromSibling(type, sibling, atts, after) {
        this.send('_newModule', sibling.get('parent'), type, atts, after ? sibling.get('order') + 1 : sibling.get('order'));
      },

      selectRegion: function selectRegion(region) {

        this.send('selectModule', this.get('activeRoot.availableChildren').filter(function (item) {
          return 'region' === item.get('atts._type') && item.get('atts._region') === region;
        }).get('firstObject'));
      },

      addBar: function addBar(sibling, after) {
        this.send('_addAndSelect', 'selectedRegion', 'bar', sibling, after);
      },

      addContainer: function addContainer(sibling, after) {
        this.send('_addAndSelect', 'selectedBar', 'container', sibling, after);
      },

      addModule: function addModule(sibling, after) {
        this.set('selectModuleCallback', (function (type) {
          if (sibling) {
            this.send('_newModuleFromSibling', type, sibling, {}, after);
          } else {
            this.send('_newModule', this.get('selectedContainer'), type, {});
          }
          this.set('moduleSelectorIsShowing', false);
        }).bind(this));
        this.set('moduleSelectorIsShowing', true);
      },

      moveModule: function moveModule(module, newIndex) {
        module.get('updatePosition')(newIndex);
      },

      selectModule: function selectModule(module) {
        var _this3 = this;

        var selectableTypes = ['region', 'bar', 'container'];

        // Look up or down to find a container
        function findDeepest(_x) {
          var _again = true;

          _function: while (_again) {
            var module = _x;
            _again = false;

            if (!module) {
              return false;
            }

            var type = _ember['default'].get(module, 'atts._type');

            if (type === 'container') {
              return module;
            }

            if (selectableTypes.includes(type)) {
              var children = _ember['default'].get(module, 'availableChildren');
              var child = children.sortBy('order').get('firstObject');
              if (child) {
                _x = child;
                _again = true;
                type = children = child = undefined;
                continue _function;
              } else {
                return module;
              }
            }

            if (module.get('parent.atts._type')) {
              _x = module.get('parent');
              _again = true;
              type = children = child = undefined;
              continue _function;
            }

            return false;
          }
        }

        function fillSelection(next) {
          var selection = {};
          while ('undefined' !== typeof next && selectableTypes.includes(next.get('atts._type'))) {
            selection[next.get('atts._type')] = next;
            next = next.get('parent');
          }
          return selection;
        }

        var container = findDeepest(module);
        if (!container) {
          console.warn('Could not make a layout selection.');
          return;
        }

        var selection = fillSelection(container);

        selectableTypes.forEach(function (item) {
          var path = _ember['default'].String.camelize('selected-' + item);
          if (_this3.get(path) !== selection[item]) {
            _this3.set(path, selection[item]);
          }
        });
      },

      inspectElement: function inspectElement(element) {
        this.sendAction('onInspect', element);
      },

      duplicateModule: function duplicateModule(module) {
        module.duplicate();
        this.sendAction('onDuplicateElement', module);
      },

      deleteModule: function deleteModule(element) {
        this.get('ui').confirm({
          screen: this.get('screen'),
          message: this.get('i18n').t('app.elements-confirm-delete', {
            title: element.get('definition.title')
          }),
          accept: function accept() {
            if (element && element.selfDestruct) {
              element.selfDestruct();
            }
          },
          acceptClass: 'sad'
        });
      },

      closeModuleSelection: function closeModuleSelection() {
        this.set('selectModuleCallback', null);
        this.set('moduleSelectorIsShowing', false);
      },

      chooseNewModuleType: function chooseNewModuleType(definition) {
        this.sendAction('selectModuleCallback', definition.get('id'));
      },

      observeStart: function observeStart(element) {
        this.get('ui.preview.xfr').message('preview:observe-start', element.get('id'));
      },

      observeEnd: function observeEnd(element) {
        this.get('ui.preview.xfr').message('preview:observe-end', element.get('id'));
      }

    }
  });
});
define("cornerstone/components/bars/region-manager/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 8,
                "column": 4
              },
              "end": {
                "line": 10,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("li");
            var el2 = dom.createElement("span");
            dom.appendChild(el1, el2);
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element1 = dom.childAt(fragment, [1]);
            var morphs = new Array(3);
            morphs[0] = dom.createAttrMorph(element1, 'class');
            morphs[1] = dom.createElementMorph(element1);
            morphs[2] = dom.createMorphAt(element1, 1, 1);
            return morphs;
          },
          statements: [["attribute", "class", ["concat", [["get", "region.value", ["loc", [null, [9, 58], [9, 70]]], 0, 0, 0, 0], " ", ["subexpr", "if", [["subexpr", "eq", [["get", "selectedRegion.atts._region", ["loc", [null, [9, 82], [9, 109]]], 0, 0, 0, 0], ["get", "region.value", ["loc", [null, [9, 110], [9, 122]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 78], [9, 123]]], 0, 0], "cs-active"], [], ["loc", [null, [9, 73], [9, 137]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["selectRegion", ["get", "region.value", ["loc", [null, [9, 34], [9, 46]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 10], [9, 48]]], 0, 0], ["content", "region.label", ["loc", [null, [9, 152], [9, 168]]], 0, 0, 0, 0]],
          locals: ["region"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 5,
              "column": 0
            },
            "end": {
              "line": 13,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-hf-layout-item regions");
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("ul");
          var el3 = dom.createTextNode("\n");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("  ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0, 1]), 1, 1);
          return morphs;
        },
        statements: [["block", "each", [["get", "regions", ["loc", [null, [8, 12], [8, 19]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [8, 4], [10, 13]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 30,
                      "column": 14
                    },
                    "end": {
                      "line": 46,
                      "column": 14
                    }
                  },
                  "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("                ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "common/sortable-item", [], ["label", ["subexpr", "@mut", [["get", "bar.indexedTitle", ["loc", [null, [32, 24], [32, 40]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "bar", ["loc", [null, [33, 23], [33, 26]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "eq", [["get", "bar.id", ["loc", [null, [34, 29], [34, 35]]], 0, 0, 0, 0], ["get", "selectedBar.id", ["loc", [null, [34, 36], [34, 50]]], 0, 0, 0, 0]], [], ["loc", [null, [34, 25], [34, 51]]], 0, 0], "showAddAfter", ["subexpr", "eq", [["get", "bar.id", ["loc", [null, [35, 35], [35, 41]]], 0, 0, 0, 0], ["get", "sortedBars.lastObject.id", ["loc", [null, [35, 42], [35, 66]]], 0, 0, 0, 0]], [], ["loc", [null, [35, 31], [35, 67]]], 0, 0], "onDrop", ["subexpr", "action", ["moveModule"], [], ["loc", [null, [36, 25], [36, 47]]], 0, 0], "onAddBefore", ["subexpr", "action", ["addBar", ["get", "bar", ["loc", [null, [37, 47], [37, 50]]], 0, 0, 0, 0]], [], ["loc", [null, [37, 30], [37, 51]]], 0, 0], "onAddAfter", ["subexpr", "action", ["addBar", ["get", "bar", ["loc", [null, [38, 46], [38, 49]]], 0, 0, 0, 0], true], [], ["loc", [null, [38, 29], [38, 55]]], 0, 0], "onSelect", ["subexpr", "action", ["selectModule", ["get", "bar", ["loc", [null, [39, 50], [39, 53]]], 0, 0, 0, 0]], [], ["loc", [null, [39, 27], [39, 54]]], 0, 0], "onInspect", ["subexpr", "action", ["inspectElement", ["get", "bar", ["loc", [null, [40, 53], [40, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [40, 28], [40, 57]]], 0, 0], "onDuplicate", ["subexpr", "action", ["duplicateModule", ["get", "bar", ["loc", [null, [41, 56], [41, 59]]], 0, 0, 0, 0]], [], ["loc", [null, [41, 30], [41, 60]]], 0, 0], "onDelete", ["subexpr", "action", ["deleteModule", ["get", "bar", ["loc", [null, [42, 50], [42, 53]]], 0, 0, 0, 0]], [], ["loc", [null, [42, 27], [42, 54]]], 0, 0], "onMouseEnter", ["subexpr", "action", ["observeStart", ["get", "bar", ["loc", [null, [43, 54], [43, 57]]], 0, 0, 0, 0]], [], ["loc", [null, [43, 31], [43, 58]]], 0, 0], "onMouseLeave", ["subexpr", "action", ["observeEnd", ["get", "bar", ["loc", [null, [44, 52], [44, 55]]], 0, 0, 0, 0]], [], ["loc", [null, [44, 31], [44, 56]]], 0, 0]], ["loc", [null, [31, 16], [45, 18]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            var child1 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 46,
                      "column": 14
                    },
                    "end": {
                      "line": 57,
                      "column": 14
                    }
                  },
                  "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("                ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "common/sortable-item", [], ["label", ["subexpr", "@mut", [["get", "bar.indexedTitle", ["loc", [null, [48, 24], [48, 40]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "bar", ["loc", [null, [49, 23], [49, 26]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "eq", [["get", "bar.id", ["loc", [null, [50, 29], [50, 35]]], 0, 0, 0, 0], ["get", "selectedBar.id", ["loc", [null, [50, 36], [50, 50]]], 0, 0, 0, 0]], [], ["loc", [null, [50, 25], [50, 51]]], 0, 0], "onDrop", ["subexpr", "action", ["moveModule"], [], ["loc", [null, [51, 25], [51, 46]]], 0, 0], "onInspect", ["subexpr", "action", ["inspectElement", ["get", "bar", ["loc", [null, [52, 53], [52, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [52, 28], [52, 57]]], 0, 0], "onDelete", ["subexpr", "action", ["deleteModule", ["get", "bar", ["loc", [null, [53, 50], [53, 53]]], 0, 0, 0, 0]], [], ["loc", [null, [53, 27], [53, 54]]], 0, 0], "onMouseEnter", ["subexpr", "action", ["observeStart", ["get", "bar", ["loc", [null, [54, 54], [54, 57]]], 0, 0, 0, 0]], [], ["loc", [null, [54, 31], [54, 58]]], 0, 0], "onMouseLeave", ["subexpr", "action", ["observeEnd", ["get", "bar", ["loc", [null, [55, 52], [55, 55]]], 0, 0, 0, 0]], [], ["loc", [null, [55, 31], [55, 56]]], 0, 0]], ["loc", [null, [47, 16], [56, 18]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 29,
                    "column": 12
                  },
                  "end": {
                    "line": 58,
                    "column": 12
                  }
                },
                "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "if", [["get", "canAddBar", ["loc", [null, [30, 20], [30, 29]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [30, 14], [57, 21]]]]],
              locals: ["bar"],
              templates: [child0, child1]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 28,
                  "column": 10
                },
                "end": {
                  "line": 59,
                  "column": 10
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "each", [["get", "sortedBars", ["loc", [null, [29, 20], [29, 30]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [29, 12], [58, 21]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 60,
                  "column": 10
                },
                "end": {
                  "line": 62,
                  "column": 10
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("            ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("p");
              dom.setAttribute(el1, "class", "cs-hf-layout-max-bars-message");
              var el2 = dom.createElement("strong");
              var el3 = dom.createTextNode("Note:");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode(" ");
              dom.appendChild(el1, el2);
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 2, 2);
              return morphs;
            },
            statements: [["content", "maxBarsMessage", ["loc", [null, [61, 76], [61, 94]]], 0, 0, 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 21,
                "column": 4
              },
              "end": {
                "line": 66,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("ul");
            dom.setAttribute(el1, "class", "cs-controls");
            var el2 = dom.createTextNode("\n        ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("li");
            dom.setAttribute(el2, "class", "cs-control cs-control-sortable");
            var el3 = dom.createTextNode("\n          ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("div");
            dom.setAttribute(el3, "class", "cs-control-header");
            var el4 = dom.createTextNode("\n            ");
            dom.appendChild(el3, el4);
            var el4 = dom.createElement("label");
            var el5 = dom.createTextNode("Bars");
            dom.appendChild(el4, el5);
            dom.appendChild(el3, el4);
            var el4 = dom.createTextNode("\n          ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n");
            dom.appendChild(el2, el3);
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("        ");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n      ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element0 = dom.childAt(fragment, [1, 1]);
            var morphs = new Array(2);
            morphs[0] = dom.createMorphAt(element0, 3, 3);
            morphs[1] = dom.createMorphAt(element0, 4, 4);
            return morphs;
          },
          statements: [["block", "common/sortable-container", [], [], 0, null, ["loc", [null, [28, 10], [59, 40]]]], ["block", "unless", [["get", "canAddBar", ["loc", [null, [60, 20], [60, 29]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [60, 10], [62, 21]]]]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 66,
                "column": 4
              },
              "end": {
                "line": 72,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "workspace/workspace-full-button", [], ["action", ["subexpr", "action", ["addBar"], [], ["loc", [null, [68, 15], [68, 32]]], 0, 0], "icon", ["subexpr", "fa-icon", ["plus-square"], [], ["loc", [null, [69, 13], [69, 36]]], 0, 0], "message", "Add a bar to get started."], ["loc", [null, [67, 6], [71, 8]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 20,
              "column": 2
            },
            "end": {
              "line": 73,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "sortedBars", ["loc", [null, [21, 10], [21, 20]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [21, 4], [72, 11]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 91,
                      "column": 14
                    },
                    "end": {
                      "line": 107,
                      "column": 14
                    }
                  },
                  "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
                },
                isEmpty: false,
                arity: 1,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("                ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "common/sortable-item", [], ["label", ["subexpr", "@mut", [["get", "container.indexedTitle", ["loc", [null, [93, 24], [93, 46]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "container", ["loc", [null, [94, 23], [94, 32]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "eq", [["get", "container.id", ["loc", [null, [95, 29], [95, 41]]], 0, 0, 0, 0], ["get", "selectedContainer.id", ["loc", [null, [95, 42], [95, 62]]], 0, 0, 0, 0]], [], ["loc", [null, [95, 25], [95, 63]]], 0, 0], "showAddAfter", ["subexpr", "eq", [["get", "container.id", ["loc", [null, [96, 35], [96, 47]]], 0, 0, 0, 0], ["get", "sortedContainers.lastObject.id", ["loc", [null, [96, 48], [96, 78]]], 0, 0, 0, 0]], [], ["loc", [null, [96, 31], [96, 79]]], 0, 0], "onDrop", ["subexpr", "action", ["moveModule"], [], ["loc", [null, [97, 25], [97, 47]]], 0, 0], "onAddBefore", ["subexpr", "action", ["addContainer", ["get", "container", ["loc", [null, [98, 53], [98, 62]]], 0, 0, 0, 0]], [], ["loc", [null, [98, 30], [98, 63]]], 0, 0], "onAddAfter", ["subexpr", "action", ["addContainer", ["get", "container", ["loc", [null, [99, 52], [99, 61]]], 0, 0, 0, 0], true], [], ["loc", [null, [99, 29], [99, 67]]], 0, 0], "onSelect", ["subexpr", "action", ["selectModule", ["get", "container", ["loc", [null, [100, 50], [100, 59]]], 0, 0, 0, 0]], [], ["loc", [null, [100, 27], [100, 60]]], 0, 0], "onInspect", ["subexpr", "action", ["inspectElement", ["get", "container", ["loc", [null, [101, 53], [101, 62]]], 0, 0, 0, 0]], [], ["loc", [null, [101, 28], [101, 63]]], 0, 0], "onDuplicate", ["subexpr", "action", ["duplicateModule", ["get", "container", ["loc", [null, [102, 56], [102, 65]]], 0, 0, 0, 0]], [], ["loc", [null, [102, 30], [102, 66]]], 0, 0], "onDelete", ["subexpr", "action", ["deleteModule", ["get", "container", ["loc", [null, [103, 50], [103, 59]]], 0, 0, 0, 0]], [], ["loc", [null, [103, 27], [103, 60]]], 0, 0], "onMouseEnter", ["subexpr", "action", ["observeStart", ["get", "container", ["loc", [null, [104, 54], [104, 63]]], 0, 0, 0, 0]], [], ["loc", [null, [104, 31], [104, 64]]], 0, 0], "onMouseLeave", ["subexpr", "action", ["observeEnd", ["get", "container", ["loc", [null, [105, 52], [105, 61]]], 0, 0, 0, 0]], [], ["loc", [null, [105, 31], [105, 62]]], 0, 0]], ["loc", [null, [92, 16], [106, 18]]], 0, 0]],
                locals: ["container"],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 90,
                    "column": 12
                  },
                  "end": {
                    "line": 108,
                    "column": 12
                  }
                },
                "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "each", [["get", "sortedContainers", ["loc", [null, [91, 22], [91, 38]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [91, 14], [107, 23]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 83,
                  "column": 6
                },
                "end": {
                  "line": 112,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("\n        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("ul");
              dom.setAttribute(el1, "class", "cs-controls");
              var el2 = dom.createTextNode("\n          ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              dom.setAttribute(el2, "class", "cs-control cs-control-sortable");
              var el3 = dom.createTextNode("\n            ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-control-header");
              var el4 = dom.createTextNode("\n              ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("label");
              var el5 = dom.createTextNode("Containers");
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n            ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n");
              dom.appendChild(el2, el3);
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("          ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1]), 3, 3);
              return morphs;
            },
            statements: [["block", "common/sortable-container", [], [], 0, null, ["loc", [null, [90, 12], [108, 42]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 112,
                  "column": 6
                },
                "end": {
                  "line": 118,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "workspace/workspace-full-button", [], ["action", ["subexpr", "action", ["addContainer"], [], ["loc", [null, [114, 17], [114, 40]]], 0, 0], "icon", ["subexpr", "fa-icon", ["plus-square"], [], ["loc", [null, [115, 15], [115, 38]]], 0, 0], "message", "Add your first container to this bar."], ["loc", [null, [113, 8], [117, 10]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 82,
                "column": 4
              },
              "end": {
                "line": 119,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "sortedContainers", ["loc", [null, [83, 12], [83, 28]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [83, 6], [118, 13]]]]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 81,
              "column": 2
            },
            "end": {
              "line": 120,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "common/scroll-box", [], ["name", "containers", "resetScrollOn", ["subexpr", "@mut", [["get", "selectedRegion.atts._region", ["loc", [null, [82, 57], [82, 84]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [82, 4], [119, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child3 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 138,
                      "column": 14
                    },
                    "end": {
                      "line": 152,
                      "column": 14
                    }
                  },
                  "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
                },
                isEmpty: false,
                arity: 1,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("                ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "common/sortable-item", [], ["canEditLabel", false, "label", ["subexpr", "@mut", [["get", "module.title", ["loc", [null, [141, 24], [141, 36]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "module", ["loc", [null, [142, 23], [142, 29]]], 0, 0, 0, 0]], [], [], 0, 0], "onDrop", ["subexpr", "action", ["moveModule"], [], ["loc", [null, [142, 37], [142, 59]]], 0, 0], "showAddAfter", ["subexpr", "eq", [["get", "module.id", ["loc", [null, [143, 35], [143, 44]]], 0, 0, 0, 0], ["get", "sortedModules.lastObject.id", ["loc", [null, [143, 45], [143, 72]]], 0, 0, 0, 0]], [], ["loc", [null, [143, 31], [143, 73]]], 0, 0], "onAddBefore", ["subexpr", "action", ["addModule", ["get", "module", ["loc", [null, [144, 50], [144, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [144, 30], [144, 57]]], 0, 0], "onAddAfter", ["subexpr", "action", ["addModule", ["get", "module", ["loc", [null, [145, 49], [145, 55]]], 0, 0, 0, 0], true], [], ["loc", [null, [145, 29], [145, 61]]], 0, 0], "onInspect", ["subexpr", "action", ["inspectElement", ["get", "module", ["loc", [null, [146, 53], [146, 59]]], 0, 0, 0, 0]], [], ["loc", [null, [146, 28], [146, 60]]], 0, 0], "onDuplicate", ["subexpr", "action", ["duplicateModule", ["get", "module", ["loc", [null, [147, 56], [147, 62]]], 0, 0, 0, 0]], [], ["loc", [null, [147, 30], [147, 63]]], 0, 0], "onDelete", ["subexpr", "action", ["deleteModule", ["get", "module", ["loc", [null, [148, 50], [148, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [148, 27], [148, 57]]], 0, 0], "onMouseEnter", ["subexpr", "action", ["observeStart", ["get", "module", ["loc", [null, [149, 54], [149, 60]]], 0, 0, 0, 0]], [], ["loc", [null, [149, 31], [149, 61]]], 0, 0], "onMouseLeave", ["subexpr", "action", ["observeEnd", ["get", "module", ["loc", [null, [150, 52], [150, 58]]], 0, 0, 0, 0]], [], ["loc", [null, [150, 31], [150, 59]]], 0, 0]], ["loc", [null, [139, 16], [151, 18]]], 0, 0]],
                locals: ["module"],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 137,
                    "column": 12
                  },
                  "end": {
                    "line": 153,
                    "column": 12
                  }
                },
                "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "each", [["get", "sortedModules", ["loc", [null, [138, 22], [138, 35]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [138, 14], [152, 23]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 130,
                  "column": 6
                },
                "end": {
                  "line": 156,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("\n        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("ul");
              dom.setAttribute(el1, "class", "cs-controls");
              var el2 = dom.createTextNode("\n          ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              dom.setAttribute(el2, "class", "cs-control cs-control-sortable");
              var el3 = dom.createTextNode("\n            ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-control-header");
              var el4 = dom.createTextNode("\n              ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("label");
              var el5 = dom.createTextNode("Elements");
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n            ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n");
              dom.appendChild(el2, el3);
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("          ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1]), 3, 3);
              return morphs;
            },
            statements: [["block", "common/sortable-container", [], [], 0, null, ["loc", [null, [137, 12], [153, 42]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 156,
                  "column": 6
                },
                "end": {
                  "line": 162,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "workspace/workspace-full-button", [], ["action", ["subexpr", "action", ["addModule"], [], ["loc", [null, [158, 17], [158, 37]]], 0, 0], "icon", ["subexpr", "fa-icon", ["plus-square"], [], ["loc", [null, [159, 15], [159, 38]]], 0, 0], "message", "Add your first element to this container."], ["loc", [null, [157, 8], [161, 10]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 129,
                "column": 4
              },
              "end": {
                "line": 163,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "sortedModules", ["loc", [null, [130, 12], [130, 25]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [130, 6], [162, 13]]]]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 128,
              "column": 2
            },
            "end": {
              "line": 164,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "common/scroll-box", [], ["name", "modules", "resetScrollOn", ["subexpr", "@mut", [["get", "selectedRegion.atts._region", ["loc", [null, [129, 54], [129, 81]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [129, 4], [163, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 183,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/bars/region-manager/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-hf-layout-item bars");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-hf-layout-item containers");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-hf-layout-item modules");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("button");
        dom.setAttribute(el2, "class", "cs-hf-layout-module-selector-close");
        var el3 = dom.createTextNode("×");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "cs-hf-layout-module-selector-content-outer");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "cs-hf-layout-module-selector-content-inner");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element2 = dom.childAt(fragment, [14]);
        var element3 = dom.childAt(element2, [1]);
        var morphs = new Array(8);
        morphs[0] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [5]), 1, 1);
        morphs[2] = dom.createMorphAt(dom.childAt(fragment, [8]), 1, 1);
        morphs[3] = dom.createMorphAt(dom.childAt(fragment, [11]), 1, 1);
        morphs[4] = dom.createAttrMorph(element2, 'class');
        morphs[5] = dom.createElementMorph(element3);
        morphs[6] = dom.createMorphAt(dom.childAt(element2, [3, 1]), 1, 1);
        morphs[7] = dom.createMorphAt(fragment, 16, 16, contextualElement);
        return morphs;
      },
      statements: [["block", "if", [["get", "showRegionSelect", ["loc", [null, [5, 6], [5, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 0], [13, 7]]]], ["block", "common/scroll-box", [], ["name", "bars", "resetScrollOn", ["subexpr", "@mut", [["get", "selectedRegion.atts._region", ["loc", [null, [20, 49], [20, 76]]], 0, 0, 0, 0]], [], [], 0, 0]], 1, null, ["loc", [null, [20, 2], [73, 24]]]], ["block", "if", [["get", "selectedBar", ["loc", [null, [81, 8], [81, 19]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [81, 2], [120, 9]]]], ["block", "if", [["get", "selectedContainer", ["loc", [null, [128, 8], [128, 25]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [128, 2], [164, 9]]]], ["attribute", "class", ["concat", ["cs-hf-layout-module-selector ", ["subexpr", "if", [["get", "moduleSelectorIsShowing", ["loc", [null, [171, 47], [171, 70]]], 0, 0, 0, 0], "cs-active"], [], ["loc", [null, [171, 41], [171, 84]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["closeModuleSelection"], [], ["loc", [null, [172, 10], [172, 43]]], 0, 0], ["inline", "elements/element-library", [], ["onClickElement", ["subexpr", "action", ["chooseNewModuleType"], [], ["loc", [null, [176, 23], [176, 53]]], 0, 0], "elements", ["subexpr", "@mut", [["get", "sortedElementLibrary", ["loc", [null, [177, 17], [177, 37]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [175, 6], [178, 8]]], 0, 0], ["content", "yield", ["loc", [null, [182, 0], [182, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1, child2, child3]
    };
  })());
});
define('cornerstone/components/click-outside', ['exports', 'ember-click-outside/components/click-outside'], function (exports, _emberClickOutsideComponentsClickOutside) {
  exports['default'] = _emberClickOutsideComponentsClickOutside['default'];
});
define('cornerstone/components/common/bread-crumbs/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'ul',

    classNames: ['cs-bread-crumbs'],
    labelKey: 'breadcrumbTitle',

    breadcrumbs: _ember['default'].computed('items.[]', 'labelKey', 'activeItem', function () {
      var labelKey = this.get('labelKey');
      var activeItem = this.get('activeItem');
      return this.getWithDefault('items', []).map(function (item) {
        return {
          entity: item,
          label: item.get(labelKey),
          active: item === activeItem
        };
      });
    }),

    isVisible: _ember['default'].computed('activeItem', 'breadcrumbs.[]', function () {
      return this.get('activeItem') && this.get('breadcrumbs').length > 0;
    }),

    actions: {
      navigate: function navigate(entity) {
        this.sendAction('onNavigate', entity);
      },
      mouseEnter: function mouseEnter(item) {
        this.sendAction('onMouseEnter', item);
      },
      mouseLeave: function mouseLeave(item) {
        this.sendAction('onMouseLeave', item);
      }
    }
  });
});
define("cornerstone/components/common/bread-crumbs/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/bread-crumbs/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("li");
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("a");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1, 1]);
          var morphs = new Array(5);
          morphs[0] = dom.createAttrMorph(element0, 'onmouseenter');
          morphs[1] = dom.createAttrMorph(element0, 'onmouseleave');
          morphs[2] = dom.createAttrMorph(element0, 'class');
          morphs[3] = dom.createElementMorph(element0);
          morphs[4] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["attribute", "onmouseenter", ["subexpr", "action", ["mouseEnter", ["get", "breadcrumb.entity", ["loc", [null, [4, 39], [4, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [null, null], [4, 58]]], 0, 0], 0, 0, 0, 0], ["attribute", "onmouseleave", ["subexpr", "action", ["mouseLeave", ["get", "breadcrumb.entity", ["loc", [null, [5, 39], [5, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [null, null], [5, 58]]], 0, 0], 0, 0, 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["get", "breadcrumb.active", ["loc", [null, [6, 16], [6, 33]]], 0, 0, 0, 0], "cs-active"], [], ["loc", [null, [6, 11], [6, 47]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["navigate", ["get", "breadcrumb.entity", ["loc", [null, [3, 27], [3, 44]]], 0, 0, 0, 0]], [], ["loc", [null, [3, 7], [3, 46]]], 0, 0], ["content", "breadcrumb.label", ["loc", [null, [6, 49], [6, 69]]], 0, 0, 0, 0]],
        locals: ["breadcrumb"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 9,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/bread-crumbs/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "each", [["get", "breadcrumbs", ["loc", [null, [1, 8], [1, 19]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [7, 9]]]], ["content", "yield", ["loc", [null, [8, 0], [8, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/common/confirm-modal/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    active: false,
    classNames: ['cs-action-modal-outer'],
    classNameBindings: ['screenClass', 'active:cs-active'],

    screenClass: _ember['default'].computed('screen', function () {
      var screen = this.get('screen');
      if (!screen) {
        return '';
      }
      return 'cs-action-modal-' + _ember['default'].String.dasherize(this.get('screen'));
    }),

    init: function init() {

      this._super.apply(this, arguments);
      var screen = this.get('screen');

      if (!screen) {
        console.warn('Confirm modals need an assigned screen');
      }

      this.set('ui.confirmHandlers.' + screen, this.confirm.bind(this));
    },

    confirm: function confirm(params) {

      params = _ember['default'].merge({

        // Callbacks. Null will always close the modal
        accept: null,
        decline: null,

        message: '',
        'class': '',
        acceptBtn: this.get('i18n').t('app.confirm-yep'),
        declineBtn: this.get('i18n').t('app.confirm-nope'),
        back: false,
        backBtn: this.get('i18n').t('app.confirm-back'),
        backBtnClass: '',
        acceptClass: '',
        declineClass: ''
      }, params);

      if (params.screen !== this.get('screen')) {
        return;
      }

      if (params.back) {
        params.declineBtn = params.backBtn;
        params.declineClass = params.backClass;
      }

      this.setProperties({
        message: params.message,
        acceptCallback: params.accept,
        declineCallback: params.decline,
        showAcceptBtn: !!params.accept,
        acceptBtn: params.acceptBtn,
        declineBtn: params.declineBtn,
        acceptClass: params.acceptClass,
        declineClass: params.declineClass
      });

      this.set('active', true);
    },

    actions: {
      accept: function accept() {
        var cb = this.get('acceptCallback');
        if ('function' === _ember['default'].typeOf(cb)) {
          cb();
        }
        this.set('active', false);
      },
      decline: function decline() {
        var cb = this.get('declineCallback');
        if ('function' === _ember['default'].typeOf(cb)) {
          cb();
        }
        this.set('active', false);
      }
    }

  });
});
define("cornerstone/components/common/confirm-modal/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 5,
              "column": 6
            },
            "end": {
              "line": 7,
              "column": 6
            }
          },
          "moduleName": "cornerstone/components/common/confirm-modal/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("        ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          morphs[1] = dom.createElementMorph(element0);
          morphs[2] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["get", "acceptClass", ["loc", [null, [6, 25], [6, 36]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["accept"], [], ["loc", [null, [6, 40], [6, 59]]], 0, 0], ["content", "acceptBtn", ["loc", [null, [6, 60], [6, 73]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/confirm-modal/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-action-modal-inner");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "cs-action-modal-content");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "cs-action-modal-message");
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "cs-action-modal-actions");
        var el4 = dom.createTextNode("\n");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("button");
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element1 = dom.childAt(fragment, [0, 1]);
        var element2 = dom.childAt(element1, [3]);
        var element3 = dom.childAt(element2, [3]);
        var morphs = new Array(5);
        morphs[0] = dom.createMorphAt(dom.childAt(element1, [1]), 0, 0);
        morphs[1] = dom.createMorphAt(element2, 1, 1);
        morphs[2] = dom.createAttrMorph(element3, 'class');
        morphs[3] = dom.createElementMorph(element3);
        morphs[4] = dom.createMorphAt(element3, 0, 0);
        return morphs;
      },
      statements: [["content", "message", ["loc", [null, [3, 41], [3, 52]]], 0, 0, 0, 0], ["block", "if", [["get", "showAcceptBtn", ["loc", [null, [5, 12], [5, 25]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 6], [7, 13]]]], ["attribute", "class", ["concat", [["get", "declineClass", ["loc", [null, [8, 23], [8, 35]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["decline"], [], ["loc", [null, [8, 39], [8, 59]]], 0, 0], ["content", "declineBtn", ["loc", [null, [8, 60], [8, 74]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/common/control-box/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-control cs-control-box'],

    showHeader: _ember['default'].computed('label', function () {
      return _ember['default'].isPresent(this.get('label'));
    })

  });
});
define("cornerstone/components/common/control-box/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/control-box/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-control-input");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", ["partials/controls/control-header"], [], ["loc", [null, [1, 0], [1, 46]]], 0, 0], ["content", "yield", ["loc", [null, [3, 2], [3, 11]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/control-list/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-controls'],
    actions: {
      searchNav: function searchNav(control) {
        this.sendAction('onSearchNavigate', control);
      }
    }
  });
});
define("cornerstone/components/common/control-list/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 5,
                    "column": 4
                  },
                  "end": {
                    "line": 7,
                    "column": 4
                  }
                },
                "moduleName": "cornerstone/components/common/control-list/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("      ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("a");
                dom.setAttribute(el1, "class", "cs-control-goto");
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var element0 = dom.childAt(fragment, [1]);
                var morphs = new Array(2);
                morphs[0] = dom.createElementMorph(element0);
                morphs[1] = dom.createMorphAt(element0, 0, 0);
                return morphs;
              },
              statements: [["element", "action", ["searchNav", ["get", "control", ["loc", [null, [6, 54], [6, 61]]], 0, 0, 0, 0]], [], ["loc", [null, [6, 33], [6, 64]]], 0, 0], ["inline", "fa-icon", ["search-plus"], [], ["loc", [null, [6, 65], [6, 90]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 4,
                  "column": 2
                },
                "end": {
                  "line": 8,
                  "column": 2
                }
              },
              "moduleName": "cornerstone/components/common/control-list/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "if", [["get", "isSearching", ["loc", [null, [5, 10], [5, 21]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 4], [7, 11]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 9,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/common/control-list/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "component", [["subexpr", "locate-component", [["subexpr", "concat", ["controls/control-", ["get", "control.type", ["loc", [null, [4, 61], [4, 73]]], 0, 0, 0, 0]], [], ["loc", [null, [4, 33], [4, 75]]], 0, 0], "controls/control-base"], [], ["loc", [null, [4, 15], [4, 101]]], 0, 0]], ["control", ["subexpr", "@mut", [["get", "control", ["loc", [null, [4, 110], [4, 117]]], 0, 0, 0, 0]], [], [], 0, 0], "hidden", ["subexpr", "or", [["subexpr", "contains", [["get", "control.id", ["loc", [null, [4, 139], [4, 149]]], 0, 0, 0, 0], ["get", "hiddenControls", ["loc", [null, [4, 150], [4, 164]]], 0, 0, 0, 0]], [], ["loc", [null, [4, 129], [4, 165]]], 0, 0], ["get", "control.isHidden", ["loc", [null, [4, 166], [4, 182]]], 0, 0, 0, 0]], [], ["loc", [null, [4, 125], [4, 183]]], 0, 0]], 0, null, ["loc", [null, [4, 2], [8, 16]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 10,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/control-list/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "unless", [["subexpr", "contains", [["get", "control.id", ["loc", [null, [3, 22], [3, 32]]], 0, 0, 0, 0], ["get", "hiddenControls", ["loc", [null, [3, 33], [3, 47]]], 0, 0, 0, 0]], [], ["loc", [null, [3, 12], [3, 48]]], 0, 0]], [], 0, null, ["loc", [null, [3, 2], [9, 13]]]]],
        locals: ["control"],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 11,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/control-list/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0], ["block", "each", [["get", "controls", ["loc", [null, [2, 8], [2, 16]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 0], [10, 9]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/common/cs-picker/component', ['exports', 'ember', 'jquery'], function (exports, _ember, _jquery) {
  exports['default'] = _ember['default'].Component.extend({

    rootSelector: '.cs-app',
    modalInPosition: false,

    classNames: ['cs-picker'],
    classNameBindings: ['class', 'open:cs-active'],
    floatingSide: 'right',
    scrollEvent: 'ps-y-reach-start ps-scroll-y ps-y-reach-end ps-x-reach-start ps-scroll-x ps-x-reach-end',
    modalMode: 'hide',

    attrModalClass: _ember['default'].computed('modalClass', function () {
      return 'cs-picker-modal ' + this.get('modalClass');
    }),

    canDisplayModal: _ember['default'].computed('modalInPosition', 'modalMode', function () {
      if ('hide' === this.get('modalMode')) {
        return true;
      }
      return this.get('modalInPosition');
    }),

    onInit: _ember['default'].on('init', function () {
      this.triggerExternalOpen();
    }),

    observeExternalOpen: _ember['default'].observer('externalOpen', function () {
      this.triggerExternalOpen();
    }),

    triggerExternalOpen: function triggerExternalOpen() {
      if (this.get('externalOpen')) {
        this.set('open', true);
      }
    },

    didInsertElement: function didInsertElement() {
      this.$modal = this.$('.cs-picker-modal');
      this.set('hasRendered', true);
      this.updatePositioning();
      // if ( this.get('debug') ) {
      //   document.addEventListener('mousemove', (e) => {
      //     this.$('.cs-picker-swatch').css({
      //       position: 'fixed',
      //       width: '200px',
      //       left: e.clientX - 50,
      //       top: e.clientY - 25
      //     });
      //     this.updatePositioning();
      //   });
      // }
    },

    observeState: _ember['default'].observer('open', function () {
      this.updatePositioning();
    }),

    updatePositioning: function updatePositioning() {
      var _this = this;

      if (!this.get('hasRendered')) {
        this.set('modalInPosition', false);
        return;
      }

      var $body = (0, _jquery['default'])('body');
      var $window = (0, _jquery['default'])(window);
      var $scrollContainer = $window;
      var $swatch = this.$('.cs-picker-swatch');
      var $el = this.$();

      var loseFocus = function loseFocus(e) {

        if ($el[0] === e.currentTarget || _this.$modal[0] === e.currentTarget || _jquery['default'].contains($el[0], e.currentTarget) || !_jquery['default'].contains(_this.get('ui.topLevelEl'), e.currentTarget) || _jquery['default'].contains(_this.$modal[0], e.currentTarget)) {
          e.stopPropagation();
          return;
        }

        $body.off('focus', '*', loseFocus);
        $body.off('click', '*', loseFocus);

        if (!_this.isDestroyed) {
          _this.set('open', false);
          _this.sendAction('onStateChange', false);
        }
      };

      var move = function move() {

        var s = $swatch[0].getBoundingClientRect();
        var m = _this.$modal[0].getBoundingClientRect();

        var offsets = {
          t: s.top - m.height,
          b: $window.height() - (s.top + m.height),
          l: s.left - m.width,
          r: $window.width() - (s.right + m.width)
        };

        var h = false;
        var v = true;

        if (offsets.t < 0) {
          v = offsets.b < 0 ? offsets.b < offsets.t : false;
        }

        if (offsets.r < 0) {
          h = offsets.l < 0 ? offsets.l > offsets.r : true;
        }

        _this.$modal.removeClass('cs-picker-floating-left huebert-floating-right').addClass(h ? 'cs-picker-floating-left' : 'cs-picker-floating-right').css({
          top: v ? s.bottom - m.height : s.top,
          left: h ? s.left - m.width : s.right
        });

        if (!_this.$modal.hasClass('cs-picker-floating')) {
          $scrollContainer.off(_this.get('scrollEvent'), move);
          $window.off('resize', move);
        }
      };

      if (this.get('open')) {

        this.$modal.detach().appendTo(this.get('rootSelector'));
        this.$modal.css('visibility', 'hidden').addClass('cs-picker-floating');
        this.$modal.removeAttr('style');
        move();

        $scrollContainer.on(this.get('scrollEvent'), move);
        $window.on('resize', move);
        $body.on('focus', '*', loseFocus);
        $body.on('click', '*', loseFocus);
        this.set('modalInPosition', true);
      } else {
        this.$modal.removeClass('cs-picker-floating cs-picker-floating-left cs-picker-floating-right');
        this.set('modalInPosition', false);
        this.$modal.detach().appendTo(this.$());
      }
    },

    willDestroy: function willDestroy() {
      this._super.apply(this, arguments);
      this.set('false');
      this.$modal.remove();
    },

    actions: {
      toggle: function toggle() {
        this.set('open', !this.get('open'));
        this.sendAction('onStateChange', this.get('open'));
      }
    }
  });
});
define("cornerstone/components/common/cs-picker/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 2
            },
            "end": {
              "line": 4,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/cs-picker/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("span");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createUnsafeMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["content", "label", ["loc", [null, [3, 10], [3, 21]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 6,
              "column": 2
            },
            "end": {
              "line": 8,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/cs-picker/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "component", [["get", "contentComponent", ["loc", [null, [7, 16], [7, 32]]], 0, 0, 0, 0]], [], ["loc", [null, [7, 4], [7, 34]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 12,
              "column": 2
            },
            "end": {
              "line": 14,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/cs-picker/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["subexpr", "hash", [], ["open", ["get", "open", ["loc", [null, [13, 23], [13, 27]]], 0, 0, 0, 0]], ["loc", [null, [13, 12], [13, 28]]], 0, 0]], [], ["loc", [null, [13, 4], [13, 30]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 16,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/cs-picker/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-picker-swatch");
        dom.setAttribute(el1, "tabindex", "-1");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var element1 = dom.childAt(fragment, [2]);
        var morphs = new Array(6);
        morphs[0] = dom.createElementMorph(element0);
        morphs[1] = dom.createMorphAt(element0, 1, 1);
        morphs[2] = dom.createMorphAt(element0, 3, 3);
        morphs[3] = dom.createMorphAt(element0, 5, 5);
        morphs[4] = dom.createAttrMorph(element1, 'class');
        morphs[5] = dom.createMorphAt(element1, 1, 1);
        return morphs;
      },
      statements: [["element", "action", ["toggle"], [], ["loc", [null, [1, 44], [1, 63]]], 0, 0], ["block", "if", [["get", "label", ["loc", [null, [2, 8], [2, 13]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 2], [4, 9]]]], ["content", "content", ["loc", [null, [5, 2], [5, 13]]], 0, 0, 0, 0], ["block", "if", [["get", "contentComponent", ["loc", [null, [6, 8], [6, 24]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [6, 2], [8, 9]]]], ["attribute", "class", ["get", "attrModalClass", ["loc", [null, [11, 13], [11, 27]]], 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "canDisplayModal", ["loc", [null, [12, 8], [12, 23]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [12, 2], [14, 9]]]]],
      locals: [],
      templates: [child0, child1, child2]
    };
  })());
});
define('cornerstone/components/common/defer-view/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNameBindings: ['class'],
    enabled: true,
    ready: false,
    defer: true,

    show: _ember['default'].computed('ready', 'hide', function () {
      return this.get('ready') && !this.get('hide');
    }),

    didReceiveAttrs: function didReceiveAttrs() {
      if (!this.get('defer')) {
        this.set('ready', true);
      }
    },

    didInsertElement: function didInsertElement() {
      var _this = this;

      if (this.get('ready')) {
        return;
      }

      _ember['default'].run.scheduleOnce('afterRender', function () {

        var scrollBoxRect = _this.$().closest('.cs-scroll-box')[0].getBoundingClientRect();
        var myRect = _this.get('element').getBoundingClientRect();

        if (myRect.top <= scrollBoxRect.bottom && myRect.right >= scrollBoxRect.left && myRect.bottom >= scrollBoxRect.top && myRect.left <= scrollBoxRect.right) {
          _this.set('ready', true);
        } else {
          _ember['default'].run.later('afterRender', function () {
            _this.set('ready', true);
          }, 10);
        }
      });
    }

  });
});
define("cornerstone/components/common/defer-view/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/defer-view/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 4,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/defer-view/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "show", ["loc", [null, [1, 6], [1, 10]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [3, 7]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/common/file-upload/component', ['exports', 'ember', 'npm:dropzone'], function (exports, _ember, _npmDropzone) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-file-upload', 'dropzone'],
    maxFiles: 1,

    didInsertElement: function didInsertElement() {

      var $blankState = this.$('[data-dropzone-template="blank-state"]');
      var $preview = this.$('[data-dropzone-template="preview"]');

      this.dropzone = new _npmDropzone['default'](this.get('element'), {
        url: 'na',
        dictDefaultMessage: $blankState.html(),
        previewTemplate: $preview.html(),
        maxFiles: this.get('maxFiles'),
        accept: function accept(file, done) {
          // if (file.name === "justinbieber.jpg") {
          //   done("Naha, you don't.");
          // }
          // else { done(); }
          done();
        }
      });

      $blankState.remove();
      $preview.remove();
    }

  });
});
define("cornerstone/components/common/file-upload/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 26,
              "column": 2
            },
            "end": {
              "line": 28,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/file-upload/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [27, 4], [27, 13]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 28,
              "column": 2
            },
            "end": {
              "line": 35,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/file-upload/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-file-upload-import-welcome");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "cs-file-upload-import-welcome-icon");
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "cs-file-upload-import-welcome-text");
          var el3 = dom.createElement("strong");
          var el4 = dom.createTextNode("Choose a header data file");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode(" or drag it here to import.");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1]), 1, 1);
          return morphs;
        },
        statements: [["inline", "cs-icon", ["interface/index-choice-import"], [], ["loc", [null, [31, 8], [31, 51]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 36,
            "column": 6
          }
        },
        "moduleName": "cornerstone/components/common/file-upload/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "data-dropzone-template", "preview");
        dom.setAttribute(el1, "style", "display: none;");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "dz-preview dz-file-preview");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "dz-details");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "dz-filename");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("span");
        dom.setAttribute(el5, "data-dz-name", "");
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "dz-size");
        dom.setAttribute(el4, "data-dz-size", "");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("img");
        dom.setAttribute(el4, "data-dz-thumbnail", "");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "dz-progress");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("span");
        dom.setAttribute(el4, "class", "dz-upload");
        dom.setAttribute(el4, "data-dz-uploadprogress", "");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "dz-success-mark");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("span");
        var el5 = dom.createTextNode("✔");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "dz-error-mark");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("span");
        var el5 = dom.createTextNode("✘");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "dz-error-message");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("span");
        dom.setAttribute(el4, "data-dz-errormessage", "");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "data-dropzone-template", "blank-state");
        dom.setAttribute(el1, "style", "display: none;");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [26, 8], [26, 16]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [26, 2], [35, 9]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/common/floating-container/component', ['exports', 'ember', 'ember-click-outside/mixins/click-outside', 'ember-runloop'], function (exports, _ember, _emberClickOutsideMixinsClickOutside, _emberRunloop) {
  exports['default'] = _ember['default'].Component.extend(_emberClickOutsideMixinsClickOutside['default'], {

    classNameBindings: ['class', 'open:cs-active'],
    listening: false,

    listenWhenOpen: _ember['default'].observer('open', function () {
      this.toggleListeners(this.get('open'));
    }),

    clickOutside: function clickOutside() /* e */{
      this.sendAction('outsideClick');
    },

    toggleListeners: function toggleListeners(state) {
      var listening = this.get('listening');
      if (!state && listening) {
        //remove
        (0, _emberRunloop.cancel)(this._cancelListener);
        this.removeClickOutsideListener();
        this.set('listening', false);
      }
      if (state && !listening) {
        //add
        this._cancelListener = (0, _emberRunloop.next)(this, this.addClickOutsideListener);
        this.set('listening', true);
      }
    },

    didInsertElement: function didInsertElement() {
      this.toggleListeners(this.get('open'));
    },

    willDestroyElement: function willDestroyElement() {
      this.toggleListeners(false);
    }

  });
});
define("cornerstone/components/common/floating-container/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/floating-container/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/help-text/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: 'cs-help-text'
  });
});
define("cornerstone/components/common/help-text/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/help-text/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("h4");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("p");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [2]);
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0]), 0, 0);
        morphs[1] = dom.createMorphAt(element0, 0, 0);
        morphs[2] = dom.createMorphAt(element0, 1, 1);
        return morphs;
      },
      statements: [["content", "title", ["loc", [null, [1, 4], [1, 13]]], 0, 0, 0, 0], ["content", "message", ["loc", [null, [2, 3], [2, 14]]], 0, 0, 0, 0], ["content", "yield", ["loc", [null, [2, 14], [2, 23]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/in-view/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNameBindings: ['class'],
    enabled: true,

    ready: _ember['default'].computed('viewed', 'enabled', function () {
      if (!this.get('enabled')) {
        return true;
      }
      return this.get('viewed');
    }),

    init: function init() {
      this._super.apply(this, arguments);
      this.set('onScroll', this.onScroll.bind(this));
    },

    didInsertElement: function didInsertElement() {
      var _this = this;

      _ember['default'].run.scheduleOnce('afterRender', function () {
        _this.onScroll();
        if (!_this.get('ready')) {
          _this.addEventListeners();
        }
      });
    },

    addEventListeners: function addEventListeners() {
      _ember['default'].$(document).on('ps-scroll-x ps-scroll-y', this.onScroll);
      _ember['default'].$(document.body).on('scroll', this.onScroll);
    },

    removeEventListeners: function removeEventListeners() {
      _ember['default'].$(document).off('ps-scroll-x ps-scroll-y', this.onScroll);
      _ember['default'].$(document.body).off('scroll', this.onScroll);
    },

    onScroll: function onScroll() {
      this.detectScrollbox();
      var myRect = this.get('element').getBoundingClientRect();

      var scrollBoxRect = this.scrollBox.getBoundingClientRect();
      if (myRect.top <= scrollBoxRect.bottom && myRect.right >= scrollBoxRect.left && myRect.bottom >= scrollBoxRect.top && myRect.left <= scrollBoxRect.right) {
        this.set('ready', true);
        this.removeEventListeners();
      }
    },

    detectScrollbox: function detectScrollbox() {
      if (!this.scrollBox) {
        this.scrollBox = this.$().closest('.cs-scroll-box')[0];
      }
    },

    willDestroyElement: function willDestroyElement() {
      this.removeEventListeners();
    }

  });
});
define("cornerstone/components/common/in-view/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/in-view/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 5,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/in-view/template.hbs"
        },
        isEmpty: true,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 7
          }
        },
        "moduleName": "cornerstone/components/common/in-view/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "ready", ["loc", [null, [1, 6], [1, 11]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [5, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/common/index-entry/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-index-entry'],
    classNameBindings: ['selected:cs-active', 'isNew:cs-new'],

    click: function click() {
      this.sendAction();
    },

    actions: {
      titleUpdate: function titleUpdate() {
        this.sendAction('titleUpdate');
      }
    }

  });
});
define("cornerstone/components/common/index-entry/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 2
            },
            "end": {
              "line": 4,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/index-entry/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-index-entry-info-meta");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createUnsafeMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["content", "meta", ["loc", [null, [3, 40], [3, 50]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/index-entry/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-index-entry-info");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("h2");
        dom.setAttribute(el2, "class", "cs-index-entry-info-title");
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-index-entry-actions");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(element0, 1, 1);
        morphs[1] = dom.createMorphAt(dom.childAt(element0, [3]), 0, 0);
        morphs[2] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        return morphs;
      },
      statements: [["block", "if", [["get", "meta", ["loc", [null, [2, 8], [2, 12]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 2], [4, 9]]]], ["inline", "forms/inline-edit", [], ["value", ["subexpr", "@mut", [["get", "title", ["loc", [null, [5, 66], [5, 71]]], 0, 0, 0, 0]], [], [], 0, 0], "action", ["subexpr", "action", ["titleUpdate"], [], ["loc", [null, [5, 79], [5, 101]]], 0, 0]], ["loc", [null, [5, 40], [5, 103]]], 0, 0], ["content", "yield", ["loc", [null, [8, 2], [8, 11]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/common/link-out/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'a',
    classNameBindings: ['class'],
    attributeBindings: ['href'],
    output: _ember['default'].computed('content', function () {
      return _ember['default'].String.htmlSafe(this.get('content'));
    }),

    click: function click(e) {
      var _this = this;

      if (this.get('ui.unsavedData')) {

        e.preventDefault();
        this.get('ui').confirm({
          noSkip: true,
          message: this.get('i18n').t('app.unsaved-warning'),
          accept: function accept() {
            window.location = _this.get('href');
          },
          acceptClass: 'sad'
        });
      }
    }
  });
});
define("cornerstone/components/common/link-out/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/link-out/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 5,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/link-out/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createUnsafeMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "output", ["loc", [null, [4, 2], [4, 14]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/link-out/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [5, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/common/loading-indicator/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-loading-indicator'],
    attributeBindings: ['style:safeStyle'],
    safeStyle: _ember['default'].computed('style', function () {
      return _ember['default'].String.htmlSafe(this.get('style'));
    })
  });
});
define("cornerstone/components/common/loading-indicator/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 10
          }
        },
        "moduleName": "cornerstone/components/common/loading-indicator/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("Loading...");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes() {
        return [];
      },
      statements: [],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/preview-frame/component', ['exports', 'ember', 'cornerstone/mixins/hover-state', 'cornerstone/xfr/mixins/agent', 'cornerstone/mixins/preview-listener', 'npm:url-parse', 'npm:js-base64'], function (exports, _ember, _cornerstoneMixinsHoverState, _cornerstoneXfrMixinsAgent, _cornerstoneMixinsPreviewListener, _npmUrlParse, _npmJsBase64) {
  var Base64 = _npmJsBase64['default'].Base64;

  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsPreviewListener['default'], _cornerstoneXfrMixinsAgent['default'], _cornerstoneMixinsHoverState['default'], {

    xfrOrigin: 'app',

    config: _ember['default'].inject.service(),
    radio: _ember['default'].inject.service('global/radio'),

    ui: _ember['default'].inject.service(),
    debugLogging: _ember['default'].computed.alias('ui.debugEnabled'),

    ready: false,
    showAsLoading: true,
    loadedOnce: false,
    loadError: false,
    allowPreviewSizer: true,
    usePreloader: true,
    canResize: true,
    state: {},
    name: 'generic',
    content: 'default',
    showStatusIndicator: false,
    statusIndicatorMode: 'loading',
    shrink: false,

    classNames: ['cs-preview-frame'],
    classNameBindings: ['shrink:cs-preview-frame-mini:cs-preview-frame-full', 'noPreviewPointer:cs-preview-frame-no-pointer'],

    noPreviewPointer: _ember['default'].computed('ui.noPreviewPointer', 'shrink', function () {
      return this.get('ui.noPreviewPointer') || this.get('shrink');
    }),

    clientShowPreloader: true,
    preLoaderComplete: _ember['default'].computed('ready', 'clientShowPreloader', function () {
      return this.get('ready') && !this.get('clientShowPreloader');
    }),

    previewSizeClass: _ember['default'].computed('canResize', 'ui.previewSize', function () {
      if (!this.get('canResize')) {
        return;
      }
      return 'cs-preview-size-' + this.get('ui.previewSize');
    }),

    showPreviewSizer: _ember['default'].computed('shrink', 'allowPreviewSizer', 'ui.routeEnabledPreviewSizer', function () {
      return this.get('allowPreviewSizer') && !this.get('shrink') && this.get('ui.routeEnabledPreviewSizer');
    }),

    encodedState: _ember['default'].computed('state.inc', function () {
      return Base64.encode(JSON.stringify(this.get('state')));
    }),

    detectStateChange: _ember['default'].observer('src', 'state.inc', function () {
      this.generateIframeDebounce();
    }),

    generateIframeDebounce: function generateIframeDebounce() {
      _ember['default'].run.debounce(this, this.generateIframe, 215);
    },

    init: function init() {
      var _this = this;

      this._super.apply(this, arguments);

      this.componentListenTo('navigate', function (params) {
        return _this.sendAction('navigate', params);
      });

      this.componentListenTo('status-indicator', function (_ref) {
        var show = _ref.show;
        var mode = _ref.mode;

        _this.set('showStatusIndicator', show);
        _this.set('statusIndicatorMode', mode);
      });

      this.componentListenTo('pre-loader-state', function (_ref2) {
        var show = _ref2.show;

        if (!show) {
          _ember['default'].run.cancel(_this.waitForClientPreloader);
        }
        _this.set('clientShowPreloader', show);
      });

      this.componentListenTo('preview:package:setup', function (data, resolve) {
        _this.set('canUpdatePackage', true);
        resolve(_this.get('package'));
      });

      // These listeners don't need to be in the frame component
      this.componentListenTo('preview:event-propagation', function (_ref3) {
        var event = _ref3.event;
        return _this.synthesizeEvent(event);
      });
      this.componentListenTo('preview:action-propagation', function (_ref4) {
        var action = _ref4.action;
        return _this.get('ui.primaryRoute').send(action);
      });

      this.componentListenTo('preview:error-message', function (_ref5) {
        var key = _ref5.key;

        console.log('preview-error.' + key);
        _this.get('ui').notify({
          type: 'error',
          message: _this.get('i18n').t('app.preview-error.' + key),
          timeout: 15000,
          extendedTimeout: 650
        });
      });

      this.componentListenTo('observer', function (event) {
        this.sendAction(_ember['default'].String.camelize('on-observer-' + event.type), event);
      });

      this.componentListenTo('remote-action', function (event) {
        this.sendAction('onRemoteAction', event);
      });
    },

    didInsertElement: function didInsertElement() {
      this.set('rendered', true);
      this.generateIframeDebounce();
    },

    packageChange: _ember['default'].observer('package', function () {
      if (!this.get('canUpdatePackage')) {
        return;
      }
      this.message('preview:package:update', this.get('package'));
    }),

    generateIframe: function generateIframe() {
      var _this2 = this;

      if (!this.get('rendered') || this.isDestroyed) {
        return;
      }

      this.set('showAsLoading', true);
      this.set('ready', false);

      var loadFailure = function loadFailure(cb) {
        _this2.set('loadError', true);
        _this2.set('ready', true);
        if ('function' === typeof cb) {
          cb.call(_this2);
        }
      };

      this.requestHTML(_ember['default'].copy(this.get('state'))).then(function (_ref6) {
        var html = _ref6.html;
        var state = _ref6.state;

        if (_this2.isDestroyed) {
          return;
        }

        _ember['default'].run.cancel(_this2.scheduledUpdate);
        _this2.scheduledUpdate = _ember['default'].run.scheduleOnce('afterRender', function () {
          if (_this2.isDestroyed) {
            return;
          }
          var $newFrame = _ember['default'].$('<iframe />');
          _this2.$('.cs-preview-frame-container').append($newFrame);

          var frameWindow = $newFrame[0].contentWindow;

          frameWindow.document.open();
          frameWindow.document.write(html);
          frameWindow.document.close();

          // $newFrame[0].contentDocument.title = `Cornerstone Preview (${state.timestamp})`;
          _ember['default'].run.cancel(_this2.loadTimeout);
          _this2.loadTimeout = _ember['default'].run.later(function () {
            if (_this2.isDestroyed) {
              return;
            }
            loadFailure(function () {
              _this2.$('iframe').not($newFrame).remove();
              _this2.get('ui').incrementProperty('previewDelayed');
              console.warn('Preview timeout');
            });
          }, (_this2.get('ui.previewDelayed') + 1) * 15000);

          _this2.initFrame($newFrame[0], state.timestamp, function () {

            // We know the iframe has booted the preview
            _this2.$('iframe').not($newFrame).remove();
            _ember['default'].run.cancel(_this2.loadTimeout);
            _this2.set('loadError', false);
            _this2.set('ready', true);

            _this2.waitForClientPreloader = _ember['default'].run.later(function () {
              if (!_this2.isDestroyed && _this2.get('clientShowPreloader') && _this2.get('usePreloader')) {
                console.warn('The preview booted, but never requested the loader be removed.', _this2.get('ui.previewDelayed'));
                _this2.set('loadError', true);
                _this2.get('ui').incrementProperty('previewDelayed');
              }
            }, (_this2.get('ui.previewDelayed') + 1) * 15000);
          });
        });
      }, function (reason) {

        _ember['default'].Logger.warn('preview-frame::update-aborted', reason);

        if (!reason || false !== reason.error) {
          loadFailure();
        }
      });
    },

    requestHTML: function requestHTML(state) {
      var _this3 = this;

      return new _ember['default'].RSVP.Promise(function (resolve, reject) {

        var parsed = (0, _npmUrlParse['default'])(_this3.get('src'), true);
        var url = '' + parsed.origin + parsed.pathname;

        if ('/' !== url.charAt(url.length - 1)) {
          url += '/';
        }

        var timestamp = Date.now();
        state.timestamp = 't-' + timestamp; // Use a string to prevent rounding across systems.

        var data = _ember['default'].assign({}, {
          _cs_nonce: _this3.get('config.global._cs_nonce'),
          cs_preview_state: Base64.encode(JSON.stringify(state))
        }, _this3.getWithDefault('requestParams', {}), parsed.query);

        if (_this3.get('debugLogging')) {
          console.log('Requesting iFrame HTML', url, data);
        }

        _ember['default'].$.ajax({ type: 'POST', url: url, data: data }).done(function (r, textStatus, jqXHR) {

          if (_this3.get('lastUpdate') > timestamp) {
            reject({ error: false, message: 'updated since request' });
            return;
          }
          _this3.get('lastUpdate', timestamp);

          var response = jqXHR.responseText;
          var signature = 'CORNERSTONE_FRAME';

          if (_this3.get('debugLogging')) {
            console.log('Receiving iFrame HTML', jqXHR);
          }

          var index = response.lastIndexOf(signature);
          if (-1 === index || index < response.lastIndexOf('</html>')) {
            reject({ error: true, message: 'incomplete', response: response });
            return;
          }

          var html = response.slice(0, index) + response.slice(index + signature.length);
          resolve({ html: html, state: state });
        }).fail(function (jqXHR) {
          return reject(jqXHR);
        });
      });
    },

    initFrame: function initFrame(frame, time, callback) {
      var _this4 = this;

      this.closeChannel();
      var channel = new MessageChannel();
      channel.port1.addEventListener('message', this.get('xfrOnMessage'), false);
      channel.port1.start();
      this.set('messageChannel', channel);
      this.set('xfrMessagePort', channel.port1);
      // console.log('CHANNEL SETUP');

      this.set('boundiFrameLoaded', function (e) {

        if (_this4.get('debugLogging')) {
          console.log('Preview frame [' + time + '] recieving message', e);
        }

        if ('cs-preview-port-request::' + time === e.data) {
          frame.contentWindow.postMessage('cs-preview-port', '*', [channel.port2]);
          callback();
        }
      });

      window.addEventListener('message', this.get('boundiFrameLoaded'), false);
    },

    willDestroyElement: function willDestroyElement() {
      //console.log('Destroying frame');
      this.get('radio').off('outgoing:message', this.get('boundOutgoingMessage'));
      this.closeChannel();
    },

    closeChannel: function closeChannel() {
      window.removeEventListener('message', this.get('boundiFrameLoaded'), false);
      var channel = this.get('messageChannel');
      if (channel) {
        channel.port1.removeEventListener('message', this.get('xfrOnMessage'), false);
        channel.port1.close();
      }
    },

    synthesizeEvent: function synthesizeEvent(event) {

      if (['mousedown', 'mouseup', 'click'].includes(event.type)) {
        dispatchMouseEvent(event.type, event);
      } else if (['keydown', 'keypress', 'keyup'].includes(event.type)) {
        dispatchKeyboardEvent(event.type, event);
      }

      function dispatchMouseEvent(type, args) {

        var init = _ember['default'].assign({}, args, {
          'view': window,
          'bubbles': true,
          'cancelable': true
        });
        delete init.type;

        var event = new MouseEvent(type, init);

        return !!window.dispatchEvent(event);
      }

      function dispatchKeyboardEvent(type, args) {

        var init = _ember['default'].assign({}, args, {
          'view': window,
          'bubbles': true,
          'cancelable': true
        });

        delete init.type;

        var event = new KeyboardEvent(type, init);
        event.synthesizedWhich = args.which;
        return !!document.body.dispatchEvent(event);
      }
    },

    actions: {
      closeLoader: function closeLoader() {
        this.set('loadedOnce', true);
        this.set('showAsLoading', false);
      },
      reloadAfterTimeout: function reloadAfterTimeout() {
        this.set('showAsLoading', true);
        this.set('loadError', false);
        this.set('ready', false);
        this.generateIframeDebounce();
      }
    }

  });
});

// import queryString from 'npm:query-string';
define('cornerstone/components/common/preview-frame/overlay-action/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-preview-frame-overlay-action'],
    attributeBindings: ['ui.scrollBarWidthRightStyle:style']
  });
});
define("cornerstone/components/common/preview-frame/overlay-action/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/preview-frame/overlay-action/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/preview-frame/pre-loader/component', ['exports', 'ember', 'cornerstone/mixins/fadeable'], function (exports, _ember, _cornerstoneMixinsFadeable) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsFadeable['default'], {
    classNames: ['cs-pre-loader'],
    classNameBindings: ['incomplete:cs-active', 'refreshing:cs-pre-loader-semi-transparent'],
    content: 'default',
    contentPartial: _ember['default'].computed('content', function () {
      return 'iframe-loaders/' + this.get('content');
    })
  });
});
define("cornerstone/components/common/preview-frame/pre-loader/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/preview-frame/pre-loader/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "contentPartial", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/preview-frame/preview-sizer/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-preview-sizer'],
    classNameBindings: ['sizeClass', 'active:cs-active'],

    active: _ember['default'].computed.alias('ui.showPreviewSizer'),
    size: _ember['default'].computed.alias('ui.previewSize'),

    init: function init() {
      this._super.apply(this, arguments);
      var i18n = this.get('i18n');
      var sizes = ['xl', 'lg', 'md', 'sm', 'xs'];
      var icons = {};

      sizes.forEach(function (s) {
        icons[s] = {
          icon: 'interface/preview-sizer-' + s,
          abbr: i18n.t('app.preview-sizer-abbr-' + s),
          desc: i18n.t('app.preview-sizer-desc-' + s)
        };
      });

      this.set('icons', icons);
    },

    sizeClass: _ember['default'].computed('size', function () {
      return 'cs-preview-sizer-' + this.get('size');
    }),

    actions: {
      selectSize: function selectSize(size) {
        this.set('size', size);
      }
    }

  });
});
define("cornerstone/components/common/preview-frame/preview-sizer/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/preview-frame/preview-sizer/template.hbs"
        },
        isEmpty: false,
        arity: 2,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("span");
          dom.setAttribute(el2, "class", "cs-preview-sizer-abbr");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("span");
          dom.setAttribute(el2, "class", "cs-preview-sizer-desc");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(5);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          morphs[1] = dom.createElementMorph(element0);
          morphs[2] = dom.createMorphAt(element0, 1, 1);
          morphs[3] = dom.createMorphAt(dom.childAt(element0, [3]), 0, 0);
          morphs[4] = dom.createMorphAt(dom.childAt(element0, [5]), 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "sz", ["loc", [null, [2, 26], [2, 28]]], 0, 0, 0, 0], ["get", "size", ["loc", [null, [2, 29], [2, 33]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 22], [2, 34]]], 0, 0], "cs-active"], [], ["loc", [null, [2, 17], [2, 48]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["selectSize", ["get", "sz", ["loc", [null, [2, 72], [2, 74]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 50], [2, 76]]], 0, 0], ["inline", "cs-icon", [["get", "item.icon", ["loc", [null, [3, 14], [3, 23]]], 0, 0, 0, 0]], [], ["loc", [null, [3, 4], [3, 25]]], 0, 0], ["content", "item.abbr", ["loc", [null, [4, 40], [4, 53]]], 0, 0, 0, 0], ["content", "item.desc", ["loc", [null, [5, 40], [5, 53]]], 0, 0, 0, 0]],
        locals: ["sz", "item"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 7,
            "column": 12
          }
        },
        "moduleName": "cornerstone/components/common/preview-frame/preview-sizer/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "each-in", [["get", "icons", ["loc", [null, [1, 11], [1, 16]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [7, 12]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("cornerstone/components/common/preview-frame/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/preview-frame/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "common/preview-frame/preview-sizer", ["loc", [null, [2, 2], [2, 40]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 7,
                "column": 4
              },
              "end": {
                "line": 14,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/common/preview-frame/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "common/preview-frame/pre-loader", [], ["refreshing", ["subexpr", "@mut", [["get", "loadedOnce", ["loc", [null, [9, 19], [9, 29]]], 0, 0, 0, 0]], [], [], 0, 0], "complete", ["subexpr", "@mut", [["get", "preLoaderComplete", ["loc", [null, [10, 17], [10, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "onComplete", ["subexpr", "action", ["closeLoader"], [], ["loc", [null, [11, 19], [11, 41]]], 0, 0], "content", ["subexpr", "@mut", [["get", "preloader", ["loc", [null, [12, 16], [12, 25]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [8, 6], [13, 8]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 6,
              "column": 2
            },
            "end": {
              "line": 15,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/preview-frame/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "showAsLoading", ["loc", [null, [7, 10], [7, 23]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [7, 4], [14, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 16,
              "column": 2
            },
            "end": {
              "line": 29,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/preview-frame/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-preview-load-error-outer cs-active");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "cs-preview-load-error-inner");
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "cs-action-modal-content");
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          dom.setAttribute(el4, "class", "cs-action-modal-message");
          var el5 = dom.createTextNode("\n            ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("p");
          var el6 = dom.createTextNode("A conflict on the front end of your site has prevented the preview from loading.");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n          ");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          dom.setAttribute(el4, "class", "cs-action-modal-actions");
          var el5 = dom.createTextNode("\n            ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("button");
          var el6 = dom.createTextNode("Try again");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n          ");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n        ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1, 1, 1, 3, 1]);
          var morphs = new Array(1);
          morphs[0] = dom.createElementMorph(element0);
          return morphs;
        },
        statements: [["element", "action", ["reloadAfterTimeout"], [], ["loc", [null, [24, 20], [24, 51]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 32,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/preview-frame/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element1 = dom.childAt(fragment, [3]);
        var morphs = new Array(6);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        morphs[2] = dom.createAttrMorph(element1, 'class');
        morphs[3] = dom.createMorphAt(element1, 1, 1);
        morphs[4] = dom.createMorphAt(element1, 2, 2);
        morphs[5] = dom.createMorphAt(element1, 4, 4);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "if", [["get", "showPreviewSizer", ["loc", [null, [1, 6], [1, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [3, 7]]]], ["inline", "common/status-indicator", [], ["active", ["subexpr", "@mut", [["get", "showStatusIndicator", ["loc", [null, [4, 33], [4, 52]]], 0, 0, 0, 0]], [], [], 0, 0], "mode", ["subexpr", "@mut", [["get", "statusIndicatorMode", ["loc", [null, [4, 58], [4, 77]]], 0, 0, 0, 0]], [], [], 0, 0], "style", ["subexpr", "@mut", [["get", "ui.scrollBarWidthRightStyle", ["loc", [null, [4, 84], [4, 111]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [4, 0], [4, 113]]], 0, 0], ["attribute", "class", ["concat", ["cs-preview-frame-container ", ["get", "previewSizeClass", ["loc", [null, [5, 41], [5, 57]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "usePreloader", ["loc", [null, [6, 8], [6, 20]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [6, 2], [15, 9]]]], ["block", "if", [["get", "loadError", ["loc", [null, [16, 8], [16, 17]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [16, 2], [29, 9]]]], ["content", "yield", ["loc", [null, [30, 2], [30, 11]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1, child2]
    };
  })());
});
define('cornerstone/components/common/scroll-box/component', ['exports', 'ember', 'npm:perfect-scrollbar'], function (exports, _ember, _npmPerfectScrollbar) {
  exports['default'] = _ember['default'].Component.extend({

    classNameBindings: ['enabled:cs-scroll-box:cs-scroll-box-disabled', 'name', 'class'],
    enabled: true,
    ready: false,
    initialized: false,
    autoRefresh: false, // 150,
    scrollEvents: ['ps-scroll-y', 'ps-y-reach-start', 'ps-y-reach-end', 'ps-scroll-x', 'ps-x-reach-start', 'ps-x-reach-end'],

    horizontalScrollSupport: _ember['default'].computed.alias('ui.horizontalScrollSupport'),

    configChange: _ember['default'].observer('horizontalScrollSupport', function () {
      this.psInit();
    }),

    psInit: function psInit() {

      var el = this.get('element');
      var useBothWheelAxes = !this.get('horizontalScrollSupport');

      el.removeEventListener('wheel', this.get('wheelCheck'));
      if (useBothWheelAxes) {
        el.addEventListener('wheel', this.get('wheelCheck'));
      }

      _npmPerfectScrollbar['default'].destroy(el);
      _npmPerfectScrollbar['default'].initialize(el, {
        wheelSpeed: 2,
        scrollYMarginOffset: 0,
        scrollXMarginOffset: 0,
        wheelPropagation: false,
        swipePropagation: false,
        useBothWheelAxes: useBothWheelAxes,
        minScrollbarLength: 20
      });
    },

    wheelCheck: function wheelCheck(e) {
      if (Math.abs(e.deltaX) > 0) {
        this.set('ui.horizontalScrollSupport', true);
      }
    },

    init: function init() {
      this._super.apply(this, arguments);
      this.set('scrollHander', this.get('scrollHander').bind(this));
      this.set('wheelCheck', this.get('wheelCheck').bind(this));
      this.get('searchTarget');
    },

    scrollHander: function scrollHander(e) {

      if (e.target !== this.get('element')) {
        return;
      }

      // Note: improper use of run.debounce
      _ember['default'].run.debounce(this, function () {
        this.sendAction('onScroll', this, this.get('element'), e.type);
      }, 25);
    },

    setupTeardown: _ember['default'].observer('ready', function () {
      if (!this.get('ready')) {
        _ember['default'].run.cancel(this.autoRefreshSchedule);
      }

      this.refresh();
    }),

    enabledChanged: _ember['default'].observer('enabled', function () {

      if (!this.get('ready')) {
        return;
      }

      _ember['default'].run(this, this.refresh);
    }),

    refresh: function refresh() {

      if (this.get('enabled')) {

        if (this.get('initialized')) {

          _npmPerfectScrollbar['default'].update(this.get('element'));
        } else {

          this.psInit();

          this.get('scrollEvents').forEach((function (event) {
            document.addEventListener(event, this.get('scrollHander'));
          }).bind(this));

          this.set('initialized', true);
          var _scrollTo = this.get('scrollTo');
          if (_scrollTo) {
            this.updateScrollTo(_scrollTo);
          }
        }

        if (this.get('autoRefresh')) {
          this.autoRefreshSchedule = _ember['default'].run.later(this, this.refresh, this.get('autoRefresh'));
        }
      } else if (this.get('element') && this.get('initialized')) {
        this.tearDown();
      }
    },

    tearDown: function tearDown() {
      _npmPerfectScrollbar['default'].destroy(this.get('element'));
      this.set('initialized', false);
    },

    didInsertElement: function didInsertElement() {
      this._super.apply(this, arguments);
      this.set('ready', true);
    },

    willDestroyElement: function willDestroyElement() {
      this.set('ready', false);
      if (this.get('initialized')) {
        this.tearDown();
      }

      this.get('element').removeEventListener('wheel', this.get('wheelCheck'));
      this.get('scrollEvents').forEach((function (event) {
        document.removeEventListener(event, this.get('scrollHander'));
      }).bind(this));
    },

    scrollToObserver: _ember['default'].observer('scrollTo', function () {
      this.updateScrollTo(this.get('scrollTo'));
    }),

    updateScrollTo: function updateScrollTo(params) {

      var el = this.get('element');
      if (!this.get('initialized') || !el) {
        return;
      }

      var left = 0;
      var top = 0;

      if (!params.start) {
        var $scrollTo = params.$el ? params.$el : this.$(params.selector).first();

        if ($scrollTo.length > 0) {
          left = $scrollTo.position().left + el.scrollLeft;
          top = $scrollTo.position().top + el.scrollTop;
        }
      }

      var offset = isNaN(params.offset) ? 0 : params.offset;
      var atts = params.horizontal ? { scrollLeft: left + offset } : { scrollTop: top + offset };

      this.set('isScrollingTo', true);

      this.$().animate(atts, {
        duration: isNaN(params.duration) ? 450 : params.duration,
        //easing: 'easeOutExpo',
        complete: (function () {
          if (!this.isDestroyed) {
            _npmPerfectScrollbar['default'].update(el);
            this.set('isScrollingTo', false);
            if (params.reset) {
              _npmPerfectScrollbar['default'].update(el);
            }
            if ('function' === _ember['default'].typeOf(params.after)) {
              params.after();
            }
          }
        }).bind(this)
      });
    },

    search: _ember['default'].inject.service(),
    searchTarget: _ember['default'].computed('linkedSearch', function () {
      return this.get('search').getTarget(this.get('linkedSearch'));
    }),

    resetScroll: _ember['default'].observer('searchTarget.query', 'resetScrollOn', 'resetScrollOn.[]', function () {

      var el = this.get('element');

      // Note: improper use of run.debounce
      _ember['default'].run.debounce(this, function () {

        _ember['default'].run.scheduleOnce('afterRender', function () {
          el.scrollTop = 0;
          el.scrollLeft = 0;
          _npmPerfectScrollbar['default'].update(el);
        });
      }, 25);
    })

  });
});
define("cornerstone/components/common/scroll-box/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/common/scroll-box/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/search-bar/component', ['exports', 'ember', 'cornerstone/mixins/keyboard-shortcuts/component'], function (exports, _ember, _cornerstoneMixinsKeyboardShortcutsComponent) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsKeyboardShortcutsComponent['default'], {
    classNameBindings: ['customClass'],
    customClass: 'cs-search-bar',

    keyboardShortcuts: {
      'esc': 'clear',
      'find': 'focus'
    },

    focusOnShortcut: true,
    autoFocus: false,
    showIcon: true,

    search: _ember['default'].inject.service(),
    searchTarget: _ember['default'].computed('target', function () {
      return this.get('search').getTarget(this.get('target'));
    }),

    isSearching: _ember['default'].computed.alias('query', function () {
      return !!this.get('query');
    }),

    init: function init() {
      this._super.apply(this, arguments);

      if (_ember['default'].isNone(this.get('query'))) {
        _ember['default'].defineProperty(this, 'query', _ember['default'].computed.alias('searchTarget.query'));
        this.get('searchTarget');
      }
    },

    didInsertElement: function didInsertElement() {
      this.updateInput();
      if (this.get('autoFocus')) {
        this.$('input[type=search]').focus();
      }
    },

    updateQuery: _ember['default'].observer('query', function () {

      if (this.get('query') !== this.$('input[type=search]').val()) {
        this.updateInput();
      }
    }),

    updateInput: function updateInput() {
      this.$('input[type=search]').val(this.get('query'));
    },

    keyUp: function keyUp() {
      this.set('query', this.$('input[type=search]').val());
    },

    shouldShowClear: _ember['default'].computed('isSearching', 'alwaysShowClear', function () {
      if (this.get('alwaysShowClear')) {
        return true;
      }
      return this.get('isSearching');
    }),

    actions: {
      clear: function clear() {
        this.set('query', '');
        this.sendAction('onCloseSearch');
      },
      focus: function focus() {
        if (this.get('focusOnShortcut')) {
          this.$('input[type=search]').focus();
        }
      }
    }

  });
});
define("cornerstone/components/common/search-bar/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 2,
              "column": 49
            }
          },
          "moduleName": "cornerstone/components/common/search-bar/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createElement("span");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0]), 0, 0);
          return morphs;
        },
        statements: [["inline", "fa-icon", ["search"], [], ["loc", [null, [2, 22], [2, 42]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 90
            }
          },
          "moduleName": "cornerstone/components/common/search-bar/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createElement("span");
          dom.setAttribute(el1, "class", "cs-clear");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [0]);
          var morphs = new Array(2);
          morphs[0] = dom.createElementMorph(element0);
          morphs[1] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["element", "action", ["clear"], [], ["loc", [null, [3, 45], [3, 63]]], 0, 0], ["inline", "fa-icon", ["close"], [], ["loc", [null, [3, 64], [3, 83]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 4,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/search-bar/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("input");
        dom.setAttribute(el1, "type", "search");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element1 = dom.childAt(fragment, [0]);
        var morphs = new Array(4);
        morphs[0] = dom.createAttrMorph(element1, 'class');
        morphs[1] = dom.createAttrMorph(element1, 'placeholder');
        morphs[2] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[3] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        return morphs;
      },
      statements: [["attribute", "class", ["concat", [["subexpr", "if", [["get", "noFocus", ["loc", [null, [1, 19], [1, 26]]], 0, 0, 0, 0], "cs-no-input-focus"], [], ["loc", [null, [1, 14], [1, 48]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "placeholder", ["concat", [["get", "placeholder", ["loc", [null, [1, 79], [1, 90]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "showIcon", ["loc", [null, [2, 6], [2, 14]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 0], [2, 56]]]], ["block", "if", [["get", "shouldShowClear", ["loc", [null, [3, 6], [3, 21]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [3, 0], [3, 97]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/common/sortable-container/component', ['exports', 'ember', 'cornerstone/util/dragula'], function (exports, _ember, _cornerstoneUtilDragula) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'ul',
    classNames: ['cs-sortable'],
    classNameBindings: ['isDragging:cs-sorting'],
    isDragging: false,

    didInsertElement: function didInsertElement() {
      var _this = this;

      var drake = (0, _cornerstoneUtilDragula['default'])({
        moves: function moves(el, source, handle /*, sibling*/) {
          var $itemHandle = _ember['default'].$(el).find('> .cs-sortable-item-handle');
          var $handle = _ember['default'].$(handle);
          return _ember['default'].$.contains($itemHandle[0], $handle[0]);
        },
        offset: function offset(_offset, e, item) {
          _offset.y = _ember['default'].$(item).find('> .cs-sortable-item-handle').height() / 2; // snap to vertical center of handle
          return _offset;
        },
        revertOnSpill: true,
        mirrorContainer: this.get('element')
      });

      drake.containers.push(this.get('element'));

      drake.on('drag', function () {
        _this.set('isDragging', true);
        _this.get('ui').set('noPreviewPointer', true);
      });

      drake.on('dragend', function () {
        _this.set('isDragging', false);
        _this.get('ui').set('noPreviewPointer', false);
      });

      // drake.on('drop', function( el, target, source, sibling ) {
      //   Ember.$(el).triggerHandler( 'dragula:drop', window.jQuery(sibling).index() - 1 );
      // });
    }
  });
});
define("cornerstone/components/common/sortable-container/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/sortable-container/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/sortable-item/component', ['exports', 'ember', 'cornerstone/mixins/dragula-events'], function (exports, _ember, _cornerstoneMixinsDragulaEvents) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsDragulaEvents['default'], {

    tagName: 'li',
    classNames: ['cs-sortable-item'],
    classNameBindings: ['active:cs-active', 'hasDrawer:cs-sortable-item-has-drawer'],

    dragulaEvents: ['element'],

    canEditLabel: true,
    canQuickDelete: true,
    showAddAfter: false,
    addLabel: _ember['default'].computed(function () {
      return this.get('i18n').t('app.add-item');
    }),

    deleteConfirm: _ember['default'].computed('ui.deleteConfirm', function () {
      return this.get('canQuickDelete') && this.get('ui.deleteConfirm');
    }),

    canShowAddAfter: _ember['default'].computed('showAddAfter', 'onAddAfter', function () {
      return this.get('showAddAfter') && this.get('onAddAfter');
    }),

    dragulaDrop: function dragulaDrop(e, el, target, source, sibling) {
      var index = _ember['default'].$(sibling).index() - 1;
      this.sendAction('onDropIndex', this.get('itemIndex'), index);
      this.sendAction('onDrop', this.get('item'), index);
    },

    didInsertElement: function didInsertElement() {
      var _this = this;

      this.$().children('.cs-sortable-item-handle').on('mouseenter', function () {
        if (_this.isDestroyed) {
          return;
        }
        _this.sendAction('onMouseEnter');
      }).on('mouseleave', function () {
        if (_this.isDestroyed) {
          return;
        }
        _this.sendAction('onMouseLeave');
      });
    },

    actions: {
      selectFromButton: function selectFromButton() {
        this.sendAction('onSelect');
      },
      selectFromLabel: function selectFromLabel() {
        if (!this.get('hasDrawer')) {
          this.sendAction('onSelect');
        }
      },
      addBefore: function addBefore() {
        this.sendAction('onAddBefore');
      },
      addAfter: function addAfter() {
        this.sendAction('onAddAfter');
      }
    }
  });
});
define("cornerstone/components/common/sortable-item/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "cs-add-sortable-item-before");
          var el2 = dom.createElement("span");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element8 = dom.childAt(fragment, [1]);
          var element9 = dom.childAt(element8, [0]);
          var morphs = new Array(3);
          morphs[0] = dom.createElementMorph(element8);
          morphs[1] = dom.createMorphAt(element9, 0, 0);
          morphs[2] = dom.createMorphAt(element9, 1, 1);
          return morphs;
        },
        statements: [["element", "action", ["addBefore"], ["allowedKeys", "any"], ["loc", [null, [2, 10], [2, 50]]], 0, 0], ["inline", "fa-icon", ["plus"], [], ["loc", [null, [2, 93], [2, 111]]], 0, 0], ["content", "addLabel", ["loc", [null, [2, 111], [2, 123]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 5,
              "column": 2
            },
            "end": {
              "line": 7,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "cs-sortable-item-handle-toggle");
          var el2 = dom.createElement("span");
          var el3 = dom.createTextNode(" ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element7 = dom.childAt(fragment, [1]);
          var morphs = new Array(1);
          morphs[0] = dom.createElementMorph(element7);
          return morphs;
        },
        statements: [["element", "action", ["selectFromButton"], [], ["loc", [null, [6, 51], [6, 80]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 18,
              "column": 4
            },
            "end": {
              "line": 20,
              "column": 4
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("      ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element6 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element6, 'title');
          morphs[1] = dom.createElementMorph(element6);
          morphs[2] = dom.createMorphAt(element6, 0, 0);
          return morphs;
        },
        statements: [["attribute", "title", ["concat", [["get", "control.label", ["loc", [null, [19, 49], [19, 62]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", [["get", "control.action", ["loc", [null, [19, 23], [19, 37]]], 0, 0, 0, 0]], [], ["loc", [null, [19, 14], [19, 39]]], 0, 0], ["inline", "icon", [["get", "control.icon", ["loc", [null, [19, 73], [19, 85]]], 0, 0, 0, 0]], [], ["loc", [null, [19, 66], [19, 87]]], 0, 0]],
        locals: ["control"],
        templates: []
      };
    })();
    var child3 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 21,
              "column": 4
            },
            "end": {
              "line": 23,
              "column": 4
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("      ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "title", "Inspect");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element5 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createElementMorph(element5);
          morphs[1] = dom.createMorphAt(element5, 0, 0);
          return morphs;
        },
        statements: [["element", "action", [["get", "onInspect", ["loc", [null, [22, 23], [22, 32]]], 0, 0, 0, 0]], [], ["loc", [null, [22, 14], [22, 34]]], 0, 0], ["inline", "icon", ["search"], [], ["loc", [null, [22, 51], [22, 68]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child4 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 24,
              "column": 4
            },
            "end": {
              "line": 26,
              "column": 4
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("      ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "title", "Duplicate");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element4 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createElementMorph(element4);
          morphs[1] = dom.createMorphAt(element4, 0, 0);
          return morphs;
        },
        statements: [["element", "action", [["get", "onDuplicate", ["loc", [null, [25, 23], [25, 34]]], 0, 0, 0, 0]], [], ["loc", [null, [25, 14], [25, 36]]], 0, 0], ["inline", "icon", ["copy"], [], ["loc", [null, [25, 55], [25, 70]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child5 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 27,
              "column": 4
            },
            "end": {
              "line": 29,
              "column": 4
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("      ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "title", "Delete");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element3 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element3, 'class');
          morphs[1] = dom.createElementMorph(element3);
          morphs[2] = dom.createMorphAt(element3, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["subexpr", "if", [["get", "deleteConfirm", ["loc", [null, [28, 67], [28, 80]]], 0, 0, 0, 0], "cs-danger"], [], ["loc", [null, [28, 61], [28, 94]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", [["get", "onDelete", ["loc", [null, [28, 23], [28, 31]]], 0, 0, 0, 0]], ["allowedKeys", "shift"], ["loc", [null, [28, 14], [28, 53]]], 0, 0], ["inline", "icon", ["trash-o"], [], ["loc", [null, [28, 111], [28, 129]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child6 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 34,
                "column": 4
              },
              "end": {
                "line": 36,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["content", "yield", ["loc", [null, [35, 6], [35, 15]]], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 32,
              "column": 0
            },
            "end": {
              "line": 38,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element2 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createAttrMorph(element2, 'class');
          morphs[1] = dom.createMorphAt(element2, 1, 1);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", ["cs-sortable-item-drawer ", ["subexpr", "if", [["get", "active", ["loc", [null, [33, 43], [33, 49]]], 0, 0, 0, 0], "cs-active"], [], ["loc", [null, [33, 38], [33, 63]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "active", ["loc", [null, [34, 10], [34, 16]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [34, 4], [36, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child7 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 39,
              "column": 0
            },
            "end": {
              "line": 41,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "cs-add-sortable-item-after");
          var el2 = dom.createElement("span");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var element1 = dom.childAt(element0, [0]);
          var morphs = new Array(3);
          morphs[0] = dom.createElementMorph(element0);
          morphs[1] = dom.createMorphAt(element1, 0, 0);
          morphs[2] = dom.createMorphAt(element1, 1, 1);
          return morphs;
        },
        statements: [["element", "action", ["addAfter"], ["allowedKeys", "any"], ["loc", [null, [40, 10], [40, 49]]], 0, 0], ["inline", "icon", ["plus"], [], ["loc", [null, [40, 91], [40, 106]]], 0, 0], ["content", "addLabel", ["loc", [null, [40, 106], [40, 118]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 42,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/sortable-item/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-sortable-item-handle");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "cs-sortable-item-handle-label");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "cs-sortable-item-handle-controls");
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element10 = dom.childAt(fragment, [1]);
        var element11 = dom.childAt(element10, [3]);
        var element12 = dom.childAt(element10, [5]);
        var morphs = new Array(10);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(element10, 1, 1);
        morphs[2] = dom.createElementMorph(element11);
        morphs[3] = dom.createMorphAt(element11, 1, 1);
        morphs[4] = dom.createMorphAt(element12, 1, 1);
        morphs[5] = dom.createMorphAt(element12, 2, 2);
        morphs[6] = dom.createMorphAt(element12, 3, 3);
        morphs[7] = dom.createMorphAt(element12, 4, 4);
        morphs[8] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        morphs[9] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "onAddBefore", ["loc", [null, [1, 6], [1, 17]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [3, 7]]]], ["block", "if", [["get", "hasDrawer", ["loc", [null, [5, 8], [5, 17]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [5, 2], [7, 9]]]], ["element", "action", ["selectFromLabel"], [], ["loc", [null, [8, 45], [8, 73]]], 0, 0], ["inline", "forms/inline-edit", [], ["class", "label", "value", ["subexpr", "@mut", [["get", "label", ["loc", [null, [11, 12], [11, 17]]], 0, 0, 0, 0]], [], [], 0, 0], "enabled", ["subexpr", "@mut", [["get", "canEditLabel", ["loc", [null, [12, 14], [12, 26]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "labelPlaceholder", ["loc", [null, [13, 18], [13, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "invalid", ["subexpr", "@mut", [["get", "labelInvalid", ["loc", [null, [14, 14], [14, 26]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [9, 4], [15, 6]]], 0, 0], ["block", "each", [["get", "controls", ["loc", [null, [18, 12], [18, 20]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [18, 4], [20, 13]]]], ["block", "if", [["get", "onInspect", ["loc", [null, [21, 10], [21, 19]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [21, 4], [23, 11]]]], ["block", "if", [["get", "onDuplicate", ["loc", [null, [24, 10], [24, 21]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [24, 4], [26, 11]]]], ["block", "if", [["get", "onDelete", ["loc", [null, [27, 10], [27, 18]]], 0, 0, 0, 0]], [], 5, null, ["loc", [null, [27, 4], [29, 11]]]], ["block", "if", [["get", "hasBlock", ["loc", [null, [32, 6], [32, 14]]], 0, 0, 0, 0]], [], 6, null, ["loc", [null, [32, 0], [38, 7]]]], ["block", "if", [["get", "canShowAddAfter", ["loc", [null, [39, 6], [39, 21]]], 0, 0, 0, 0]], [], 7, null, ["loc", [null, [39, 0], [41, 7]]]]],
      locals: [],
      templates: [child0, child1, child2, child3, child4, child5, child6, child7]
    };
  })());
});
define('cornerstone/components/common/status-indicator/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-status-indicator'],
    classNameBindings: ['active:cs-active', 'mode'],
    attributeBindings: ['style']
  });
});
define("cornerstone/components/common/status-indicator/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 28
          }
        },
        "moduleName": "cornerstone/components/common/status-indicator/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "common/loading-indicator", ["loc", [null, [1, 0], [1, 28]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/common/tab-modal/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-tab-modal'],
    classNameBindings: ['active:cs-active'],

    selectedTab: false,

    activeTab: _ember['default'].computed('selectedTab', 'panels', function () {

      var panels = this.get('panels');
      var selectedTab = this.get('selectedTab');

      var filtered = panels.filter(function (item) {
        return item.name === selectedTab;
      });

      if (_ember['default'].isEmpty(filtered)) {
        filtered = panels;
      }

      return filtered.get('firstObject').name;
    }),

    activeLabel: _ember['default'].computed('activeTab', function () {

      var activeTab = this.get('activeTab');

      return this.get('navItems').filter(function (item) {
        return item.name === activeTab;
      }).get('firstObject.label');
    }),

    activeContent: _ember['default'].computed('activeTab', 'panels', function () {

      var activeTab = this.get('activeTab');

      return this.get('panels').filter(function (item) {
        return item.name === activeTab;
      }).get('firstObject.content');
    }),

    actions: {
      close: function close() {
        this.set('active', false);
      },
      nav: function nav(tab) {
        this.set('selectedTab', tab);
      },
      save: function save() {
        if (_ember['default'].isPresent(this.get('onSave'))) {
          this.sendAction('onSave');
        } else {
          this.send('close');
        }
      }
    }
  });
});
define("cornerstone/components/common/tab-modal/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 8,
              "column": 8
            },
            "end": {
              "line": 10,
              "column": 8
            }
          },
          "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("          ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element1 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element1, 'class');
          morphs[1] = dom.createElementMorph(element1);
          morphs[2] = dom.createMorphAt(element1, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "activeTab", ["loc", [null, [9, 60], [9, 69]]], 0, 0, 0, 0], ["get", "nav.name", ["loc", [null, [9, 70], [9, 78]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 56], [9, 79]]], 0, 0], "cs-active"], [], ["loc", [null, [9, 51], [9, 93]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["nav", ["get", "nav.name", ["loc", [null, [9, 33], [9, 41]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 18], [9, 43]]], 0, 0], ["content", "nav.label", ["loc", [null, [9, 95], [9, 108]]], 0, 0, 0, 0]],
        locals: ["nav"],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 11,
              "column": 8
            },
            "end": {
              "line": 13,
              "column": 8
            }
          },
          "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("          ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "cs-tab-modal-save cs-btn cs-btn-yep");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createElementMorph(element0);
          morphs[1] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["element", "action", ["save"], [], ["loc", [null, [12, 18], [12, 35]]], 0, 0], ["content", "saveLabel", ["loc", [null, [12, 80], [12, 93]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 17,
                "column": 10
              },
              "end": {
                "line": 19,
                "column": 10
              }
            },
            "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("            ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "yield", [["subexpr", "hash", [], ["activeTab", ["get", "activeTab", ["loc", [null, [18, 36], [18, 45]]], 0, 0, 0, 0]], ["loc", [null, [18, 20], [18, 46]]], 0, 0]], [], ["loc", [null, [18, 12], [18, 48]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 19,
                "column": 10
              },
              "end": {
                "line": 21,
                "column": 10
              }
            },
            "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("            ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createUnsafeMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["content", "activeContent", ["loc", [null, [20, 12], [20, 31]]], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 16,
              "column": 8
            },
            "end": {
              "line": 22,
              "column": 8
            }
          },
          "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [17, 16], [17, 24]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [17, 10], [21, 17]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 27,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/tab-modal/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("button");
        dom.setAttribute(el1, "class", "cs-tab-modal-close");
        dom.setAttribute(el1, "aria-label", "Close");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("span");
        var el3 = dom.createTextNode("×");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-tab-modal-content-outer");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "cs-tab-modal-content-inner");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "cs-tab-modal-content");
        dom.setAttribute(el3, "role", "document");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("nav");
        var el5 = dom.createTextNode("\n");
        dom.appendChild(el4, el5);
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("article");
        var el5 = dom.createTextNode("\n");
        dom.appendChild(el4, el5);
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element2 = dom.childAt(fragment, [0]);
        var element3 = dom.childAt(fragment, [2, 1, 1]);
        var element4 = dom.childAt(element3, [1]);
        var morphs = new Array(4);
        morphs[0] = dom.createElementMorph(element2);
        morphs[1] = dom.createMorphAt(element4, 1, 1);
        morphs[2] = dom.createMorphAt(element4, 2, 2);
        morphs[3] = dom.createMorphAt(dom.childAt(element3, [3]), 1, 1);
        return morphs;
      },
      statements: [["element", "action", ["close"], [], ["loc", [null, [1, 8], [1, 26]]], 0, 0], ["block", "each", [["get", "panels", ["loc", [null, [8, 16], [8, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [8, 8], [10, 17]]]], ["block", "if", [["get", "saveLabel", ["loc", [null, [11, 14], [11, 23]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [11, 8], [13, 15]]]], ["block", "common/scroll-box", [], [], 2, null, ["loc", [null, [16, 8], [22, 30]]]]],
      locals: [],
      templates: [child0, child1, child2]
    };
  })());
});
define('cornerstone/components/common/welcome-message/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-welcome']
  });
});
define("cornerstone/components/common/welcome-message/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/common/welcome-message/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("h3");
          dom.setAttribute(el1, "class", "cs-welcome-title");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["content", "title", ["loc", [null, [2, 31], [2, 40]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/common/welcome-message/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "if", [["get", "title", ["loc", [null, [1, 6], [1, 11]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [3, 7]]]], ["content", "yield", ["loc", [null, [4, 0], [4, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/content/column-order/column-order-item/component', ['exports', 'ember', 'cornerstone/mixins/dragula-events'], function (exports, _ember, _cornerstoneMixinsDragulaEvents) {

  // 1. For some reason the DOM element doesn't actually get deleted if it's been moved. This patch force deletes it.

  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsDragulaEvents['default'], {

    tagName: 'li',
    classNames: ['cs-column-order-item'],
    classNameBindings: ['active:cs-active', 'size'],

    dragulaEvents: ['element'],

    dragulaDrop: function dragulaDrop(e, el, target, source, sibling) {
      var _this = this;

      // console.log('DROP')
      var index = _ember['default'].$(sibling).index() - 1;
      _ember['default'].run.next(function () {
        _this.sendAction('onDropIndex', _this.get('itemIndex'), index);
        _this.sendAction('onDrop', _this.get('item'), index);
      });
      this.set('_bugfixEl', el); // 1
    },

    didInsertElement: function didInsertElement() {
      var _this2 = this;

      this.$().on('mouseenter', '.handle, .controls', function () {
        if (_this2.isDestroyed) {
          return;
        }
        _this2.sendAction('onMouseEnter');
      }).on('mouseleave', '.handle, .controls', function () {
        if (_this2.isDestroyed) {
          return;
        }
        _this2.sendAction('onMouseLeave');
      });
    },

    size: _ember['default'].computed('item.atts.size', function () {
      return 'cs-' + _ember['default'].String.classify(this.getWithDefault('item.atts.size'), '').replace('/', '-');
    }),

    actions: {
      select: function select() {
        this.sendAction('onSelect');
      }
    },

    didDestroyElement: function didDestroyElement() {
      // 1
      this._super.apply(this, arguments);
      var bugfixEl = this.get('_bugfixEl');
      if (bugfixEl && bugfixEl.remove) {
        bugfixEl.remove();
      }
    }
  });
});
define("cornerstone/components/content/column-order/column-order-item/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/column-order/column-order-item/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("span");
        dom.setAttribute(el1, "class", "handle");
        var el2 = dom.createElement("span");
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var morphs = new Array(2);
        morphs[0] = dom.createElementMorph(element0);
        morphs[1] = dom.createMorphAt(dom.childAt(element0, [0]), 0, 0);
        return morphs;
      },
      statements: [["element", "action", ["select"], [], ["loc", [null, [1, 21], [1, 40]]], 0, 0], ["content", "item.atts.size", ["loc", [null, [1, 47], [1, 65]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/content/column-order/component', ['exports', 'ember', 'cornerstone/util/dragula'], function (exports, _ember, _cornerstoneUtilDragula) {
  exports['default'] = _ember['default'].Component.extend({

    tagName: 'ul',
    classNames: ['cs-column-order'],
    classNameBindings: ['isDragging:cs-sorting'],
    isDragging: false,

    didInsertElement: function didInsertElement() {
      var _this = this;

      var drake = (0, _cornerstoneUtilDragula['default'])({
        accepts: function accepts() {
          return true; // elements can be dropped in any of the `containers` by default
        },
        offset: function offset(_offset, e, item) {
          _offset.x = _ember['default'].$(item).width() / 2; // snap to horizontal center
          return _offset;
        },
        mirrorContainer: this.get('element'),
        direction: 'horizontal',
        revertOnSpill: true
      });

      drake.containers.push(this.get('element'));

      drake.on('drag', function () {
        _this.set('isDragging', true);
        _this.get('ui').set('noPreviewPointer', true);
      });

      drake.on('dragend', function () {
        _this.set('isDragging', false);
        _this.get('ui').set('noPreviewPointer', false);
      });

      this.set('drake', drake);
    }
  });
});
define("cornerstone/components/content/column-order/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/column-order/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/content/cs-title/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: 'cs-title',
    classNameBindings: ['showInspectButton:inspectable'],
    showInspectButton: false,

    actions: {
      inspect: function inspect() {
        this.sendAction('onInspect');
      }
    }

  });
});
define("cornerstone/components/content/cs-title/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/cs-title/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "class", "cs-title-button");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element0, 'title');
          morphs[1] = dom.createElementMorph(element0);
          morphs[2] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["attribute", "title", ["get", "tooltip", ["loc", [null, [3, 42], [3, 49]]], 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["inspect"], [], ["loc", [null, [3, 52], [3, 72]]], 0, 0], ["inline", "icon", ["search"], [], ["loc", [null, [3, 73], [3, 90]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/cs-title/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "input", [], ["class", "cs-title-input", "value", ["subexpr", "@mut", [["get", "title", ["loc", [null, [1, 37], [1, 42]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [1, 0], [1, 44]]], 0, 0], ["block", "if", [["get", "showInspectButton", ["loc", [null, [2, 6], [2, 23]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 0], [4, 7]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/content/manage-section/component', ['exports', 'ember'], function (exports, _ember) {

  function reduceFractions(replace) {
    var reductions = [{ f: '2\/4', r: '1/2' }, { f: '2\/6', r: '1/3' }, { f: '3\/6', r: '1/2' }, { f: '4\/6', r: '2/3' }];
    var string = replace;
    reductions.forEach(function (reducer) {
      var re = new RegExp(reducer.f, 'g');
      string = string.replace(re, reducer.r);
    });
    return string;
  }

  function layoutIsValid(layout) {
    return ['1/1', '1/2 + 1/2', '2/3 + 1/3', '1/3 + 2/3', '1/3 + 1/3 + 1/3', '3/4 + 1/4', '1/4 + 3/4', '1/2 + 1/2', '1/2 + 1/4 + 1/4', '1/4 + 1/2 + 1/4', '1/4 + 1/4 + 1/2', '1/4 + 1/4 + 1/4 + 1/4', '4/5 + 1/5', '1/5 + 4/5', '3/5 + 2/5', '2/5 + 3/5', '3/5 + 1/5 + 1/5', '1/5 + 3/5 + 1/5', '1/5 + 1/5 + 3/5', '2/5 + 2/5 + 1/5', '2/5 + 1/5 + 2/5', '1/5 + 2/5 + 2/5', '2/5 + 1/5 + 1/5 + 1/5', '1/5 + 2/5 + 1/5 + 1/5', '1/5 + 1/5 + 2/5 + 1/5', '1/5 + 1/5 + 1/5 + 2/5', '1/5 + 1/5 + 1/5 + 1/5 + 1/5', '5/6 + 1/6', '1/6 + 5/6', '2/3 + 1/3', '1/3 + 2/3', '2/3 + 1/6 + 1/6', '1/6 + 2/3 + 1/6', '1/6 + 1/6 + 2/3', '1/2 + 1/2', '1/2 + 1/3 + 1/6', '1/2 + 1/6 + 1/3', '1/3 + 1/2 + 1/6', '1/3 + 1/6 + 1/2', '1/6 + 1/2 + 1/3', '1/6 + 1/3 + 1/2', '1/2 + 1/6 + 1/6 + 1/6', '1/6 + 1/2 + 1/6 + 1/6', '1/6 + 1/6 + 1/2 + 1/6', '1/6 + 1/6 + 1/6 + 1/2', '1/3 + 1/3 + 1/3', '1/3 + 1/3 + 1/6 + 1/6', '1/3 + 1/6 + 1/3 + 1/6', '1/3 + 1/6 + 1/6 + 1/3', '1/6 + 1/3 + 1/3 + 1/6', '1/6 + 1/3 + 1/6 + 1/3', '1/6 + 1/6 + 1/3 + 1/3', '1/3 + 1/6 + 1/6 + 1/6 + 1/6', '1/6 + 1/3 + 1/6 + 1/6 + 1/6', '1/6 + 1/6 + 1/3 + 1/6 + 1/6', '1/6 + 1/6 + 1/6 + 1/3 + 1/6', '1/6 + 1/6 + 1/6 + 1/6 + 1/3', '1/6 + 1/6 + 1/6 + 1/6 + 1/6 + 1/6'].includes(layout);
  }

  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-manage-layout'],
    store: _ember['default'].inject.service(),

    columnLayouts: ['1/1', '1/2 + 1/2', '1/3 + 2/3', '2/3 + 1/3', '1/3 + 1/3 + 1/3', '1/4 + 1/4 + 1/4 + 1/4', '1/5 + 1/5 + 1/5 + 1/5 + 1/5'],

    didReceiveAttrs: function didReceiveAttrs() {
      var row = this.get('store').peekRecord('element', this.get('selectedRowId'));
      this.set('selectedRow', row);
    },

    columnLayoutOutputHelper: _ember['default'].computed('columnLayouts', function () {
      return this.get('columnLayouts').map(function (layout) {
        return { layout: layout, columns: layout.split(' + ') };
      });
    }),

    selectedRowObserver: _ember['default'].observer('selectedRowId', function () {
      this.set('useCustomLayout', false);
    }),

    customColumnLayout: _ember['default'].computed('selectedRowId', 'useCustomLayout', {
      get: function get() {
        return this.get('selectedColumnLayout');
      },
      set: function set(key, value) {
        var reduced = reduceFractions(value);
        if (layoutIsValid(reduced)) {
          this.set('selectedColumnLayout', reduced);
        }
        return value;
      }
    }),

    selectedColumnLayout: _ember['default'].computed('selectedRow', 'selectedRow.childrenReordered', {
      get: function get() {
        return this.get('sortedActiveColumns').map(function (column) {
          return column.get('atts.size');
        }, '').join(' + ');
      },
      set: function set(key, value, previous) {
        var _this = this;

        var reduced = reduceFractions(value);

        if (!layoutIsValid(reduced)) {
          return previous;
        }

        var sizes = reduced.split(' + ');
        sizes.reverse();

        var diff = sizes.length - this.get('sortedColumns.length');
        var promises = _ember['default'].A();

        while (--diff >= 0) {
          promises.push(this.get('selectedRow').addChild({
            _type: this.get('selectedRow.definition.isClassic') ? 'classic:column' : 'column',
            _region: 'content'
          }));
        }

        var after = function after() {
          _this.get('sortedColumns').forEach(function (column) {
            var size = sizes.pop();
            column.set('atts._active', !!size);
            column.set('atts.size', size || '');
          });
        };

        if (promises.length > 0) {
          _ember['default'].RSVP.allSettled(promises).then(after);
        } else {
          after();
        }

        //console.log( 'items', this.get('sortedActiveColumns').map ( item => item.get('atts.size')) );

        return reduced;
      }
    }),

    orderSort: ['order'],
    sortedRows: _ember['default'].computed.sort('section.availableChildren', 'orderSort'),

    sortedColumns: _ember['default'].computed.sort('selectedRow.availableChildren', 'orderSort'),
    sortedActiveColumns: _ember['default'].computed.sort('activeColumns', 'orderSort'),
    activeColumns: _ember['default'].computed('selectedRow.availableChildren.@each.attsActive', function () {
      return this.get('selectedRow.availableChildren').filter(function (column) {
        return column.get('atts._active');
      });
    }),

    selectedRowDeleted: _ember['default'].observer('selectedRow.pendingDelete', function () {
      if (this.get('selectedRow.pendingDelete')) {
        this.sendAction('onSelectRow', null);
      }
    }),

    customLayout: _ember['default'].computed('selectedColumnLayout', 'useCustomLayout', function () {
      if (this.get('useCustomLayout')) {
        return true;
      }
      return !this.get('columnLayouts').includes(this.get('selectedColumnLayout'));
    }),

    actions: {
      selectColumnLayout: function selectColumnLayout(layout) {
        this.set('useCustomLayout', false);
        this.set('selectedColumnLayout', layout);
      },

      useCustomLayout: function useCustomLayout() {
        this.set('useCustomLayout', true);
      }
    }

  });
});
define("cornerstone/components/content/manage-section/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 4,
                  "column": 6
                },
                "end": {
                  "line": 21,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/content/manage-section/template.hbs"
            },
            isEmpty: false,
            arity: 1,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "common/sortable-item", [], ["label", ["subexpr", "@mut", [["get", "row.indexedTitle", ["loc", [null, [6, 16], [6, 32]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "row", ["loc", [null, [7, 15], [7, 18]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "eq", [["get", "row.id", ["loc", [null, [8, 21], [8, 27]]], 0, 0, 0, 0], ["get", "selectedRowId", ["loc", [null, [8, 28], [8, 41]]], 0, 0, 0, 0]], [], ["loc", [null, [8, 17], [8, 42]]], 0, 0], "showAddAfter", ["subexpr", "eq", [["get", "row.id", ["loc", [null, [9, 27], [9, 33]]], 0, 0, 0, 0], ["get", "sortedRows.lastObject.id", ["loc", [null, [9, 34], [9, 58]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 23], [9, 59]]], 0, 0], "addLabel", "Add Row", "onSelect", ["subexpr", "action", [["get", "onSelectRow", ["loc", [null, [11, 27], [11, 38]]], 0, 0, 0, 0], ["get", "row", ["loc", [null, [11, 39], [11, 42]]], 0, 0, 0, 0]], [], ["loc", [null, [11, 19], [11, 43]]], 0, 0], "onInspect", ["subexpr", "route-action", ["inspectElement", ["get", "row", ["loc", [null, [12, 51], [12, 54]]], 0, 0, 0, 0]], [], ["loc", [null, [12, 20], [12, 56]]], 0, 0], "onDrop", ["subexpr", "route-action", ["moveElement"], [], ["loc", [null, [13, 17], [13, 46]]], 0, 0], "onAddBefore", ["subexpr", "route-action", ["addSiblingElement", ["get", "row", ["loc", [null, [14, 56], [14, 59]]], 0, 0, 0, 0], null, false], [], ["loc", [null, [14, 22], [14, 71]]], 0, 0], "onAddAfter", ["subexpr", "route-action", ["addSiblingElement", ["get", "row", ["loc", [null, [15, 55], [15, 58]]], 0, 0, 0, 0], null, true], [], ["loc", [null, [15, 21], [15, 69]]], 0, 0], "onDuplicate", ["subexpr", "route-action", ["duplicateElement", ["get", "row", ["loc", [null, [16, 55], [16, 58]]], 0, 0, 0, 0]], [], ["loc", [null, [16, 22], [16, 59]]], 0, 0], "onDelete", ["subexpr", "route-action", ["deleteElement", ["get", "row", ["loc", [null, [17, 49], [17, 52]]], 0, 0, 0, 0]], [], ["loc", [null, [17, 19], [17, 53]]], 0, 0], "onMouseEnter", ["subexpr", "route-action", ["observeStart", ["get", "row", ["loc", [null, [18, 52], [18, 55]]], 0, 0, 0, 0]], [], ["loc", [null, [18, 23], [18, 56]]], 0, 0], "onMouseLeave", ["subexpr", "route-action", ["observeEnd", ["get", "row", ["loc", [null, [19, 50], [19, 53]]], 0, 0, 0, 0]], [], ["loc", [null, [19, 23], [19, 54]]], 0, 0]], ["loc", [null, [5, 8], [20, 10]]], 0, 0]],
            locals: ["row"],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 4
              },
              "end": {
                "line": 22,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/content/manage-section/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "each", [["get", "sortedRows", ["loc", [null, [4, 14], [4, 24]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 6], [21, 15]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 2
            },
            "end": {
              "line": 23,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/content/manage-section/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "common/sortable-container", [], [], 0, null, ["loc", [null, [3, 4], [22, 34]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 23,
              "column": 2
            },
            "end": {
              "line": 29,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/content/manage-section/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "workspace/workspace-full-button", [], ["action", ["subexpr", "@mut", [["get", "onAddFirstRow", ["loc", [null, [25, 13], [25, 26]]], 0, 0, 0, 0]], [], [], 0, 0], "icon", ["subexpr", "icon", ["plus-square"], [], ["loc", [null, [26, 11], [26, 31]]], 0, 0], "message", "Add a row to manage columns."], ["loc", [null, [24, 4], [28, 6]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 37,
                  "column": 8
                },
                "end": {
                  "line": 39,
                  "column": 8
                }
              },
              "moduleName": "cornerstone/components/content/manage-section/template.hbs"
            },
            isEmpty: false,
            arity: 1,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("          ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("span");
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1]);
              var morphs = new Array(2);
              morphs[0] = dom.createAttrMorph(element0, 'class');
              morphs[1] = dom.createMorphAt(element0, 0, 0);
              return morphs;
            },
            statements: [["attribute", "class", ["concat", ["cs-", ["subexpr", "cs-classify", [["get", "column", ["loc", [null, [38, 40], [38, 46]]], 0, 0, 0, 0]], [], ["loc", [null, [38, 26], [38, 48]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "column", ["loc", [null, [38, 50], [38, 60]]], 0, 0, 0, 0]],
            locals: ["column"],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 35,
                "column": 6
              },
              "end": {
                "line": 41,
                "column": 6
              }
            },
            "moduleName": "cornerstone/components/content/manage-section/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("li");
            var el2 = dom.createTextNode("\n");
            dom.appendChild(el1, el2);
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("      ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element1 = dom.childAt(fragment, [1]);
            var morphs = new Array(3);
            morphs[0] = dom.createAttrMorph(element1, 'class');
            morphs[1] = dom.createElementMorph(element1);
            morphs[2] = dom.createMorphAt(element1, 1, 1);
            return morphs;
          },
          statements: [["attribute", "class", ["subexpr", "unless", [["get", "customLayout", ["loc", [null, [36, 25], [36, 37]]], 0, 0, 0, 0], ["subexpr", "if", [["subexpr", "eq", [["get", "selectedColumnLayout", ["loc", [null, [36, 46], [36, 66]]], 0, 0, 0, 0], ["get", "columnLayout.layout", ["loc", [null, [36, 67], [36, 86]]], 0, 0, 0, 0]], [], ["loc", [null, [36, 42], [36, 87]]], 0, 0], "cs-active"], [], ["loc", [null, [36, 38], [36, 100]]], 0, 0]], [], ["loc", [null, [null, null], [36, 102]]], 0, 0], 0, 0, 0, 0], ["element", "action", ["selectColumnLayout", ["get", "columnLayout.layout", ["loc", [null, [36, 133], [36, 152]]], 0, 0, 0, 0]], [], ["loc", [null, [36, 103], [36, 154]]], 0, 0], ["block", "each", [["get", "columnLayout.columns", ["loc", [null, [37, 16], [37, 36]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [37, 8], [39, 17]]]]],
          locals: ["columnLayout"],
          templates: [child0]
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 44,
                "column": 4
              },
              "end": {
                "line": 46,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/content/manage-section/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "customColumnLayout", ["loc", [null, [45, 20], [45, 38]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [45, 6], [45, 40]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child2 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 51,
                  "column": 6
                },
                "end": {
                  "line": 60,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/content/manage-section/template.hbs"
            },
            isEmpty: false,
            arity: 1,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "content/column-order/column-order-item", [], ["item", ["subexpr", "@mut", [["get", "column", ["loc", [null, [53, 15], [53, 21]]], 0, 0, 0, 0]], [], [], 0, 0], "onDrop", ["subexpr", "route-action", ["moveElement"], [], ["loc", [null, [54, 17], [54, 45]]], 0, 0], "onSelect", ["subexpr", "route-action", ["inspectElement", ["get", "column", ["loc", [null, [55, 50], [55, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [55, 19], [55, 57]]], 0, 0], "onInspect", ["subexpr", "route-action", ["inspectElement", ["get", "column", ["loc", [null, [56, 51], [56, 57]]], 0, 0, 0, 0]], [], ["loc", [null, [56, 20], [56, 58]]], 0, 0], "onMouseEnter", ["subexpr", "route-action", ["observeStart", ["get", "column", ["loc", [null, [57, 52], [57, 58]]], 0, 0, 0, 0]], [], ["loc", [null, [57, 23], [57, 59]]], 0, 0], "onMouseLeave", ["subexpr", "route-action", ["observeEnd", ["get", "column", ["loc", [null, [58, 50], [58, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [58, 23], [58, 57]]], 0, 0]], ["loc", [null, [52, 8], [59, 10]]], 0, 0]],
            locals: ["column"],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 50,
                "column": 4
              },
              "end": {
                "line": 61,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/content/manage-section/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "each", [["get", "sortedActiveColumns", ["loc", [null, [51, 14], [51, 33]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [51, 6], [60, 15]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 32,
              "column": 0
            },
            "end": {
              "line": 63,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/manage-section/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-sortable-item-drawer-section");
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("ul");
          dom.setAttribute(el2, "class", "cs-column-layout");
          var el3 = dom.createTextNode("\n");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("      ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("li");
          var el4 = dom.createElement("span");
          dom.setAttribute(el4, "class", "cs-1-1 custom");
          var el5 = dom.createElement("span");
          var el6 = dom.createComment("");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n    ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-sortable-item-drawer-section");
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element2 = dom.childAt(fragment, [1]);
          var element3 = dom.childAt(element2, [1]);
          var element4 = dom.childAt(element3, [3]);
          var morphs = new Array(6);
          morphs[0] = dom.createMorphAt(element3, 1, 1);
          morphs[1] = dom.createAttrMorph(element4, 'class');
          morphs[2] = dom.createElementMorph(element4);
          morphs[3] = dom.createMorphAt(dom.childAt(element4, [0, 0]), 0, 0);
          morphs[4] = dom.createMorphAt(element2, 3, 3);
          morphs[5] = dom.createMorphAt(dom.childAt(fragment, [3]), 1, 1);
          return morphs;
        },
        statements: [["block", "each", [["get", "columnLayoutOutputHelper", ["loc", [null, [35, 14], [35, 38]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [35, 6], [41, 15]]]], ["attribute", "class", ["concat", ["custom ", ["subexpr", "if", [["get", "customLayout", ["loc", [null, [42, 29], [42, 41]]], 0, 0, 0, 0], "cs-active"], [], ["loc", [null, [42, 24], [42, 55]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["useCustomLayout"], [], ["loc", [null, [42, 57], [42, 85]]], 0, 0], ["inline", "t", ["content.columns-layout-custom"], [], ["loc", [null, [42, 120], [42, 157]]], 0, 0], ["block", "if", [["get", "customLayout", ["loc", [null, [44, 10], [44, 22]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [44, 4], [46, 11]]]], ["block", "content/column-order", [], [], 2, null, ["loc", [null, [50, 4], [61, 29]]]]],
        locals: [],
        templates: [child0, child1, child2]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 64,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/manage-section/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-sortable-item-drawer-section");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0]), 1, 1);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "sortedRows", ["loc", [null, [2, 8], [2, 18]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [2, 2], [29, 9]]]], ["block", "if", [["get", "selectedRow", ["loc", [null, [32, 6], [32, 17]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [32, 0], [63, 7]]]]],
      locals: [],
      templates: [child0, child1, child2]
    };
  })());
});
define('cornerstone/components/content/settings-modal/component', ['exports', 'ember', 'npm:json-stable-stringify'], function (exports, _ember, _npmJsonStableStringify) {
  exports['default'] = _ember['default'].Component.extend({

    modalOpen: _ember['default'].computed.alias('ui.showSettingsModal'),

    openObserver: _ember['default'].observer('modalOpen', function () {

      var snapshot = (0, _npmJsonStableStringify['default'])({
        settings: this.get('model.content.settings'),
        rt: this.get('model.content.responsiveTextItems')
      });

      if (this.get('modalOpen')) {
        this.set('snapshot', snapshot);
      } else {
        if (snapshot !== this.get('snapshot')) {
          this.sendAction('onSettingsChanged');
        }
      }
    }),

    sections: _ember['default'].computed('model.settingsSections.models', function () {
      var _this = this;

      return this.get('model.settingsSections.models').map(function (model) {
        var controls = [];
        model.controls.forEach(function (control) {
          if (!['text', 'select', 'toggle', 'wpselect'].includes(control.type)) {
            return;
          }

          if ('wpselect' === control.type) {
            control = _this.convertWpSelect(control);
          }

          controls.push({
            label: control.ui.title,
            type: control.type,
            key: 'content.settings.' + model.name + '.' + control.key,
            options: control.options,
            refresh: !!control.options.notLive
          });
        });
        return { name: model.name, label: model.ui.title, controls: controls };
      });
    }),

    convertWpSelect: function convertWpSelect(control) {

      control.type = 'select';
      var markup = this.normalizeWpSelectMarkup(control.options.markup, control);
      var options = markup.match(/<option.*?option>/g);
      control.options.choices = [];

      var regex = new RegExp('value="(.*?)".*?>(.*?)<\/');
      if (options) {
        options.forEach(function (option) {
          var found = regex.exec(option);
          if (found) {
            control.options.choices.push({ value: found[1], label: found[2] });
          }
        });
      }

      return control;
    },

    normalizeWpSelectMarkup: function normalizeWpSelectMarkup(markup, control) {

      if ('post_parent' === control.key) {
        return markup.replace('value=""', 'value="0"');
      }

      return markup;
    }

  });
});
define('cornerstone/components/content/settings-modal/responsive-text/component', ['exports', 'ember'], function (exports, _ember) {

  var defaultItem = {
    selector: '.h-responsive',
    compression: '1.0',
    min_size: '24',
    max_size: '96'
  };

  exports['default'] = _ember['default'].Component.extend({

    lastIndex: _ember['default'].computed('items.length', function () {
      return this.get('items.length') - 1;
    }),

    unitSliderOptions: {
      available_units: ['px'],
      ranges: {
        px: { min: 0, max: 100, step: 1 }
      }
    },

    actions: {

      addFirstItem: function addFirstItem() {
        this.send('addItem', defaultItem, 0);
      },

      selectIndex: function selectIndex(index) {
        this.set('selectedIndex', index === this.get('selectedIndex') ? 'none' : index);
      },

      moveItem: function moveItem(from, to) {
        var items = this.get('items');
        var item = items.objectAt(from);
        var before = items.slice(0, from);
        var after = items.slice(from + 1);
        items = before.concat(after);
        before = items.slice(0, to);
        after = items.slice(to);
        before.push(item);
        this.set('items', before.concat(after));
      },

      addSiblingItem: function addSiblingItem(index, item, after) {
        this.send('addItem', defaultItem, after ? index + 1 : index);
      },

      addItem: function addItem(item, index) {

        if (!item.title) {
          item.title = 'Responsive Text';
        }

        var items = this.get('items');
        var before = items.slice(0, index);
        var after = items.slice(index);
        before.push(item);
        this.set('items', before.concat(after));
      },

      duplicateItem: function duplicateItem(item, index) {
        var duplicate = _ember['default'].copy(item);
        duplicate.title = this.get('i18n').t('app.copy-of', { title: duplicate.title }).string;
        this.send('addItem', duplicate, index + 1);
      },

      deleteItem: function deleteItem(index) {
        this.set('items', this.get('items').filter(function (item, i) {
          return index !== i;
        }));
      }
    }
  });
});
define("cornerstone/components/content/settings-modal/responsive-text/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 3,
                  "column": 4
                },
                "end": {
                  "line": 45,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/content/settings-modal/responsive-text/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("    ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-sortable-item-drawer-section");
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("ul");
              dom.setAttribute(el2, "class", "cs-control-input-list");
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("li");
              dom.setAttribute(el3, "class", "cs-control-input-list-item cs-control-input-list-item-text");
              var el4 = dom.createTextNode("\n          ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("div");
              dom.setAttribute(el4, "class", "cs-control-input-list-label");
              var el5 = dom.createElement("span");
              var el6 = dom.createTextNode("Selector");
              dom.appendChild(el5, el6);
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n          ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("div");
              dom.setAttribute(el4, "class", "cs-control-input-list-input");
              var el5 = dom.createTextNode("\n            ");
              dom.appendChild(el4, el5);
              var el5 = dom.createComment("");
              dom.appendChild(el4, el5);
              var el5 = dom.createTextNode("\n          ");
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n        ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("li");
              dom.setAttribute(el3, "class", "cs-control-input-list-item cs-control-input-list-item-text");
              var el4 = dom.createTextNode("\n          ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("div");
              dom.setAttribute(el4, "class", "cs-control-input-list-label");
              var el5 = dom.createElement("span");
              var el6 = dom.createTextNode("Compress");
              dom.appendChild(el5, el6);
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n          ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("div");
              dom.setAttribute(el4, "class", "cs-control-input-list-input");
              var el5 = dom.createTextNode("\n            ");
              dom.appendChild(el4, el5);
              var el5 = dom.createComment("");
              dom.appendChild(el4, el5);
              var el5 = dom.createTextNode("\n          ");
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n        ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("li");
              dom.setAttribute(el3, "class", "cs-control-input-list-item cs-control-input-list-item-unit-slider");
              var el4 = dom.createTextNode("\n          ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("div");
              dom.setAttribute(el4, "class", "cs-control-input-list-label");
              var el5 = dom.createElement("span");
              var el6 = dom.createTextNode("Minimum Size");
              dom.appendChild(el5, el6);
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n          ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("div");
              dom.setAttribute(el4, "class", "cs-control-input-list-input");
              var el5 = dom.createTextNode("\n            ");
              dom.appendChild(el4, el5);
              var el5 = dom.createComment("");
              dom.appendChild(el4, el5);
              var el5 = dom.createTextNode("\n          ");
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n        ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("li");
              dom.setAttribute(el3, "class", "cs-control-input-list-item cs-control-input-list-item-unit-slider");
              var el4 = dom.createTextNode("\n          ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("div");
              dom.setAttribute(el4, "class", "cs-control-input-list-label");
              var el5 = dom.createElement("span");
              var el6 = dom.createTextNode("Maximum Size");
              dom.appendChild(el5, el6);
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n          ");
              dom.appendChild(el3, el4);
              var el4 = dom.createElement("div");
              dom.setAttribute(el4, "class", "cs-control-input-list-input");
              var el5 = dom.createTextNode("\n            ");
              dom.appendChild(el4, el5);
              var el5 = dom.createComment("");
              dom.appendChild(el4, el5);
              var el5 = dom.createTextNode("\n          ");
              dom.appendChild(el4, el5);
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n        ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n      ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n    ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1, 1]);
              var morphs = new Array(4);
              morphs[0] = dom.createMorphAt(dom.childAt(element0, [1, 3]), 1, 1);
              morphs[1] = dom.createMorphAt(dom.childAt(element0, [3, 3]), 1, 1);
              morphs[2] = dom.createMorphAt(dom.childAt(element0, [5, 3]), 1, 1);
              morphs[3] = dom.createMorphAt(dom.childAt(element0, [7, 3]), 1, 1);
              return morphs;
            },
            statements: [["inline", "input", [], ["type", "text", "value", ["subexpr", "@mut", [["get", "item.selector", ["loc", [null, [22, 38], [22, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ".h-responsive"], ["loc", [null, [22, 12], [22, 81]]], 0, 0], ["inline", "input", [], ["type", "text", "value", ["subexpr", "@mut", [["get", "item.compression", ["loc", [null, [28, 38], [28, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "1.0"], ["loc", [null, [28, 12], [28, 74]]], 0, 0], ["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "item.min_size", ["loc", [null, [34, 38], [34, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "unitSliderOptions", ["loc", [null, [34, 60], [34, 77]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [34, 12], [34, 79]]], 0, 0], ["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "item.max_size", ["loc", [null, [40, 38], [40, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "unitSliderOptions", ["loc", [null, [40, 60], [40, 77]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [40, 12], [40, 79]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 2,
                "column": 2
              },
              "end": {
                "line": 46,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/settings-modal/responsive-text/template.hbs"
          },
          isEmpty: false,
          arity: 2,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "common/sortable-item", [], ["label", ["subexpr", "@mut", [["get", "item.title", ["loc", [null, [4, 12], [4, 22]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "item", ["loc", [null, [5, 11], [5, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "itemIndex", ["subexpr", "@mut", [["get", "index", ["loc", [null, [6, 16], [6, 21]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "eq", [["get", "index", ["loc", [null, [7, 17], [7, 22]]], 0, 0, 0, 0], ["get", "selectedIndex", ["loc", [null, [7, 23], [7, 36]]], 0, 0, 0, 0]], [], ["loc", [null, [7, 13], [7, 37]]], 0, 0], "showAddAfter", ["subexpr", "eq", [["get", "index", ["loc", [null, [8, 23], [8, 28]]], 0, 0, 0, 0], ["get", "lastIndex", ["loc", [null, [8, 29], [8, 38]]], 0, 0, 0, 0]], [], ["loc", [null, [8, 19], [8, 39]]], 0, 0], "onSelect", ["subexpr", "action", ["selectIndex", ["get", "index", ["loc", [null, [9, 37], [9, 42]]], 0, 0, 0, 0]], [], ["loc", [null, [9, 15], [9, 43]]], 0, 0], "onDropIndex", ["subexpr", "action", ["moveItem"], [], ["loc", [null, [10, 18], [10, 38]]], 0, 0], "onAddBefore", ["subexpr", "action", ["addSiblingItem", ["get", "index", ["loc", [null, [11, 43], [11, 48]]], 0, 0, 0, 0], ["subexpr", "hash", [], ["_type", "classic:responsive-text"], ["loc", [null, [11, 49], [11, 87]]], 0, 0], false], [], ["loc", [null, [11, 18], [11, 94]]], 0, 0], "onAddAfter", ["subexpr", "action", ["addSiblingItem", ["get", "index", ["loc", [null, [12, 42], [12, 47]]], 0, 0, 0, 0], ["subexpr", "hash", [], ["_type", "classic:responsive-text"], ["loc", [null, [12, 48], [12, 86]]], 0, 0], true], [], ["loc", [null, [12, 17], [12, 92]]], 0, 0], "onDuplicate", ["subexpr", "action", ["duplicateItem", ["get", "item", ["loc", [null, [13, 42], [13, 46]]], 0, 0, 0, 0], ["get", "index", ["loc", [null, [13, 47], [13, 52]]], 0, 0, 0, 0]], [], ["loc", [null, [13, 18], [13, 53]]], 0, 0], "onDelete", ["subexpr", "action", ["deleteItem", ["get", "index", ["loc", [null, [14, 36], [14, 41]]], 0, 0, 0, 0]], [], ["loc", [null, [14, 15], [14, 42]]], 0, 0], "hasDrawer", true], 0, null, ["loc", [null, [3, 4], [45, 29]]]]],
          locals: ["item", "index"],
          templates: [child0]
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 46,
                "column": 2
              },
              "end": {
                "line": 52,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/settings-modal/responsive-text/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "workspace/workspace-full-button", [], ["action", ["subexpr", "action", ["addFirstItem"], [], ["loc", [null, [48, 13], [48, 36]]], 0, 0], "icon", ["subexpr", "icon", ["plus-square"], [], ["loc", [null, [49, 11], [49, 31]]], 0, 0], "message", "Add an item to get started."], ["loc", [null, [47, 4], [51, 6]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 53,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/settings-modal/responsive-text/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "items", ["loc", [null, [2, 10], [2, 15]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [2, 2], [52, 11]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 54,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/settings-modal/responsive-text/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "common/sortable-container", [], [], 0, null, ["loc", [null, [1, 0], [53, 30]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("cornerstone/components/content/settings-modal/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              var child0 = (function () {
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 15,
                        "column": 14
                      },
                      "end": {
                        "line": 17,
                        "column": 14
                      }
                    },
                    "moduleName": "cornerstone/components/content/settings-modal/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createTextNode("                ");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createComment("");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createTextNode("\n");
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                    return morphs;
                  },
                  statements: [["inline", "input", [], ["type", "text", "value", ["subexpr", "mut", [["subexpr", "get", [["get", "model", ["loc", [null, [16, 52], [16, 57]]], 0, 0, 0, 0], ["get", "control.key", ["loc", [null, [16, 58], [16, 69]]], 0, 0, 0, 0]], [], ["loc", [null, [16, 47], [16, 70]]], 0, 0]], [], ["loc", [null, [16, 42], [16, 71]]], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "control.options.placeholder", ["loc", [null, [16, 84], [16, 111]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [16, 16], [16, 113]]], 0, 0]],
                  locals: [],
                  templates: []
                };
              })();
              var child1 = (function () {
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 18,
                        "column": 14
                      },
                      "end": {
                        "line": 20,
                        "column": 14
                      }
                    },
                    "moduleName": "cornerstone/components/content/settings-modal/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createTextNode("                ");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createComment("");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createTextNode("\n");
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                    return morphs;
                  },
                  statements: [["inline", "forms/cs-toggle", [], ["value", ["subexpr", "mut", [["subexpr", "get", [["get", "model", ["loc", [null, [19, 50], [19, 55]]], 0, 0, 0, 0], ["get", "control.key", ["loc", [null, [19, 56], [19, 67]]], 0, 0, 0, 0]], [], ["loc", [null, [19, 45], [19, 68]]], 0, 0]], [], ["loc", [null, [19, 40], [19, 69]]], 0, 0]], ["loc", [null, [19, 16], [19, 71]]], 0, 0]],
                  locals: [],
                  templates: []
                };
              })();
              var child2 = (function () {
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 21,
                        "column": 14
                      },
                      "end": {
                        "line": 23,
                        "column": 14
                      }
                    },
                    "moduleName": "cornerstone/components/content/settings-modal/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createTextNode("                ");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createComment("");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createTextNode("\n");
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                    return morphs;
                  },
                  statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "mut", [["subexpr", "get", [["get", "model", ["loc", [null, [22, 54], [22, 59]]], 0, 0, 0, 0], ["get", "control.key", ["loc", [null, [22, 60], [22, 71]]], 0, 0, 0, 0]], [], ["loc", [null, [22, 49], [22, 72]]], 0, 0]], [], ["loc", [null, [22, 44], [22, 73]]], 0, 0], "options", ["subexpr", "@mut", [["get", "control.options.choices", ["loc", [null, [22, 82], [22, 105]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [22, 16], [22, 108]]], 0, 0]],
                  locals: [],
                  templates: []
                };
              })();
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 12,
                      "column": 10
                    },
                    "end": {
                      "line": 25,
                      "column": 10
                    }
                  },
                  "moduleName": "cornerstone/components/content/settings-modal/template.hbs"
                },
                isEmpty: false,
                arity: 1,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("            ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("dt");
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n            ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("dd");
                  var el2 = dom.createTextNode("\n");
                  dom.appendChild(el1, el2);
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  var el2 = dom.createTextNode("            ");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element0 = dom.childAt(fragment, [3]);
                  var morphs = new Array(4);
                  morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
                  morphs[1] = dom.createMorphAt(element0, 1, 1);
                  morphs[2] = dom.createMorphAt(element0, 2, 2);
                  morphs[3] = dom.createMorphAt(element0, 3, 3);
                  return morphs;
                },
                statements: [["content", "control.label", ["loc", [null, [13, 16], [13, 33]]], 0, 0, 0, 0], ["block", "if", [["subexpr", "eq", ["text", ["get", "control.type", ["loc", [null, [15, 31], [15, 43]]], 0, 0, 0, 0]], [], ["loc", [null, [15, 20], [15, 44]]], 0, 0]], [], 0, null, ["loc", [null, [15, 14], [17, 21]]]], ["block", "if", [["subexpr", "eq", ["toggle", ["get", "control.type", ["loc", [null, [18, 33], [18, 45]]], 0, 0, 0, 0]], [], ["loc", [null, [18, 20], [18, 46]]], 0, 0]], [], 1, null, ["loc", [null, [18, 14], [20, 21]]]], ["block", "if", [["subexpr", "eq", ["select", ["get", "control.type", ["loc", [null, [21, 33], [21, 45]]], 0, 0, 0, 0]], [], ["loc", [null, [21, 20], [21, 46]]], 0, 0]], [], 2, null, ["loc", [null, [21, 14], [23, 21]]]]],
                locals: ["control"],
                templates: [child0, child1, child2]
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 10,
                    "column": 6
                  },
                  "end": {
                    "line": 27,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/content/settings-modal/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("dl");
                var el2 = dom.createTextNode("\n");
                dom.appendChild(el1, el2);
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("        ");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
                return morphs;
              },
              statements: [["block", "each", [["get", "section.controls", ["loc", [null, [12, 18], [12, 34]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [12, 10], [25, 19]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 28,
                    "column": 6
                  },
                  "end": {
                    "line": 32,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/content/settings-modal/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "content/settings-modal/responsive-text", [], ["items", ["subexpr", "@mut", [["get", "model.content.responsiveTextItems", ["loc", [null, [30, 16], [30, 49]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [29, 8], [31, 10]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 8,
                  "column": 4
                },
                "end": {
                  "line": 33,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/content/settings-modal/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("h3");
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(3);
              morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
              morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
              morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["content", "section.label", ["loc", [null, [9, 10], [9, 27]]], 0, 0, 0, 0], ["block", "if", [["get", "section.controls", ["loc", [null, [10, 12], [10, 28]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [10, 6], [27, 13]]]], ["block", "if", [["subexpr", "eq", [["get", "section.name", ["loc", [null, [28, 16], [28, 28]]], 0, 0, 0, 0], "responsive-text"], [], ["loc", [null, [28, 12], [28, 47]]], 0, 0]], [], 1, null, ["loc", [null, [28, 6], [32, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 7,
                "column": 2
              },
              "end": {
                "line": 34,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/settings-modal/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["subexpr", "eq", [["get", "modal.activeTab", ["loc", [null, [8, 14], [8, 29]]], 0, 0, 0, 0], ["get", "section.name", ["loc", [null, [8, 30], [8, 42]]], 0, 0, 0, 0]], [], ["loc", [null, [8, 10], [8, 43]]], 0, 0]], [], 0, null, ["loc", [null, [8, 4], [33, 11]]]]],
          locals: ["section"],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 35,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/settings-modal/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "sections", ["loc", [null, [7, 10], [7, 18]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [7, 2], [34, 11]]]]],
        locals: ["modal"],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 36,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/settings-modal/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "common/tab-modal", [], ["active", ["subexpr", "@mut", [["get", "modalOpen", ["loc", [null, [2, 9], [2, 18]]], 0, 0, 0, 0]], [], [], 0, 0], "panels", ["subexpr", "@mut", [["get", "sections", ["loc", [null, [3, 9], [3, 17]]], 0, 0, 0, 0]], [], [], 0, 0], "saveLabel", ["subexpr", "t", ["content.settings-done"], [], ["loc", [null, [4, 12], [4, 39]]], 0, 0]], 0, null, ["loc", [null, [1, 0], [35, 21]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/content/skeleton-mode/component', ['exports', 'ember', 'cornerstone/util/dragula', 'cornerstone/mixins/preview-listener', 'cornerstone/mixins/dragula-events'], function (exports, _ember, _cornerstoneUtilDragula, _cornerstoneMixinsPreviewListener, _cornerstoneMixinsDragulaEvents) {

  // const handlers = {
  //
  // 	editorCloned: function( clone, original, type ) {
  //
  // 		if ( 'mirror' != type ) {
  // 			Ember.$( original ).trigger( 'dragula:cloned', clone );
  // 			return;
  // 		}
  //
  // 		Ember.$( original ).trigger( 'dragula:mirror', clone );
  //
  //     Ember.run.next(()=> {
  //       Ember.$( original ).trigger( 'dragula:start', clone );
  // 			// cs.global.trigger( 'dragging', true );
  //     });
  //
  // 	},
  //
  // 	skeletonEnd: function( el ) {
  // 		// cs.global.trigger( 'dragging', false );
  // 		// cs.events.trigger( 'skeleton:dragging', false );
  // 	},
  //
  // 	skeletonStart: function( el, source ) {
  // 		var $el = Ember.$( el );
  // 		// cs.events.trigger( 'skeleton:dragging', true, $el.attr( 'data-element-type' ) );
  // 		$el.trigger( 'dragula:lift' );
  // 		Ember.$( source ).trigger( 'dragula:lift:child' );
  // 	},
  //
  // 	cancel: function( el, container, source ) {
  // 		// Ember.$( el ).trigger( 'dragula:dragend' );
  // 	},
  //
  // 	drop: function( el, target, source, sibling ) {
  // 		Ember.$( el ).trigger( 'dragula:drop', [ target, source, sibling ] );
  // 		Ember.$( target ).trigger( 'dragula:receive', [ el, source, sibling ] );
  // 	},
  //
  // 	over: function( el, container, source ) {
  // 		Ember.$( container ).trigger( 'dragula:over' );
  // 		Ember.$( source ).trigger( 'dragula:source:over' );
  // 	},
  //
  // 	out: function( el, container, source ) {
  // 		Ember.$( container ).trigger( 'dragula:out' );
  // 	},
  //
  // 	shadow: function( el, container, source ) {
  // 		Ember.$( source ).trigger( 'dragula:shadow' );
  // 	}
  //
  // };

  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsDragulaEvents['default'], _cornerstoneMixinsPreviewListener['default'], {
    classNames: ['cs-skeleton-mode'],
    classNameBindings: ['active:cs-active', 'draggingType'],

    elementService: _ember['default'].inject.service('element'),

    dragulaEvents: ['container'],
    dragulaContainerSelector: '.cs-skeleton-content-outer',

    active: _ember['default'].computed.alias('ui.skeletonModeActive'),

    orderSort: ['order'],
    sortedSections: _ember['default'].computed.sort('content.root.availableChildren', 'orderSort'),

    maxVisible: _ember['default'].computed('active', function () {
      return this.get('active') ? 1000 : 3;
    }),

    draggingType: _ember['default'].computed('elementService.incomingType', 'elementService.liftedElement.definition.id', function () {

      var type = this.getWithDefault('elementService.liftedElement.definition.id', '').replace('classic:', '');

      if (['row', 'column'].includes(type)) {
        return 'dragging-' + type;
      }

      if (this.get('elementService.incomingType') || type) {
        return 'dragging-element';
      }

      return null;
    }),

    init: function init() {
      var _this = this;

      this._super();

      this.componentListenTo('suspend-drag', function () {
        _this.set('ui.suspendDrag', true);
        _ember['default'].$('.cs-preview-frame-container').one('mouseleave', function () {
          _this.set('ui.suspendDrag', false);
          _this.get('ui.preview.xfr').message('preview:resume-drag');
        });
      });

      this.componentListenTo('stop-drag', function () {
        var drake = _this.get('elementDrake');
        if (drake && drake.cancel) {
          drake.cancel();
        }
        _this.set('ui.suspendDrag', false);
      });

      this.componentListenTo('drag-existing', function () {
        var mouseUp = function mouseUp() {
          document.removeEventListener('mouseup', mouseUp);
          _ember['default'].run.next(function () {
            _this.get('ui.preview.xfr').message('preview:drag-existing-end');
          });
        };
        document.addEventListener('mouseup', mouseUp);
      });
    },
    actions: {
      itemAction: function itemAction(action, element) {
        this.sendAction('on' + _ember['default'].String.capitalize(action), element);
      }
    },

    didInsertElement: function didInsertElement() {
      var _this2 = this;

      var elementDrake = (0, _cornerstoneUtilDragula['default'])({
        isContainer: function isContainer(el) {
          return !!el.classList && (el.classList.contains('cs-skeleton-container-column') || el.classList.contains('cs-element-library') || el.classList.contains('cs-element-library-classic'));
        },
        moves: function moves(el) {
          return !!el.classList && (el.classList.contains('cs-element-library-item') && !el.attributes.draggable || el.classList.contains('cs-skeleton-item') && !el.classList.contains('is-child') && !el.classList.contains('layout'));
        },
        accepts: function accepts(el, target) {
          if (!!target.classList && (target.classList.contains('cs-element-library') || target.classList.contains('cs-element-library-classic'))) {
            return false;
          }
          return !!el.classList && (el.classList.contains('cs-element-library-item') || el.classList.contains('cs-skeleton-item') && !el.classList.contains('is-child') && !el.classList.contains('layout'));
        },
        copy: function copy(el) {
          return !!el.classList && el.classList.contains('cs-element-library-item');
        },
        offset: function offset(_offset, e, el) {
          var $el = _ember['default'].$(el);
          if ($el.is('.cs-element-library-item')) {
            _offset.x = 16; // left inset hardcoded to half of SVG width
            _offset.y = $el.height() / 2; // snap to center Y
          }
          if ($el.is('cs-skeleton-item')) {
            _offset.y = _ember['default'].$(el).height() / 2; // snap to vertical center
          }
          return _offset;
        },
        revertOnSpill: true
      });

      elementDrake.on('drag', function () {
        _this2.set('ui.hideCursor', true);
      });

      elementDrake.on('dragend', function () {
        _this2.set('ui.hideCursor', false);
        _this2.set('ui.suspendDrag', false);
      });

      elementDrake.on('cloned', function (clone) {
        _this2.set('indicator', clone);
      });

      this.set('elementDrake', elementDrake);

      this.set('columnDrake', (0, _cornerstoneUtilDragula['default'])({
        isContainer: function isContainer(el) {
          return _ember['default'].$(el).is('.cs-skeleton-container-row');
        },
        moves: function moves(el, source, handle) {
          return _ember['default'].$(handle).is('.cs-skeleton-item.column > .cs-skeleton-item-handle > .cs-skeleton-title');
        },
        accepts: function accepts(el, target) {
          return _ember['default'].$(el).is('.cs-skeleton-item.column') && _ember['default'].$.contains(target, el);
        },
        offset: function offset(_offset2, e, el) {
          _offset2.x = _ember['default'].$(el).width() / 2; // snap center x
          return _offset2;
        },
        direction: 'horizontal',
        revertOnSpill: true
      }));

      this.set('rowDrake', (0, _cornerstoneUtilDragula['default'])({
        isContainer: function isContainer(el) {
          return _ember['default'].$(el).is('.cs-skeleton-container-section');
        },
        moves: function moves(el, source, handle /*, sibling*/) {
          return _ember['default'].$(handle).is('.cs-skeleton-item.row > .cs-skeleton-item-handle > .cs-skeleton-title');
        },
        accepts: function accepts(el) {
          return _ember['default'].$(el).is('.cs-skeleton-item.row');
        },
        revertOnSpill: true
      }));

      this.set('sectionDrake', (0, _cornerstoneUtilDragula['default'])({
        isContainer: function isContainer(el) {
          return _ember['default'].$(el).is('.cs-skeleton-content-inner');
        },
        moves: function moves(el, source, handle) {
          return _ember['default'].$(handle).is('.cs-skeleton-item.section > .cs-skeleton-item-handle > .cs-skeleton-title');
        },
        accepts: function accepts(el) {
          return _ember['default'].$(el).is('.cs-skeleton-item.section');
        },
        revertOnSpill: true
      }));
    },

    willDestroyElement: function willDestroyElement() {
      this.get('elementDrake').teardown();
      this.get('columnDrake').teardown();
      this.get('rowDrake').teardown();
      this.get('sectionDrake').teardown();
    }

  });
});
define('cornerstone/components/content/skeleton-mode/skeleton-item-handle/component', ['exports', 'ember'], function (exports, _ember) {
  var _slice = Array.prototype.slice;
  exports['default'] = _ember['default'].Component.extend({
    classNames: 'cs-skeleton-item-handle',

    controls: _ember['default'].computed('item.atts._type', function () {
      var type = this.getWithDefault('item.atts._type', '').replace('classic:', '');
      var controls = _ember['default'].A();
      var isLayout = this.get('item.definition.isContentLayout');

      if (isLayout) {
        controls.push({
          action: 'manageElementLayout',
          icon: 'bars'
        });
      }

      if ('column' === type) {
        controls.push({
          action: 'eraseElement',
          icon: 'eraser'
        });
      } else {
        controls.push({
          action: 'duplicateElement',
          icon: 'copy'
        });
        controls.push({
          action: 'deleteElement',
          icon: 'trash-o'
        });
        if (isLayout) {
          controls.push({
            action: 'collapse',
            icon: 'caret-down'
          });
        }
      }

      return controls;
    }),

    collapsible: _ember['default'].computed('item.definition.isContentLayout', function () {
      if (!this.get('item.definition.isContentLayout')) {
        return false;
      }
      return 'column' !== this.getWithDefault('item.atts._type', '').replace('classic:', '');
    }),

    title: _ember['default'].computed('item.definition.title', 'item.title', function () {

      var title = this.get('atts.title');
      var type = this.get('item.definition.title');

      if (!title) {
        return type;
      }

      return this.get('i18n').t('content.skeleton-item-handle', { title: title, type: type });
    }),

    mouseEnter: function mouseEnter() {
      this.sendAction('onMouseEnter');
    },

    mouseLeave: function mouseLeave() {
      this.sendAction('onMouseLeave');
    },

    actions: {
      titleClick: function titleClick() {
        // if NOT dragging
        this.sendAction.apply(this, ['onHandleClick'].concat(_slice.call(arguments)));
      },
      controlClick: function controlClick() {
        this.sendAction.apply(this, ['onControlClick'].concat(_slice.call(arguments)));
      }
    }

  });
});
define("cornerstone/components/content/skeleton-mode/skeleton-item-handle/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 2
            },
            "end": {
              "line": 5,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/content/skeleton-mode/skeleton-item-handle/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          morphs[1] = dom.createElementMorph(element0);
          morphs[2] = dom.createMorphAt(element0, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["get", "control.class", ["loc", [null, [4, 21], [4, 34]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["controlClick", ["get", "control.action", ["loc", [null, [4, 62], [4, 76]]], 0, 0, 0, 0]], [], ["loc", [null, [4, 38], [4, 78]]], 0, 0], ["inline", "icon", [["get", "control.icon", ["loc", [null, [4, 86], [4, 98]]], 0, 0, 0, 0]], [], ["loc", [null, [4, 79], [4, 100]]], 0, 0]],
        locals: ["control"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 7,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/skeleton-mode/skeleton-item-handle/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-skeleton-title");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-skeleton-controls");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element1 = dom.childAt(fragment, [0]);
        var morphs = new Array(3);
        morphs[0] = dom.createElementMorph(element1);
        morphs[1] = dom.createMorphAt(element1, 0, 0);
        morphs[2] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        return morphs;
      },
      statements: [["element", "action", ["titleClick"], [], ["loc", [null, [1, 31], [1, 54]]], 0, 0], ["content", "title", ["loc", [null, [1, 55], [1, 64]]], 0, 0, 0, 0], ["block", "each", [["get", "controls", ["loc", [null, [3, 10], [3, 18]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [3, 2], [5, 11]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/content/skeleton-mode/skeleton-item/component', ['exports', 'ember', 'cornerstone/mixins/dragula-events'], function (exports, _ember, _cornerstoneMixinsDragulaEvents) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsDragulaEvents['default'], {

    elementService: _ember['default'].inject.service('element'),
    dragulaEvents: ['element', 'container'],
    dragulaContainerSelector: '.cs-skeleton-container-inner',

    classNames: 'cs-skeleton-item',
    classNameBindings: ['typeClass', 'isLayout:layout', 'elementClass', 'isHovering:cs-hover', 'collapsed', 'receiving:cs-receiving'],
    receiving: false,

    isLayout: _ember['default'].computed('typeClass', function () {
      return 'element' !== this.get('typeClass');
    }),

    typeClass: _ember['default'].computed('item.atts._type', function () {
      var type = this.getWithDefault('item.atts._type', '').replace('classic:', '');
      if (['section', 'row', 'column'].includes(type)) {
        return type;
      }
      return 'element';
    }),

    dragulaDrag: function dragulaDrag() {
      this.set('elementService.liftedElement', this.get('item'));
    },

    dragulaCancel: function dragulaCancel() {
      this.set('elementService.liftedElement', null);
    },

    dragulaDropInto: function dragulaDropInto(e, el, target, source, sibling) {

      var liftedElement = this.get('elementService.liftedElement');
      var incomingType = this.get('elementService.incomingType');

      // Tested - all three modes are properly sending their intended index.
      // Sometimes when an item is moved from one container to another, it's final index is wrong.
      // see entity/model changeParent method

      var index = _ember['default'].$(sibling).index();
      index = -1 === index ? null : index - 1;

      if (liftedElement) {
        if (liftedElement.get('parent.id') !== this.get('item.id')) {
          el.remove();
        }
        this.sendAction('onMoveElement', liftedElement, index, this.get('item'));
        this.set('elementService.liftedElement', null);
        return;
      }

      if (incomingType) {
        this.sendAction('onAddElement', this.get('item'), { _type: incomingType }, index);
        this.set('elementService.incomingType', null);
        el.remove();
      }
    },

    dragulaOverContainer: function dragulaOverContainer() {
      this.set('receiving', true);
    },

    dragulaOutContainer: function dragulaOutContainer() {
      this.set('receiving', false);
    },

    elementClass: _ember['default'].computed('item.atts._type', 'item.atts.size', function () {
      if ('column' === this.getWithDefault('item.atts._type', '').replace('classic:', '')) {
        return 'size-' + this.get('item.atts.size').replace('/', '-');
      }
      return '';
    }),

    containerClass: _ember['default'].computed('', function () {
      return _ember['default'].String.htmlSafe('cs-skeleton-container-' + this.get('typeClass'));
    }),

    orderSort: ['order'],

    visibleChildren: _ember['default'].computed.filter('item.availableChildren', function (item) {
      return false !== item.get('atts._active');
    }),

    sortedChildren: _ember['default'].computed.sort('visibleChildren', 'orderSort'),

    preserveGuTransit: function preserveGuTransit() {
      var _this = this;

      if (this.$().hasClass('gu-transit')) {
        _ember['default'].run.scheduleOnce('afterRender', function () {
          if (!_this.isDestroyed) {
            _this.$().addClass('gu-transit');
          }
        });
      }
    },

    actions: {

      handleMouseEnter: function handleMouseEnter() {
        if (this.get('elementService.liftedElement') || this.get('elementService.incomingType')) {
          return; // don't cs-hover during a drag
        }
        this.preserveGuTransit();
        this.set('isHovering', true);
        this.send('itemAction', 'mouseEnter');
      },

      handleMouseLeave: function handleMouseLeave() {
        this.preserveGuTransit();
        this.set('isHovering', false);
        this.send('itemAction', 'mouseLeave');
      },

      itemAction: function itemAction(action, item) {

        if ('collapse' === action) {
          this.set('collapsed', !this.get('collapsed'));
          return;
        }

        if (!item) {
          item = this.get('item');
        }

        this.sendAction('onItemAction', action, item);
      }
    }

  });
});
define("cornerstone/components/content/skeleton-mode/skeleton-item/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 10,
              "column": 4
            },
            "end": {
              "line": 17,
              "column": 4
            }
          },
          "moduleName": "cornerstone/components/content/skeleton-mode/skeleton-item/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("      ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "content/skeleton-mode/skeleton-item", [], ["item", ["subexpr", "@mut", [["get", "child", ["loc", [null, [12, 13], [12, 18]]], 0, 0, 0, 0]], [], [], 0, 0], "onItemAction", ["subexpr", "action", ["itemAction"], [], ["loc", [null, [13, 21], [13, 42]]], 0, 0], "onAddElement", ["subexpr", "@mut", [["get", "onAddElement", ["loc", [null, [14, 21], [14, 33]]], 0, 0, 0, 0]], [], [], 0, 0], "onMoveElement", ["subexpr", "@mut", [["get", "onMoveElement", ["loc", [null, [15, 22], [15, 35]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [11, 6], [16, 8]]], 0, 0]],
        locals: ["child"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 20,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/skeleton-mode/skeleton-item/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-skeleton-container-outer");
        var el2 = dom.createTextNode("\n	");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [2, 1]);
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createAttrMorph(element0, 'class');
        morphs[2] = dom.createMorphAt(element0, 1, 1);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "content/skeleton-mode/skeleton-item-handle", [], ["onMouseEnter", ["subexpr", "action", ["handleMouseEnter"], [], ["loc", [null, [2, 15], [2, 42]]], 0, 0], "onMouseLeave", ["subexpr", "action", ["handleMouseLeave"], [], ["loc", [null, [3, 15], [3, 42]]], 0, 0], "onHandleClick", ["subexpr", "route-action", ["inspectElement", ["get", "item", ["loc", [null, [4, 47], [4, 51]]], 0, 0, 0, 0]], [], ["loc", [null, [4, 16], [4, 52]]], 0, 0], "onControlClick", ["subexpr", "action", ["itemAction"], [], ["loc", [null, [5, 17], [5, 38]]], 0, 0], "item", ["subexpr", "@mut", [["get", "item", ["loc", [null, [6, 7], [6, 11]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [1, 0], [7, 2]]], 0, 0], ["attribute", "class", ["concat", ["cs-skeleton-container-inner ", ["get", "containerClass", ["loc", [null, [9, 43], [9, 57]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "each", [["get", "sortedChildren", ["loc", [null, [10, 12], [10, 26]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [10, 4], [17, 13]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("cornerstone/components/content/skeleton-mode/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 4,
                  "column": 6
                },
                "end": {
                  "line": 11,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/content/skeleton-mode/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "content/skeleton-mode/skeleton-item", [], ["item", ["subexpr", "@mut", [["get", "section", ["loc", [null, [6, 15], [6, 22]]], 0, 0, 0, 0]], [], [], 0, 0], "onItemAction", ["subexpr", "action", ["itemAction"], [], ["loc", [null, [7, 23], [7, 44]]], 0, 0], "onAddElement", ["subexpr", "route-action", ["addElement"], [], ["loc", [null, [8, 23], [8, 50]]], 0, 0], "onMoveElement", ["subexpr", "route-action", ["moveElement"], [], ["loc", [null, [9, 24], [9, 52]]], 0, 0]], ["loc", [null, [5, 8], [10, 10]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 4
              },
              "end": {
                "line": 12,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/content/skeleton-mode/template.hbs"
          },
          isEmpty: false,
          arity: 2,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "unless", [["subexpr", "gte", [["get", "index", ["loc", [null, [4, 21], [4, 26]]], 0, 0, 0, 0], ["get", "maxVisible", ["loc", [null, [4, 27], [4, 37]]], 0, 0, 0, 0]], [], ["loc", [null, [4, 16], [4, 38]]], 0, 0]], [], 0, null, ["loc", [null, [4, 6], [11, 17]]]]],
          locals: ["section", "index"],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 2
            },
            "end": {
              "line": 13,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/content/skeleton-mode/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "sortedSections", ["loc", [null, [3, 12], [3, 26]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [3, 4], [12, 13]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 15,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/skeleton-mode/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-skeleton-content-outer");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0]), 1, 1);
        return morphs;
      },
      statements: [["block", "common/scroll-box", [], ["class", "cs-skeleton-content-inner"], 0, null, ["loc", [null, [2, 2], [13, 24]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/content/workspace-elements/component', ['exports', 'ember', 'cornerstone/components/workspace/cs-workspace/component'], function (exports, _ember, _cornerstoneComponentsWorkspaceCsWorkspaceComponent) {
  exports['default'] = _cornerstoneComponentsWorkspaceCsWorkspaceComponent['default'].extend({
    classNames: ['elements'],

    isSearching: _ember['default'].computed.alias('searchData.isSearching'),

    filteredSearchResults: _ember['default'].computed('searchData.results', function () {

      var results = this.get('searchData.results');

      var isSearching = this.get('isSearching');
      var filtered = this.get('elementDefinitions').filter(function (item) {
        return !isSearching || results.includes(item.get('id').toString());
      });

      return filtered;
    }),

    // searchResults: Ember.computed.sort('filteredSearchResults', function( a, b ) {
    //
    //   let cmp = a.getWithDefault('postTypeLabel','').localeCompare( b.get('postTypeLabel') );
    //
    //   if (0 === cmp) {
    //     return a.get('title').localeCompare( b.get('title') );
    //   }
    //
    //   return cmp;
    //
    // }),

    titleSort: ['title'],

    elementLibrary: _ember['default'].computed.filter('filteredSearchResults.[]', function (item) {
      if (item.get('isClassic')) {
        return false;
      }
      return item.getWithDefault('showInLibrary', false);
    }),

    classicElementLibrary: _ember['default'].computed.filter('filteredSearchResults.[]', function (item) {
      if (!item.get('isClassic')) {
        return false;
      }
      return item.getWithDefault('showInLibrary', false);
    }),

    hasResults: _ember['default'].computed('sortedElementLibrary.length', 'classicElementLibrary.length', function () {
      return this.get('sortedElementLibrary.length') + this.get('classicElementLibrary.length') > 0;
    }),

    sortedElementLibrary: _ember['default'].computed.sort('elementLibrary', 'titleSort'),
    sortedClassicElementLibrary: _ember['default'].computed.sort('classicElementLibrary', 'titleSort'),

    init: function init() {
      this._super.apply(this, arguments);
      this.set('searchData', this.get('ui.search').getTarget('content-elements'));
      this.set('searchData.query', '');
    }

  });
});
define("cornerstone/components/content/workspace-elements/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 16,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/workspace-elements/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-workspace-search");
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(dom.childAt(fragment, [3]), 1, 1);
          return morphs;
        },
        statements: [["inline", "workspace/workspace-nav", [], ["items", ["subexpr", "array", [["subexpr", "hash", [], ["route", "content.builder.layout", "label", ["subexpr", "t", ["app.layout.title"], [], ["loc", [null, [4, 49], [4, 71]]], 0, 0], "class", "layout"], ["loc", [null, [4, 6], [4, 87]]], 0, 0], ["subexpr", "hash", [], ["route", "content.builder.elements", "label", ["subexpr", "t", ["app.elements.title"], [], ["loc", [null, [5, 51], [5, 75]]], 0, 0], "class", "elements"], ["loc", [null, [5, 6], [5, 93]]], 0, 0], ["subexpr", "hash", [], ["route", "content.builder.inspector", "label", ["subexpr", "t", ["app.inspector.title"], [], ["loc", [null, [6, 52], [6, 77]]], 0, 0], "class", "inspector"], ["loc", [null, [6, 6], [6, 96]]], 0, 0]], [], ["loc", [null, [3, 10], [7, 5]]], 0, 0]], ["loc", [null, [2, 2], [8, 4]]], 0, 0], ["inline", "common/search-bar", [], ["target", "content-elements", "placeholder", ["subexpr", "t", ["content.elements-search"], [], ["loc", [null, [12, 18], [12, 47]]], 0, 0], "autoFocus", true], ["loc", [null, [10, 4], [14, 6]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 19,
                "column": 2
              },
              "end": {
                "line": 28,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/workspace-elements/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "elements/element-library", [], ["draggable", true, "elements", ["subexpr", "@mut", [["get", "sortedElementLibrary", ["loc", [null, [22, 15], [22, 35]]], 0, 0, 0, 0]], [], [], 0, 0], "classicElements", ["subexpr", "@mut", [["get", "sortedClassicElementLibrary", ["loc", [null, [23, 22], [23, 49]]], 0, 0, 0, 0]], [], [], 0, 0], "isSearching", ["subexpr", "@mut", [["get", "isSearching", ["loc", [null, [24, 18], [24, 29]]], 0, 0, 0, 0]], [], [], 0, 0], "onDragStart", ["subexpr", "route-action", ["elementLibraryDragStart"], [], ["loc", [null, [25, 18], [25, 58]]], 0, 0], "onDragEnd", ["subexpr", "route-action", ["elementLibraryDragEnd"], [], ["loc", [null, [26, 16], [26, 54]]], 0, 0]], ["loc", [null, [20, 4], [27, 6]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 29,
                  "column": 4
                },
                "end": {
                  "line": 31,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/content/workspace-elements/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("p");
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
              return morphs;
            },
            statements: [["inline", "t", ["content.no-elements-found-message"], [], ["loc", [null, [30, 9], [30, 50]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 28,
                "column": 2
              },
              "end": {
                "line": 32,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/workspace-elements/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "workspace/workspace-message", [], ["title", ["subexpr", "t", ["content.no-elements-found"], [], ["loc", [null, [29, 41], [29, 72]]], 0, 0]], 0, null, ["loc", [null, [29, 4], [31, 36]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 18,
              "column": 0
            },
            "end": {
              "line": 33,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/workspace-elements/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "hasResults", ["loc", [null, [19, 8], [19, 18]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [19, 2], [32, 9]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 36,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/workspace-elements/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "workspace/workspace-header", [], [], 0, null, ["loc", [null, [1, 0], [16, 31]]]], ["block", "workspace/workspace-content", [], ["name", "content-elements", "linkedSearch", "content-elements"], 1, null, ["loc", [null, [18, 0], [33, 32]]]], ["content", "yield", ["loc", [null, [35, 0], [35, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/content/workspace-inspector/component', ['exports', 'ember', 'cornerstone/components/workspace/cs-workspace/component'], function (exports, _ember, _cornerstoneComponentsWorkspaceCsWorkspaceComponent) {
  exports['default'] = _cornerstoneComponentsWorkspaceCsWorkspaceComponent['default'].extend({
    classNames: ['inspector'],
    service: _ember['default'].inject.service('content/builder'),
    inspectorService: _ember['default'].inject.service('content/builder/inspector'),
    inspecting: _ember['default'].computed.alias('inspectorService.inspecting'),

    init: function init() {
      this._super.apply(this, arguments);
      this.set('inspectingChild', false === this.get('inspecting.parent.definition.isPrivate'));
    },

    inspectingChildObserver: _ember['default'].observer('inspecting.parent.definition.isPrivate', function () {
      if (this.get('inspecting')) {
        this.set('inspectingChild', false === this.get('inspecting.parent.definition.isPrivate'));
      }
    }),

    inspectingChild: false,

    isInspectingColumn: _ember['default'].computed('inspecting.definition.id', function () {
      return 'column' === this.getWithDefault('inspecting.definition.id', '').replace('classic:', '');
    }),

    // paneTitle: Ember.computed('inspecting.title', function() {
    //   return this.getWithDefault('title', this.get('i18n').t('app.inspector.title'));
    // }),
    //

    actions: {
      applyPreset: function applyPreset(presetId) {
        this.get('inspectorService').applyPreset(presetId);
      },
      savePreset: function savePreset(name) {
        console.log(name);
      }
    }

  });
});
define("cornerstone/components/content/workspace-inspector/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 9,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "workspace/workspace-nav", [], ["items", ["subexpr", "array", [["subexpr", "hash", [], ["route", "content.builder.layout", "label", ["subexpr", "t", ["app.layout.title"], [], ["loc", [null, [4, 49], [4, 71]]], 0, 0], "class", "layout"], ["loc", [null, [4, 6], [4, 87]]], 0, 0], ["subexpr", "hash", [], ["route", "content.builder.elements", "label", ["subexpr", "t", ["app.elements.title"], [], ["loc", [null, [5, 51], [5, 75]]], 0, 0], "class", "elements"], ["loc", [null, [5, 6], [5, 93]]], 0, 0], ["subexpr", "hash", [], ["route", "content.builder.inspector", "label", ["subexpr", "t", ["app.inspector.title"], [], ["loc", [null, [6, 52], [6, 77]]], 0, 0], "class", "inspector"], ["loc", [null, [6, 6], [6, 96]]], 0, 0]], [], ["loc", [null, [3, 10], [7, 5]]], 0, 0]], ["loc", [null, [2, 2], [8, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 19,
                  "column": 4
                },
                "end": {
                  "line": 27,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "common/bread-crumbs", [], ["activeItem", ["subexpr", "@mut", [["get", "inspectorService.inspecting", ["loc", [null, [21, 19], [21, 46]]], 0, 0, 0, 0]], [], [], 0, 0], "items", ["subexpr", "@mut", [["get", "inspectorService.breadcrumbs", ["loc", [null, [22, 14], [22, 42]]], 0, 0, 0, 0]], [], [], 0, 0], "onNavigate", ["subexpr", "route-action", ["inspectElement"], [], ["loc", [null, [23, 19], [23, 50]]], 0, 0], "onMouseEnter", ["subexpr", "route-action", ["observeStart"], [], ["loc", [null, [24, 21], [24, 50]]], 0, 0], "onMouseLeave", ["subexpr", "route-action", ["observeEnd"], [], ["loc", [null, [25, 21], [25, 48]]], 0, 0]], ["loc", [null, [20, 6], [26, 8]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 29,
                  "column": 4
                },
                "end": {
                  "line": 34,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "common/help-text", [], ["title", ["subexpr", "t", ["app.elements-undefined-inspector-title"], [], ["loc", [null, [31, 14], [31, 58]]], 0, 0], "message", ["subexpr", "t", ["app.elements-undefined-inspector-message", ["subexpr", "hash", [], ["type", ["get", "inspectorService.inspecting.atts._type", ["loc", [null, [32, 73], [32, 111]]], 0, 0, 0, 0]], ["loc", [null, [32, 62], [32, 112]]], 0, 0]], [], ["loc", [null, [32, 16], [32, 113]]], 0, 0]], ["loc", [null, [30, 6], [33, 8]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 36,
                  "column": 4
                },
                "end": {
                  "line": 41,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "common/help-text", [], ["title", "Classic Element", "message", "This is a classic element. These are supported, but have less controls to configure."], ["loc", [null, [37, 6], [40, 8]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 48,
                    "column": 6
                  },
                  "end": {
                    "line": 54,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "workspace/workspace-actions/action-item", [], ["label", ["subexpr", "t", ["content.inspector-manage-layout"], [], ["loc", [null, [50, 16], [50, 53]]], 0, 0], "content", ["subexpr", "icon", ["bars"], [], ["loc", [null, [51, 18], [51, 31]]], 0, 0], "action", ["subexpr", "route-action", ["manageElementLayout", ["get", "inspecting", ["loc", [null, [52, 53], [52, 63]]], 0, 0, 0, 0]], [], ["loc", [null, [52, 17], [52, 64]]], 0, 0]], ["loc", [null, [49, 8], [53, 10]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 54,
                    "column": 6
                  },
                  "end": {
                    "line": 60,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "workspace/workspace-actions/action-item", [], ["label", ["subexpr", "t", ["content.inspector-duplicate"], [], ["loc", [null, [56, 16], [56, 49]]], 0, 0], "content", ["subexpr", "icon", ["copy"], [], ["loc", [null, [57, 18], [57, 31]]], 0, 0], "action", ["subexpr", "route-action", ["duplicateElement", ["get", "inspecting", ["loc", [null, [58, 50], [58, 60]]], 0, 0, 0, 0]], [], ["loc", [null, [58, 17], [58, 61]]], 0, 0]], ["loc", [null, [55, 8], [59, 10]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child2 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 61,
                    "column": 6
                  },
                  "end": {
                    "line": 68,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "workspace/workspace-actions/action-item", [], ["label", ["subexpr", "t", ["content.inspector-erase"], [], ["loc", [null, [63, 16], [63, 45]]], 0, 0], "quickConfirmLabel", ["subexpr", "t", ["content.inspector-really-erase"], [], ["loc", [null, [64, 28], [64, 64]]], 0, 0], "content", ["subexpr", "icon", ["eraser"], [], ["loc", [null, [65, 18], [65, 33]]], 0, 0], "action", ["subexpr", "route-action", ["eraseElement", ["get", "inspecting", ["loc", [null, [66, 46], [66, 56]]], 0, 0, 0, 0]], [], ["loc", [null, [66, 17], [66, 57]]], 0, 0]], ["loc", [null, [62, 8], [67, 10]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child3 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 68,
                    "column": 6
                  },
                  "end": {
                    "line": 75,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "workspace/workspace-actions/action-item", [], ["label", ["subexpr", "t", ["content.inspector-delete"], [], ["loc", [null, [70, 16], [70, 46]]], 0, 0], "quickConfirmLabel", ["subexpr", "t", ["content.inspector-really-delete"], [], ["loc", [null, [71, 28], [71, 65]]], 0, 0], "content", ["subexpr", "icon", ["trash"], [], ["loc", [null, [72, 18], [72, 32]]], 0, 0], "action", ["subexpr", "route-action", ["deleteElement", ["get", "inspecting", ["loc", [null, [73, 47], [73, 57]]], 0, 0, 0, 0]], [], ["loc", [null, [73, 17], [73, 58]]], 0, 0]], ["loc", [null, [69, 8], [74, 10]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 43,
                  "column": 4
                },
                "end": {
                  "line": 76,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(2);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "if", [["get", "inspecting.definition.isContentLayout", ["loc", [null, [48, 12], [48, 49]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [48, 6], [60, 13]]]], ["block", "if", [["get", "isInspectingColumn", ["loc", [null, [61, 12], [61, 30]]], 0, 0, 0, 0]], [], 2, 3, ["loc", [null, [61, 6], [75, 13]]]]],
            locals: [],
            templates: [child0, child1, child2, child3]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 11,
                "column": 2
              },
              "end": {
                "line": 77,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(4);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 6, 6, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "inspectorService.breadcrumbs", ["loc", [null, [19, 10], [19, 38]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [19, 4], [27, 11]]]], ["block", "if", [["subexpr", "eq", ["undefined", ["get", "inspectorService.inspecting.definition.id", ["loc", [null, [29, 26], [29, 67]]], 0, 0, 0, 0]], [], ["loc", [null, [29, 10], [29, 68]]], 0, 0]], [], 1, null, ["loc", [null, [29, 4], [34, 11]]]], ["block", "if", [["get", "inspectorService.inspecting.definition.options.is_classic", ["loc", [null, [36, 10], [36, 67]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [36, 4], [41, 11]]]], ["block", "workspace/inspector-actions", [], ["presets", ["subexpr", "@mut", [["get", "inspectorService.presets", ["loc", [null, [44, 14], [44, 38]]], 0, 0, 0, 0]], [], [], 0, 0], "onApply", ["subexpr", "action", ["applyPreset"], [], ["loc", [null, [45, 14], [45, 36]]], 0, 0], "onSave", ["subexpr", "action", ["savePreset"], [], ["loc", [null, [46, 13], [46, 34]]], 0, 0]], 3, null, ["loc", [null, [43, 4], [76, 36]]]]],
          locals: [],
          templates: [child0, child1, child2, child3]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 10,
              "column": 0
            },
            "end": {
              "line": 78,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "workspace/workspace-controls", [], ["name", "inspector", "searchTarget", "content-inspector", "searchPlaceholder", ["subexpr", "t", ["app.inspector.search"], [], ["loc", [null, [14, 22], [14, 48]]], 0, 0], "controls", ["subexpr", "@mut", [["get", "inspectorService.controlProxies", ["loc", [null, [15, 13], [15, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "groups", ["subexpr", "@mut", [["get", "inspectorService.controlGroups", ["loc", [null, [16, 11], [16, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "orientation", "vertical"], 0, null, ["loc", [null, [11, 2], [77, 35]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 80,
                  "column": 4
                },
                "end": {
                  "line": 84,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("span");
              dom.setAttribute(el1, "class", "cs-empty-inspector-icon");
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("h3");
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("p");
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(3);
              morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
              morphs[1] = dom.createMorphAt(dom.childAt(fragment, [3]), 0, 0);
              morphs[2] = dom.createMorphAt(dom.childAt(fragment, [5]), 0, 0);
              return morphs;
            },
            statements: [["inline", "icon", ["interface/logo-flat-inspector"], [], ["loc", [null, [81, 44], [81, 84]]], 0, 0], ["inline", "t", ["content.inspector-blank-pane-title"], [], ["loc", [null, [82, 10], [82, 52]]], 0, 0], ["inline", "t", ["content.inspector-blank-pane-message"], [], ["loc", [null, [83, 9], [83, 53]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 79,
                "column": 2
              },
              "end": {
                "line": 85,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "workspace/workspace-message", [], [], 0, null, ["loc", [null, [80, 4], [84, 36]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 78,
              "column": 0
            },
            "end": {
              "line": 86,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "unless", [["get", "inspectorService.transitioning", ["loc", [null, [79, 12], [79, 42]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [79, 2], [85, 13]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 89,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/workspace-inspector/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "workspace/workspace-header", [], [], 0, null, ["loc", [null, [1, 0], [9, 31]]]], ["block", "if", [["get", "inspecting", ["loc", [null, [10, 6], [10, 16]]], 0, 0, 0, 0]], [], 1, 2, ["loc", [null, [10, 0], [86, 7]]]], ["content", "yield", ["loc", [null, [88, 0], [88, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1, child2]
    };
  })());
});
define('cornerstone/components/content/workspace-layout/component', ['exports', 'ember', 'cornerstone/components/workspace/cs-workspace/component'], function (exports, _ember, _cornerstoneComponentsWorkspaceCsWorkspaceComponent) {
  exports['default'] = _cornerstoneComponentsWorkspaceCsWorkspaceComponent['default'].extend({
    classNames: ['layout'],
    service: _ember['default'].inject.service('content/builder'),
    preview: _ember['default'].inject.service(),
    orderSort: ['order'],
    sortedSections: _ember['default'].computed.sort('content.root.availableChildren', 'orderSort'),

    didReceiveAttrs: function didReceiveAttrs() {
      var managing = this.get('managing');
      if (managing) {
        var type = managing.get('atts._type').replace('classic:', '');
        if ('section' === type) {
          this.send('selectSection', managing);
        } else if ('row' === type) {
          this.send('selectRow', managing);
        } else if ('column' === type) {
          this.send('selectRow', managing.get('parent'));
        }
        this.set('managing', null);
      }
    },

    actions: {

      selectSection: function selectSection(section) {
        if (this.get('selectedSection.id') === section.get('id')) {
          this.set('selectedSection', null);
          return;
        }
        this.set('selectedSection', section);
        this.set('selectedRowId', this.getWithDefault('selectedSection.availableChildren.firstObject.id', null));
        if (section) {
          this.get('preview.xfr').message('preview:scroll-to-element', section.get('id'));
        }
      },

      selectRow: function selectRow(row) {

        if (row) {

          this.set('selectedRowId', row.get('id'));

          if (this.get('selectedSection.id') !== row.get('parent.id')) {
            this.set('selectedSection', row.get('parent'));
          }

          this.get('preview.xfr').message('preview:scroll-to-element', row.get('id'));
        } else {
          this.set('selectedRowId', null);
          this.set('selectedSection', null);
        }
      },

      addFirstSection: function addFirstSection() {
        this.get('content.root.addChild')({
          _type: 'section',
          _region: 'content'
        });
      },

      addFirstRow: function addFirstRow(section) {
        var _this = this;

        section.get('addChild')({
          _type: 'section' === section.get('definition.id') ? 'row' : 'classic:row',
          _region: 'content'
        });

        _ember['default'].run.next(function () {
          var child = section.get('availableChildren.firstObject');
          if (child) {
            _this.set('selectedRow', child);
          }
        });
      }

    }

  });
});
define('cornerstone/components/content/workspace-layout/panel-templates/component', ['exports', 'ember'], function (exports, _ember) {

  function optionMapper(items) {
    return items.map(function (item) {
      return { value: item.get('id'), label: item.get('title') };
    });
  }

  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-absolute-workspace', 'templates'],

    showSaveDialog: false,
    showUploadDialog: false,
    saveTitle: '',

    titleSort: ['title'],
    hasEntries: _ember['default'].computed.gt('templates.length', 0),
    sortedThemecoPages: _ember['default'].computed.sort('themecoPages', 'titleSort'),
    sortedThemecoBlocks: _ember['default'].computed.sort('themecoBlocks', 'titleSort'),
    sortedUserPages: _ember['default'].computed.sort('userPages', 'titleSort'),
    sortedUserBlocks: _ember['default'].computed.sort('userBlocks', 'titleSort'),
    sortedDeleteableItems: _ember['default'].computed.sort('deleteableItems', 'titleSort'),
    themecoPages: _ember['default'].computed.filterBy('templates', 'section', 'themeco-pages'),
    themecoBlocks: _ember['default'].computed.filterBy('templates', 'section', 'themeco-blocks'),
    userPages: _ember['default'].computed.filterBy('templates', 'section', 'user-pages'),
    userBlocks: _ember['default'].computed.filterBy('templates', 'section', 'user-blocks'),
    deleteableItems: _ember['default'].computed.filter('templates', function (item) {
      return ['user-pages', 'user-blocks'].includes(item.get('section'));
    }),

    themecoPageOptions: _ember['default'].computed('sortedThemecoPages', function () {
      return optionMapper(this.get('sortedThemecoPages'));
    }),

    themecoBlockOptions: _ember['default'].computed('sortedThemecoBlocks', function () {
      return optionMapper(this.get('sortedThemecoBlocks'));
    }),

    userPageOptions: _ember['default'].computed('sortedUserPages', function () {
      return optionMapper(this.get('sortedUserPages'));
    }),

    userBlockOptions: _ember['default'].computed('sortedUserBlocks', function () {
      return optionMapper(this.get('sortedUserBlocks'));
    }),

    deletableItemOptions: _ember['default'].computed.union('userPageOptions', 'userBlockOptions'),

    actions: {

      openSaveDialog: function openSaveDialog() {
        this.set('saveTitle', this.get('i18n').t('content.templates-title'));
        this.set('showSaveDialog', true);
      },

      openUploadDialog: function openUploadDialog() {
        this.set('showUploadDialog', true);
      },

      closeSaveDialog: function closeSaveDialog() {
        this.set('showSaveDialog', false);
      },

      closeUploadDialog: function closeUploadDialog() {
        this.set('showUploadDialog', false);
      },

      addThemecoPage: function addThemecoPage() {
        this.send('insertPage', this.getWithDefault('selectedThemecoPage', this.get('themecoPageOptions.firstObject.value')));
      },

      addThemecoBlock: function addThemecoBlock() {
        this.send('insertTemplate', this.getWithDefault('selectedThemecoBlock', this.get('themecoBlockOptions.firstObject.value')));
      },

      addUserPage: function addUserPage() {
        this.send('insertPage', this.getWithDefault('selectedUserPage', this.get('userPageOptions.firstObject.value')));
      },

      addUserBlock: function addUserBlock() {
        this.sendAction('onInsertTemplate', this.getWithDefault('selectedUserBlock', this.get('userBlockOptions.firstObject.value')), 'block');
      },

      insertPage: function insertPage(id) {
        var _this = this;

        this.get('ui').confirm({
          message: this.get('i18n').t('content.templates-overwrite-message'),
          accept: function accept() {
            return _this.sendAction('onInsertTemplate', id, 'page');
          },
          acceptClass: 'sad'
        });
      },

      uploadTemplate: function uploadTemplate() {
        var _this2 = this;

        this.get('ui').confirm({
          message: this.get('i18n').t('content.templates-upload-message'),
          accept: function accept() {
            return _this2.send('uploadTemplateFormat', 'page');
          },
          decline: function decline() {
            return _this2.send('uploadTemplateFormat', 'block');
          },
          acceptBtn: this.get('i18n').t('content.templates-upload-yep'),
          declineBtn: this.get('i18n').t('content.templates-upload-nope'),
          noSkip: true,
          acceptClass: 'sad'
        });
      },

      uploadTemplateFormat: function uploadTemplateFormat(format) {
        var _this3 = this;

        this.get('ui').notify('i18n.content.templates-upload-start');

        var file = this.$('#template-upload')[0].files[0];

        if (!file || !file.name.match(/.+\.csl/)) {
          return this.get('ui').notify('i18n.content.templates-error-upload', 'error');
        }

        var reader = new FileReader();

        reader.onload = function () {
          _this3.sendAction('onUploadTemplate', JSON.parse(reader.result), format);
          var $input = _this3.$('#template-upload');
          $input.replaceWith($input.clone());
          _this3.set('showUploadDialog', false);
        };

        _ember['default'].run.next(function () {
          try {
            reader.readAsText(file);
          } catch (e) {
            _this3.get('ui').notify('i18n.content.templates-error-read', 'error');
          }
        });
      },

      downloadTemplate: function downloadTemplate() {
        this.sendAction('onDownloadTemplate', this.get('saveTitle').string);
        this.set('showSaveDialog', false);
      },

      saveTemplateToLibrary: function saveTemplateToLibrary() {
        var _this4 = this;

        this.get('ui').confirm({
          message: this.get('i18n').t('content.templates-save-message'),
          accept: function accept() {
            _this4.sendAction('onSaveToLibrary', _this4.get('saveTitle'), 'page');
            _this4.set('showSaveDialog', false);
          },
          decline: function decline() {
            _this4.sendAction('onSaveToLibrary', _this4.get('saveTitle'), 'block');
            _this4.set('showSaveDialog', false);
          },
          acceptBtn: this.get('i18n').t('content.templates-save-yep'),
          declineBtn: this.get('i18n').t('content.templates-save-nope'),
          noSkip: true,
          acceptClass: 'sad'
        });
      },

      deleteUserTemplate: function deleteUserTemplate() {
        var _this5 = this;

        this.get('ui').confirm({
          message: this.get('i18n').t('content.templates-remove-message'),
          accept: function accept() {
            _this5.sendAction('onDeleteUserTemplate', _this5.getWithDefault('selectedDeleteableItem', _this5.get('deletableItemOptions.firstObject.value')));
          },
          acceptClass: 'sad'
        });
      }
    }

  });
});
define("cornerstone/components/content/workspace-layout/panel-templates/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 4
              },
              "end": {
                "line": 3,
                "column": 88
              }
            },
            "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("◀");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 6,
                "column": 12
              },
              "end": {
                "line": 6,
                "column": 72
              }
            },
            "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["inline", "t", ["app.layout.title"], [], ["loc", [null, [6, 12], [6, 72]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 11,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "cs-workspace-section-nav");
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "cs-workspace-section-nav-info");
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("ul");
          dom.setAttribute(el3, "class", "cs-workspace-section-nav-info-breadcrumbs");
          var el4 = dom.createTextNode("\n        ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("li");
          var el5 = dom.createComment("");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n      ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("h3");
          dom.setAttribute(el3, "class", "cs-workspace-section-nav-info-title");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n    ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element10 = dom.childAt(fragment, [1]);
          var element11 = dom.childAt(element10, [3]);
          var morphs = new Array(3);
          morphs[0] = dom.createMorphAt(element10, 1, 1);
          morphs[1] = dom.createMorphAt(dom.childAt(element11, [1, 1]), 0, 0);
          morphs[2] = dom.createMorphAt(dom.childAt(element11, [3]), 0, 0);
          return morphs;
        },
        statements: [["block", "link-to", ["content.builder.layout"], ["class", "cs-workspace-section-nav-back"], 0, null, ["loc", [null, [3, 4], [3, 100]]]], ["block", "link-to", ["content.builder.layout"], [], 1, null, ["loc", [null, [6, 12], [6, 72]]]], ["inline", "t", ["content.layout-templates"], [], ["loc", [null, [8, 54], [8, 86]]], 0, 0]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 42,
                      "column": 12
                    },
                    "end": {
                      "line": 48,
                      "column": 12
                    }
                  },
                  "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("              ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n              ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("button");
                  var el2 = dom.createTextNode("Insert");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element4 = dom.childAt(fragment, [3]);
                  var morphs = new Array(3);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  morphs[1] = dom.createAttrMorph(element4, 'class');
                  morphs[2] = dom.createElementMorph(element4);
                  return morphs;
                },
                statements: [["inline", "forms/styled-select", [], ["options", ["subexpr", "@mut", [["get", "themecoPageOptions", ["loc", [null, [44, 24], [44, 42]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "selectedThemecoPage", ["loc", [null, [45, 22], [45, 41]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [43, 14], [46, 16]]], 0, 0], ["attribute", "class", ["concat", ["cs-control-select-action-btn cs-control-classic-template-selection-insert ", ["subexpr", "if", [["get", "ui.deleteConfirm", ["loc", [null, [47, 108], [47, 124]]], 0, 0, 0, 0], "cs-danger"], [], ["loc", [null, [47, 103], [47, 138]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["addThemecoPage"], ["allowedKeys", "shift"], ["loc", [null, [47, 140], [47, 187]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 41,
                    "column": 10
                  },
                  "end": {
                    "line": 49,
                    "column": 10
                  }
                },
                "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], ["label", "Themeco<br>Pages"], 0, null, ["loc", [null, [42, 12], [48, 41]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child1 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 51,
                      "column": 12
                    },
                    "end": {
                      "line": 57,
                      "column": 12
                    }
                  },
                  "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("              ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n              ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("button");
                  var el2 = dom.createTextNode("Insert");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element3 = dom.childAt(fragment, [3]);
                  var morphs = new Array(3);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  morphs[1] = dom.createAttrMorph(element3, 'class');
                  morphs[2] = dom.createElementMorph(element3);
                  return morphs;
                },
                statements: [["inline", "forms/styled-select", [], ["options", ["subexpr", "@mut", [["get", "themecoBlockOptions", ["loc", [null, [53, 24], [53, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "selectedThemecoBlock", ["loc", [null, [54, 22], [54, 42]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [52, 14], [55, 16]]], 0, 0], ["attribute", "class", ["concat", ["cs-control-select-action-btn cs-control-classic-template-selection-insert ", ["subexpr", "if", [["get", "ui.deleteConfirm", ["loc", [null, [56, 108], [56, 124]]], 0, 0, 0, 0], "cs-danger"], [], ["loc", [null, [56, 103], [56, 138]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["addThemecoBlock"], ["allowedKeys", "shift"], ["loc", [null, [56, 140], [56, 188]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 50,
                    "column": 10
                  },
                  "end": {
                    "line": 58,
                    "column": 10
                  }
                },
                "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], ["label", "Themeco<br>Blocks"], 0, null, ["loc", [null, [51, 12], [57, 41]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child2 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 60,
                      "column": 12
                    },
                    "end": {
                      "line": 66,
                      "column": 12
                    }
                  },
                  "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("              ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n              ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("button");
                  var el2 = dom.createTextNode("Insert");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element2 = dom.childAt(fragment, [3]);
                  var morphs = new Array(3);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  morphs[1] = dom.createAttrMorph(element2, 'class');
                  morphs[2] = dom.createElementMorph(element2);
                  return morphs;
                },
                statements: [["inline", "forms/styled-select", [], ["options", ["subexpr", "@mut", [["get", "userPageOptions", ["loc", [null, [62, 24], [62, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "selectedUserPage", ["loc", [null, [63, 22], [63, 38]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [61, 14], [64, 16]]], 0, 0], ["attribute", "class", ["concat", ["cs-control-select-action-btn cs-control-classic-template-selection-insert ", ["subexpr", "if", [["get", "ui.deleteConfirm", ["loc", [null, [65, 108], [65, 124]]], 0, 0, 0, 0], "cs-danger"], [], ["loc", [null, [65, 103], [65, 138]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["addUserPage"], ["allowedKeys", "shift"], ["loc", [null, [65, 140], [65, 184]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 59,
                    "column": 10
                  },
                  "end": {
                    "line": 67,
                    "column": 10
                  }
                },
                "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], ["label", "My<br>Pages"], 0, null, ["loc", [null, [60, 12], [66, 41]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child3 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 69,
                      "column": 12
                    },
                    "end": {
                      "line": 75,
                      "column": 12
                    }
                  },
                  "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("              ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n              ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("button");
                  var el2 = dom.createTextNode("Insert");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element1 = dom.childAt(fragment, [3]);
                  var morphs = new Array(3);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  morphs[1] = dom.createAttrMorph(element1, 'class');
                  morphs[2] = dom.createElementMorph(element1);
                  return morphs;
                },
                statements: [["inline", "forms/styled-select", [], ["options", ["subexpr", "@mut", [["get", "userBlockOptions", ["loc", [null, [71, 24], [71, 40]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "selectedUserBlock", ["loc", [null, [72, 22], [72, 39]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [70, 14], [73, 16]]], 0, 0], ["attribute", "class", ["concat", ["cs-control-select-action-btn cs-control-classic-template-selection-insert ", ["subexpr", "if", [["get", "ui.deleteConfirm", ["loc", [null, [74, 108], [74, 124]]], 0, 0, 0, 0], "cs-danger"], [], ["loc", [null, [74, 103], [74, 138]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["addUserBlock"], ["allowedKeys", "shift"], ["loc", [null, [74, 140], [74, 185]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 68,
                    "column": 10
                  },
                  "end": {
                    "line": 76,
                    "column": 10
                  }
                },
                "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], ["label", "My<br>Blocks"], 0, null, ["loc", [null, [69, 12], [75, 41]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child4 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 78,
                      "column": 12
                    },
                    "end": {
                      "line": 84,
                      "column": 12
                    }
                  },
                  "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("              ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n              ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("button");
                  var el2 = dom.createTextNode("Delete");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element0 = dom.childAt(fragment, [3]);
                  var morphs = new Array(3);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  morphs[1] = dom.createAttrMorph(element0, 'class');
                  morphs[2] = dom.createElementMorph(element0);
                  return morphs;
                },
                statements: [["inline", "forms/styled-select", [], ["options", ["subexpr", "@mut", [["get", "deletableItemOptions", ["loc", [null, [80, 24], [80, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "selectedDeleteableItem", ["loc", [null, [81, 22], [81, 44]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [79, 14], [82, 16]]], 0, 0], ["attribute", "class", ["concat", ["cs-control-select-action-btn cs-control-classic-template-selection-delete ", ["subexpr", "if", [["get", "ui.deleteConfirm", ["loc", [null, [83, 108], [83, 124]]], 0, 0, 0, 0], "cs-danger"], [], ["loc", [null, [83, 103], [83, 138]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["deleteUserTemplate"], ["allowedKeys", "shift"], ["loc", [null, [83, 140], [83, 191]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 77,
                    "column": 10
                  },
                  "end": {
                    "line": 85,
                    "column": 10
                  }
                },
                "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], ["label", "Remove<br>Templates"], 0, null, ["loc", [null, [78, 12], [84, 41]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 40,
                  "column": 8
                },
                "end": {
                  "line": 86,
                  "column": 8
                }
              },
              "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(5);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              morphs[2] = dom.createMorphAt(fragment, 2, 2, contextualElement);
              morphs[3] = dom.createMorphAt(fragment, 3, 3, contextualElement);
              morphs[4] = dom.createMorphAt(fragment, 4, 4, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "if", [["get", "themecoPageOptions", ["loc", [null, [41, 16], [41, 34]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [41, 10], [49, 17]]]], ["block", "if", [["get", "themecoBlockOptions", ["loc", [null, [50, 16], [50, 35]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [50, 10], [58, 17]]]], ["block", "if", [["get", "userPageOptions", ["loc", [null, [59, 16], [59, 31]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [59, 10], [67, 17]]]], ["block", "if", [["get", "userBlockOptions", ["loc", [null, [68, 16], [68, 32]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [68, 10], [76, 17]]]], ["block", "if", [["get", "deletableItemOptions", ["loc", [null, [77, 16], [77, 36]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [77, 10], [85, 17]]]]],
            locals: [],
            templates: [child0, child1, child2, child3, child4]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 37,
                "column": 2
              },
              "end": {
                "line": 89,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "cs-control cs-control-select-action cs-control-classic-template-selection");
            var el2 = dom.createTextNode("\n      ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("div");
            dom.setAttribute(el2, "class", "cs-control-input");
            var el3 = dom.createTextNode("\n");
            dom.appendChild(el2, el3);
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("      ");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n    ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1]), 1, 1);
            return morphs;
          },
          statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [40, 8], [86, 32]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 12,
              "column": 0
            },
            "end": {
              "line": 93,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("button");
          dom.setAttribute(el2, "class", "close");
          var el3 = dom.createTextNode("×");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("input");
          dom.setAttribute(el2, "id", "template-upload");
          dom.setAttribute(el2, "type", "file");
          dom.setAttribute(el2, "name", "blockUpload");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("button");
          dom.setAttribute(el2, "class", "process");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("button");
          dom.setAttribute(el2, "class", "close");
          var el3 = dom.createTextNode("×");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element5 = dom.childAt(fragment, [3]);
          var element6 = dom.childAt(element5, [5]);
          var element7 = dom.childAt(fragment, [5]);
          var element8 = dom.childAt(element7, [3]);
          var element9 = dom.childAt(element7, [5]);
          var morphs = new Array(10);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createAttrMorph(element5, 'class');
          morphs[2] = dom.createMorphAt(element5, 1, 1);
          morphs[3] = dom.createMorphAt(element5, 3, 3);
          morphs[4] = dom.createElementMorph(element6);
          morphs[5] = dom.createAttrMorph(element7, 'class');
          morphs[6] = dom.createElementMorph(element8);
          morphs[7] = dom.createMorphAt(element8, 0, 0);
          morphs[8] = dom.createElementMorph(element9);
          morphs[9] = dom.createMorphAt(fragment, 7, 7, contextualElement);
          return morphs;
        },
        statements: [["inline", "workspace/workspace-actions", [], ["items", ["subexpr", "array", [["subexpr", "hash", [], ["label", "Save", "content", ["subexpr", "icon", ["save"], [], ["loc", [null, [15, 33], [15, 46]]], 0, 0], "action", ["subexpr", "action", ["openSaveDialog"], [], ["loc", [null, [15, 54], [15, 79]]], 0, 0]], ["loc", [null, [15, 6], [15, 81]]], 0, 0], ["subexpr", "hash", [], ["label", "Upload", "content", ["subexpr", "icon", ["upload"], [], ["loc", [null, [16, 35], [16, 50]]], 0, 0], "action", ["subexpr", "action", ["openUploadDialog"], [], ["loc", [null, [16, 58], [16, 85]]], 0, 0]], ["loc", [null, [16, 6], [16, 87]]], 0, 0]], [], ["loc", [null, [14, 10], [17, 5]]], 0, 0]], ["loc", [null, [13, 2], [18, 4]]], 0, 0], ["attribute", "class", ["concat", ["cs-control-template-save-dialog ", ["subexpr", "unless", [["get", "showSaveDialog", ["loc", [null, [20, 55], [20, 69]]], 0, 0, 0, 0], "cs-inactive", ""], [], ["loc", [null, [20, 46], [20, 88]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["inline", "content/cs-title", [], ["title", ["subexpr", "@mut", [["get", "saveTitle", ["loc", [null, [21, 29], [21, 38]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [21, 4], [21, 40]]], 0, 0], ["inline", "workspace/workspace-actions", [], ["items", ["subexpr", "array", [["subexpr", "hash", [], ["label", ["subexpr", "t", ["content.templates-download"], [], ["loc", [null, [24, 20], [24, 52]]], 0, 0], "content", ["subexpr", "icon", ["download"], [], ["loc", [null, [24, 61], [24, 78]]], 0, 0], "action", ["subexpr", "action", ["downloadTemplate"], [], ["loc", [null, [24, 86], [24, 113]]], 0, 0]], ["loc", [null, [24, 8], [24, 115]]], 0, 0], ["subexpr", "hash", [], ["label", ["subexpr", "t", ["content.templates-save-library"], [], ["loc", [null, [25, 20], [25, 56]]], 0, 0], "content", ["subexpr", "icon", ["book"], [], ["loc", [null, [25, 65], [25, 78]]], 0, 0], "action", ["subexpr", "action", ["saveTemplateToLibrary"], [], ["loc", [null, [25, 86], [25, 118]]], 0, 0]], ["loc", [null, [25, 8], [25, 120]]], 0, 0]], [], ["loc", [null, [23, 12], [26, 7]]], 0, 0]], ["loc", [null, [22, 4], [27, 6]]], 0, 0], ["element", "action", ["closeSaveDialog"], [], ["loc", [null, [28, 12], [28, 40]]], 0, 0], ["attribute", "class", ["concat", ["cs-control-template-upload-dialog ", ["subexpr", "unless", [["get", "showUploadDialog", ["loc", [null, [31, 57], [31, 73]]], 0, 0, 0, 0], "cs-inactive", ""], [], ["loc", [null, [31, 48], [31, 92]]], 0, 0], " "], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["uploadTemplate"], [], ["loc", [null, [33, 12], [33, 40]]], 0, 0], ["inline", "t", ["content.templates-upload-button"], [], ["loc", [null, [33, 57], [33, 96]]], 0, 0], ["element", "action", ["closeUploadDialog"], [], ["loc", [null, [34, 12], [34, 42]]], 0, 0], ["block", "if", [["get", "hasEntries", ["loc", [null, [37, 8], [37, 18]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [37, 2], [89, 9]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 95,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/workspace-layout/panel-templates/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "workspace/workspace-header", [], [], 0, null, ["loc", [null, [1, 0], [11, 31]]]], ["block", "workspace/workspace-content", [], ["name", "content-layout-templates"], 1, null, ["loc", [null, [12, 0], [93, 32]]]], ["content", "yield", ["loc", [null, [94, 0], [94, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define("cornerstone/components/content/workspace-layout/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 15,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/workspace-layout/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          return morphs;
        },
        statements: [["inline", "workspace/workspace-nav", [], ["items", ["subexpr", "array", [["subexpr", "hash", [], ["route", "content.builder.layout", "label", ["subexpr", "t", ["app.layout.title"], [], ["loc", [null, [4, 49], [4, 71]]], 0, 0], "class", "layout"], ["loc", [null, [4, 6], [4, 87]]], 0, 0], ["subexpr", "hash", [], ["route", "content.builder.elements", "label", ["subexpr", "t", ["app.elements.title"], [], ["loc", [null, [5, 51], [5, 75]]], 0, 0], "class", "elements"], ["loc", [null, [5, 6], [5, 93]]], 0, 0], ["subexpr", "hash", [], ["route", "content.builder.inspector", "label", ["subexpr", "t", ["app.inspector.title"], [], ["loc", [null, [6, 52], [6, 77]]], 0, 0], "class", "inspector"], ["loc", [null, [6, 6], [6, 96]]], 0, 0]], [], ["loc", [null, [3, 10], [7, 5]]], 0, 0]], ["loc", [null, [2, 2], [8, 4]]], 0, 0], ["inline", "workspace/workspace-actions", [], ["items", ["subexpr", "array", [["subexpr", "hash", [], ["label", ["subexpr", "t", ["content.layout-add-section"], [], ["loc", [null, [11, 18], [11, 50]]], 0, 0], "content", ["subexpr", "icon", ["plus-square"], [], ["loc", [null, [11, 59], [11, 79]]], 0, 0], "action", ["subexpr", "action", ["addFirstSection"], [], ["loc", [null, [11, 87], [11, 114]]], 0, 0]], ["loc", [null, [11, 6], [11, 116]]], 0, 0], ["subexpr", "hash", [], ["label", ["subexpr", "t", ["content.layout-templates"], [], ["loc", [null, [12, 18], [12, 48]]], 0, 0], "content", ["subexpr", "icon", ["file"], [], ["loc", [null, [12, 57], [12, 70]]], 0, 0], "action", ["subexpr", "route-action", ["navigate", "content.builder.layout.templates"], [], ["loc", [null, [12, 78], [12, 138]]], 0, 0]], ["loc", [null, [12, 6], [12, 140]]], 0, 0]], [], ["loc", [null, [10, 10], [13, 5]]], 0, 0]], ["loc", [null, [9, 2], [14, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 18,
                "column": 2
              },
              "end": {
                "line": 23,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/workspace-layout/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "common/help-text", [], ["title", ["subexpr", "t", ["content.layout-info-title"], [], ["loc", [null, [20, 12], [20, 43]]], 0, 0], "message", ["subexpr", "t", ["content.layout-info-description"], [], ["loc", [null, [21, 14], [21, 51]]], 0, 0]], ["loc", [null, [19, 4], [22, 6]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 29,
                      "column": 10
                    },
                    "end": {
                      "line": 56,
                      "column": 10
                    }
                  },
                  "moduleName": "cornerstone/components/content/workspace-layout/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "content/manage-section", [], ["active", ["subexpr", "eq", [["get", "section.id", ["loc", [null, [48, 23], [48, 33]]], 0, 0, 0, 0], ["get", "selectedSection.id", ["loc", [null, [48, 34], [48, 52]]], 0, 0, 0, 0]], [], ["loc", [null, [48, 19], [48, 53]]], 0, 0], "section", ["subexpr", "@mut", [["get", "section", ["loc", [null, [49, 20], [49, 27]]], 0, 0, 0, 0]], [], [], 0, 0], "selectedRowId", ["subexpr", "if", [["subexpr", "eq", [["get", "section.id", ["loc", [null, [50, 34], [50, 44]]], 0, 0, 0, 0], ["get", "selectedSection.id", ["loc", [null, [50, 45], [50, 63]]], 0, 0, 0, 0]], [], ["loc", [null, [50, 30], [50, 64]]], 0, 0], ["get", "selectedRowId", ["loc", [null, [50, 65], [50, 78]]], 0, 0, 0, 0], false], [], ["loc", [null, [50, 26], [50, 85]]], 0, 0], "onSelectRow", ["subexpr", "action", ["selectRow"], [], ["loc", [null, [51, 24], [51, 44]]], 0, 0], "onAddFirstRow", ["subexpr", "action", ["addFirstRow", ["get", "section", ["loc", [null, [52, 48], [52, 55]]], 0, 0, 0, 0]], [], ["loc", [null, [52, 26], [52, 56]]], 0, 0]], ["loc", [null, [47, 10], [53, 12]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 28,
                    "column": 8
                  },
                  "end": {
                    "line": 57,
                    "column": 8
                  }
                },
                "moduleName": "cornerstone/components/content/workspace-layout/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "common/sortable-item", [], ["label", ["subexpr", "@mut", [["get", "section.indexedTitle", ["loc", [null, [30, 18], [30, 38]]], 0, 0, 0, 0]], [], [], 0, 0], "labelOrdered", ["subexpr", "concat", [["get", "section.order", ["loc", [null, [31, 33], [31, 46]]], 0, 0, 0, 0], ["get", "section.indexedTitle", ["loc", [null, [31, 47], [31, 67]]], 0, 0, 0, 0]], [], ["loc", [null, [31, 25], [31, 68]]], 0, 0], "item", ["subexpr", "@mut", [["get", "section", ["loc", [null, [32, 17], [32, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "active", ["subexpr", "eq", [["get", "section.id", ["loc", [null, [33, 23], [33, 33]]], 0, 0, 0, 0], ["get", "selectedSection.id", ["loc", [null, [33, 34], [33, 52]]], 0, 0, 0, 0]], [], ["loc", [null, [33, 19], [33, 53]]], 0, 0], "showAddAfter", ["subexpr", "eq", [["get", "section.id", ["loc", [null, [34, 29], [34, 39]]], 0, 0, 0, 0], ["get", "sortedSections.lastObject.id", ["loc", [null, [34, 40], [34, 68]]], 0, 0, 0, 0]], [], ["loc", [null, [34, 25], [34, 69]]], 0, 0], "addLabel", ["subexpr", "if", [["get", "ui.modKey", ["loc", [null, [35, 25], [35, 34]]], 0, 0, 0, 0], "Add Classic Section", "Add Section"], [], ["loc", [null, [35, 21], [35, 71]]], 0, 0], "onSelect", ["subexpr", "action", ["selectSection", ["get", "section", ["loc", [null, [36, 45], [36, 52]]], 0, 0, 0, 0]], [], ["loc", [null, [36, 21], [36, 53]]], 0, 0], "onInspect", ["subexpr", "route-action", ["inspectElement", ["get", "section", ["loc", [null, [37, 53], [37, 60]]], 0, 0, 0, 0]], [], ["loc", [null, [37, 22], [37, 62]]], 0, 0], "onDrop", ["subexpr", "route-action", ["moveElement"], [], ["loc", [null, [38, 19], [38, 48]]], 0, 0], "onAddBefore", ["subexpr", "route-action", ["addSiblingElement", ["get", "section", ["loc", [null, [39, 58], [39, 65]]], 0, 0, 0, 0], ["subexpr", "hash", [], ["_type", ["subexpr", "if", [["get", "ui.modKey", ["loc", [null, [39, 82], [39, 91]]], 0, 0, 0, 0], "classic:section", "section"], [], ["loc", [null, [39, 78], [39, 120]]], 0, 0]], ["loc", [null, [39, 66], [39, 122]]], 0, 0], false], [], ["loc", [null, [39, 24], [39, 129]]], 0, 0], "onAddAfter", ["subexpr", "route-action", ["addSiblingElement", ["get", "section", ["loc", [null, [40, 57], [40, 64]]], 0, 0, 0, 0], ["subexpr", "hash", [], ["_type", ["subexpr", "if", [["get", "ui.modKey", ["loc", [null, [40, 81], [40, 90]]], 0, 0, 0, 0], "classic:section", "section"], [], ["loc", [null, [40, 77], [40, 119]]], 0, 0]], ["loc", [null, [40, 65], [40, 121]]], 0, 0], true], [], ["loc", [null, [40, 23], [40, 127]]], 0, 0], "onDuplicate", ["subexpr", "route-action", ["duplicateElement", ["get", "section", ["loc", [null, [41, 57], [41, 64]]], 0, 0, 0, 0]], [], ["loc", [null, [41, 24], [41, 65]]], 0, 0], "onDelete", ["subexpr", "route-action", ["deleteElement", ["get", "section", ["loc", [null, [42, 51], [42, 58]]], 0, 0, 0, 0]], [], ["loc", [null, [42, 21], [42, 59]]], 0, 0], "onMouseEnter", ["subexpr", "route-action", ["observeStart", ["get", "section", ["loc", [null, [43, 54], [43, 61]]], 0, 0, 0, 0]], [], ["loc", [null, [43, 25], [43, 62]]], 0, 0], "onMouseLeave", ["subexpr", "route-action", ["observeEnd", ["get", "section", ["loc", [null, [44, 52], [44, 59]]], 0, 0, 0, 0]], [], ["loc", [null, [44, 25], [44, 60]]], 0, 0], "hasDrawer", true], 0, null, ["loc", [null, [29, 10], [56, 35]]]]],
              locals: ["section"],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 27,
                  "column": 6
                },
                "end": {
                  "line": 58,
                  "column": 6
                }
              },
              "moduleName": "cornerstone/components/content/workspace-layout/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "each", [["get", "sortedSections", ["loc", [null, [28, 16], [28, 30]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [28, 8], [57, 17]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 25,
                "column": 2
              },
              "end": {
                "line": 60,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/workspace-layout/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "cs-workspace-content-section cs-workspace-content-section-shrink-top cs-workspace-content-section-shrink-bottom");
            var el2 = dom.createTextNode("\n");
            dom.appendChild(el1, el2);
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("    ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
            return morphs;
          },
          statements: [["block", "common/sortable-container", [], [], 0, null, ["loc", [null, [27, 6], [58, 36]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      var child2 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 60,
                "column": 2
              },
              "end": {
                "line": 66,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/content/workspace-layout/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "workspace/workspace-full-button", [], ["action", ["subexpr", "action", ["addFirstSection"], [], ["loc", [null, [62, 13], [62, 39]]], 0, 0], "icon", ["subexpr", "icon", ["plus-square"], [], ["loc", [null, [63, 11], [63, 31]]], 0, 0], "message", "Add a section to get started."], ["loc", [null, [61, 4], [65, 6]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 16,
              "column": 0
            },
            "end": {
              "line": 68,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/content/workspace-layout/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          return morphs;
        },
        statements: [["block", "if", [["get", "ui.showHelpText", ["loc", [null, [18, 8], [18, 23]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [18, 2], [23, 9]]]], ["block", "if", [["get", "sortedSections", ["loc", [null, [25, 8], [25, 22]]], 0, 0, 0, 0]], [], 1, 2, ["loc", [null, [25, 2], [66, 9]]]]],
        locals: [],
        templates: [child0, child1, child2]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 70,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/content/workspace-layout/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["block", "workspace/workspace-header", [], [], 0, null, ["loc", [null, [1, 0], [15, 31]]]], ["block", "workspace/workspace-content", [], ["name", "content-inspector"], 1, null, ["loc", [null, [16, 0], [68, 32]]]], ["content", "yield", ["loc", [null, [69, 0], [69, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/controls/control-aspect-ratio/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {
    classNameBindings: ['monospace:cs-monospace-input']
  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-aspect-ratio/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 8,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-aspect-ratio/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/aspect-ratio-input", [], ["width", ["subexpr", "@mut", [["get", "control.keyWidth", ["loc", [null, [4, 10], [4, 26]]], 0, 0, 0, 0]], [], [], 0, 0], "height", ["subexpr", "@mut", [["get", "control.keyHeight", ["loc", [null, [5, 11], [5, 28]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [6, 16], [6, 27]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [7, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-aspect-ratio/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [8, 22]]]], ["content", "yield", ["loc", [null, [9, 0], [9, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-base/component', ['exports', 'ember', 'cornerstone/util/merge-options'], function (exports, _ember, _cornerstoneUtilMergeOptions) {

  var ControlBase = _ember['default'].Component.extend({

    level: 1,
    firstLevel: _ember['default'].computed.equal('level', 1),
    deeplyNested: _ember['default'].computed.gt('level', 2),

    headerTemplate: _ember['default'].computed('level', function () {
      return this.get('firstLevel') ? 'partials/controls/control-header' : 'partials/controls/input-list-item-header';
    }),

    classNameBindings: ['baseClasses', 'isHidden:cs-hide', 'class'],
    attributeBindings: ['groupName:data-cs-control-group-name', 'control.id:data-cs-control-id'],
    groupName: _ember['default'].computed.alias('control.group'),

    containerClass: _ember['default'].computed(function () {

      var classes = [];

      if (!this.get('firstLevel')) {

        classes.push('cs-control-input-list-input');
        // classes.push( `cs-control-input-list-input-${this.get('level')}`);

        var height = undefined;
        var defaultHeight = this.get('defaultHeight');
        var mappedHeight = this.get('control.options.height');

        if (_ember['default'].isPresent(defaultHeight)) {
          height = defaultHeight;
        }

        if (_ember['default'].isPresent(mappedHeight)) {
          height = mappedHeight;
        }

        if (_ember['default'].isPresent(height)) {
          classes.push('cs-control-input-list-input-height-' + height);
        }
      } else {
        classes.push('cs-control-input');
      }

      return classes.join(' ');
    }),

    // Todo: Stop using these aliases since we're moving into control aggregates which have variable keys

    options: _ember['default'].computed.alias('control.options'),
    value: _ember['default'].computed.alias('control.keyValue'),

    service: _ember['default'].inject.service('controls'),

    baseClasses: _ember['default'].computed('control.type', 'control.originalType', function () {

      var levelClass = this.get('firstLevel') ? 'cs-control' : 'cs-control-input-list-item';
      var type = this.get('control.type');
      var output = levelClass + ' ' + levelClass + '-' + type;

      var originalType = this.get('control.originalType');
      if (_ember['default'].isPresent(originalType)) {
        originalType = originalType.replace('/', '-');
        output += ' ' + levelClass + '-' + type + '-' + originalType;
      }

      return output;
    }),

    isHidden: _ember['default'].computed('hidden', 'control.excluded', function () {
      return this.get('hidden') || this.get('control.excluded');
    }),

    showHeader: _ember['default'].computed('control.label', function () {
      return _ember['default'].isPresent(this.get('control.label'));
    }),

    label: _ember['default'].computed('control.label', function () {
      var label = this.get('control.label');
      return _ember['default'].isPresent(label) ? label : '&nbsp;';
    })

  });

  ControlBase.isKeyMapped = function (key) {
    return _ember['default'].computed(function () {
      return _ember['default'].isPresent(this.get('control.keys.' + key));
    });
  };

  ControlBase.subOptions = function (key, defaults, transform) {
    var optionPath = 'control.options.' + key;
    return _ember['default'].computed(optionPath, function () {
      var options = (0, _cornerstoneUtilMergeOptions['default'])(_ember['default'].isNone(defaults) ? {} : _ember['default'].copy(defaults, true), this.getWithDefault(optionPath, {}));
      if ('function' === typeof transform) {
        options = transform.call(this, options);
      }
      return options;
    });
  };

  exports['default'] = ControlBase;
});
define("cornerstone/components/controls/control-base/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-base/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment(" Undefined Control ");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-base/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-border/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  var sides = ['top', 'right', 'bottom', 'left'];

  function linkedKey(prop, fallback) {
    return _ember['default'].computed(prop, 'activeSide', {
      get: function get() {
        return valueForSide(this.getWithDefault(prop, ''), this.get('activeSide'), fallback);
      },
      set: function set(key, value) {

        value = value.replace(/\ /g, '');

        if (this.get('linked')) {
          this.set(prop, value);
        } else {
          var update = {};
          update[this.get('activeSide')] = value;
          this.set(prop, unlinkedValue(this.getWithDefault(prop, ''), fallback, update));
        }

        return value;
      }
    });
  }

  function valueForSide(combined, side, fallback) {
    var index = sides.indexOf(side);

    var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(combined);
    return _ember['default'].isNone(parts[index]) ? fallback : parts[index];
  }

  function unlinkedValue(combined, fallback, update) {

    var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(combined);
    var updated = [];

    if (1 === parts.length) {
      parts[1] = parts[0];
      parts[2] = parts[0];
      parts[3] = parts[0];
    }

    sides.forEach(function (item, index) {

      if (_ember['default'].isNone(parts[index])) {
        parts[index] = fallback;
      }

      updated.push(parts[index]);
    });

    if (update) {
      for (var side in update) {
        var index = sides.indexOf(side);
        if (-1 !== index) {
          updated[index] = update[side];
        }
      }
    }

    return updated.join(' ');
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    showColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('color'),
    showAltColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt_color'),

    init: function init() {
      this._super.apply(this, arguments);
      if (this.get('options.always_linked')) {
        this.set('alwaysLinked', true);
        this.set('linked', true);
      } else {
        this.set('linked', (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('control.keyStyle', '')).length <= 1);
      }
    },

    linkedObserver: _ember['default'].observer('linked', function () {

      var activeStyle = this.get('activeStyle');
      this.set('activeStyle', activeStyle);
      this.set('activeWidth', this.get('activeWidth'));

      if (this.get('showColor')) {
        this.set('activeColor', this.get('activeColor'));
      }

      if (this.get('showAltColor')) {
        this.set('activeAltColor', this.get('activeAltColor'));
      }
    }),

    activeSide: _ember['default'].computed({
      get: function get() {
        return 'top';
      },
      set: function set(key, value) {
        return value;
      }
    }),

    activeStyle: linkedKey('control.keyStyle', 'none'),
    activeWidth: linkedKey('control.keyWidth', '0px'),
    activeColor: linkedKey('control.keyColor', 'transparent'),
    activeAltColor: linkedKey('control.keyAltColor', 'transparent'),

    widthOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('width', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: 0, max: 25, step: 1 },
        em: { min: 0, max: 2.5, step: 0.001 },
        rem: { min: 0, max: 2.5, step: 0.001 }
      }
    }),

    colorOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('color'),
    altColorOptions: _ember['default'].computed('colorOptions', function () {
      var options = _ember['default'].copy(this.get('colorOptions'));
      if (options.alt_label) {
        options.label = options.alt_label;
      }
      return options;
    })

  });
});
define("cornerstone/components/controls/control-border/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 6,
                    "column": 6
                  },
                  "end": {
                    "line": 9,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-border/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [7, 37], [7, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", false, "icon", "unlink", "tooltip", "Unlinked"], ["loc", [null, [7, 8], [7, 90]]], 0, 0], ["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [8, 37], [8, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", true, "icon", "link", "tooltip", "Linked"], ["loc", [null, [8, 8], [8, 85]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 10,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-border/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "forms/choose-single", [], ["value", ["subexpr", "@mut", [["get", "linked", ["loc", [null, [6, 35], [6, 41]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [6, 6], [9, 30]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 13,
                    "column": 6
                  },
                  "end": {
                    "line": 18,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-border/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(4);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
                morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["class", "cs-choice-top", "choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [14, 59], [14, 65]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "top", "tooltip", "Top"], ["loc", [null, [14, 8], [14, 93]]], 0, 0], ["inline", "forms/choose-choice", [], ["class", "cs-choice-right", "choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [15, 61], [15, 67]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "right", "tooltip", "Right"], ["loc", [null, [15, 8], [15, 99]]], 0, 0], ["inline", "forms/choose-choice", [], ["class", "cs-choice-bottom", "choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [16, 62], [16, 68]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "bottom", "tooltip", "Bottom"], ["loc", [null, [16, 8], [16, 102]]], 0, 0], ["inline", "forms/choose-choice", [], ["class", "cs-choice-left", "choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [17, 60], [17, 66]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "left", "tooltip", "Left"], ["loc", [null, [17, 8], [17, 96]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 12,
                  "column": 4
                },
                "end": {
                  "line": 19,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-border/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "forms/choose-single", [], ["value", ["subexpr", "@mut", [["get", "activeSide", ["loc", [null, [13, 35], [13, 45]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [13, 6], [18, 30]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 21,
                  "column": 4
                },
                "end": {
                  "line": 36,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-border/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "activeStyle", ["loc", [null, [23, 14], [23, 25]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "array", [["subexpr", "hash", [], ["value", "none", "label", "None"], ["loc", [null, [25, 10], [25, 42]]], 0, 0], ["subexpr", "hash", [], ["value", "solid", "label", "Solid"], ["loc", [null, [26, 10], [26, 44]]], 0, 0], ["subexpr", "hash", [], ["value", "dotted", "label", "Dotted"], ["loc", [null, [27, 10], [27, 46]]], 0, 0], ["subexpr", "hash", [], ["value", "dashed", "label", "Dashed"], ["loc", [null, [28, 10], [28, 46]]], 0, 0], ["subexpr", "hash", [], ["value", "double", "label", "Double"], ["loc", [null, [29, 10], [29, 46]]], 0, 0], ["subexpr", "hash", [], ["value", "groove", "label", "Groove"], ["loc", [null, [30, 10], [30, 46]]], 0, 0], ["subexpr", "hash", [], ["value", "ridge", "label", "Ridge"], ["loc", [null, [31, 10], [31, 44]]], 0, 0], ["subexpr", "hash", [], ["value", "inset", "label", "Inset"], ["loc", [null, [32, 10], [32, 44]]], 0, 0], ["subexpr", "hash", [], ["value", "outset", "label", "Outset"], ["loc", [null, [33, 10], [33, 46]]], 0, 0]], [], ["loc", [null, [24, 16], [34, 9]]], 0, 0]], ["loc", [null, [22, 6], [35, 8]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 39,
                    "column": 6
                  },
                  "end": {
                    "line": 41,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-border/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "activeWidth", ["loc", [null, [40, 34], [40, 45]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "widthOptions", ["loc", [null, [40, 54], [40, 66]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [40, 8], [40, 68]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child1 = (function () {
            var child0 = (function () {
              var child0 = (function () {
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 46,
                        "column": 10
                      },
                      "end": {
                        "line": 48,
                        "column": 10
                      }
                    },
                    "moduleName": "cornerstone/components/controls/control-border/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createTextNode("            ");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createComment("");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createTextNode("\n");
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                    return morphs;
                  },
                  statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "activeAltColor", ["loc", [null, [47, 39], [47, 53]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "altColorOptions", ["loc", [null, [47, 62], [47, 77]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [47, 12], [47, 79]]], 0, 0]],
                  locals: [],
                  templates: []
                };
              })();
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 44,
                      "column": 8
                    },
                    "end": {
                      "line": 49,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-border/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(2);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                  dom.insertBoundary(fragment, null);
                  return morphs;
                },
                statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "activeColor", ["loc", [null, [45, 37], [45, 48]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "colorOptions", ["loc", [null, [45, 57], [45, 69]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [45, 10], [45, 71]]], 0, 0], ["block", "if", [["get", "showAltColor", ["loc", [null, [46, 16], [46, 28]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [46, 10], [48, 17]]]]],
                locals: [],
                templates: [child0]
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 43,
                    "column": 6
                  },
                  "end": {
                    "line": 50,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-border/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], ["label", "Color"], 0, null, ["loc", [null, [44, 8], [49, 37]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 38,
                  "column": 4
                },
                "end": {
                  "line": 51,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-border/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(2);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "controls/input-list-item", [], ["label", "Width"], 0, null, ["loc", [null, [39, 6], [41, 35]]]], ["block", "if", [["get", "showColor", ["loc", [null, [43, 12], [43, 21]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [43, 6], [50, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 53,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-border/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(4);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Link Sides", "isVisible", ["subexpr", "not", [["get", "alwaysLinked", ["loc", [null, [5, 66], [5, 78]]], 0, 0, 0, 0]], [], ["loc", [null, [5, 61], [5, 79]]], 0, 0]], 0, null, ["loc", [null, [5, 4], [10, 33]]]], ["block", "controls/input-list-item", [], ["label", "Side", "isVisible", ["subexpr", "not", [["get", "linked", ["loc", [null, [12, 60], [12, 66]]], 0, 0, 0, 0]], [], ["loc", [null, [12, 55], [12, 67]]], 0, 0]], 1, null, ["loc", [null, [12, 4], [19, 33]]]], ["block", "controls/input-list-item", [], ["label", "Style"], 2, null, ["loc", [null, [21, 4], [36, 33]]]], ["block", "unless", [["subexpr", "eq", [["get", "activeStyle", ["loc", [null, [38, 18], [38, 29]]], 0, 0, 0, 0], "none"], [], ["loc", [null, [38, 14], [38, 37]]], 0, 0]], [], 3, null, ["loc", [null, [38, 4], [51, 15]]]]],
          locals: [],
          templates: [child0, child1, child2, child3]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 55,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-border/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [53, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 57,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-border/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [55, 22]]]], ["content", "yield", ["loc", [null, [56, 0], [56, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-box-shadow/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  function composedValue(name) {
    return _ember['default'].computed('value', {
      get: function get() {
        return this.destruct()[name];
      },
      set: function set(key, value) {
        var update = {};
        update[name] = value;
        this.set('value', this.reconstitute(update));
        return value;
      }
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    reconstitute: function reconstitute(updates) {

      var data = this.destruct();

      for (var key in updates) {
        data[key] = updates[key];
      }

      return '' + (data.inset ? 'inset ' : '') + data.xOffset + ' ' + data.yOffset + ' ' + data.blur + ' ' + data.spread;
    },

    destruct: function destruct() {

      var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('value', ''));
      var inset = 'inset' === parts[0];

      if (inset) {
        parts.shift();
      }

      var data = {
        xOffset: _ember['default'].isPresent(parts[0]) ? parts[0] : '0px',
        yOffset: _ember['default'].isPresent(parts[1]) ? parts[1] : '0px',
        blur: _ember['default'].isPresent(parts[2]) ? parts[2] : '0px',
        spread: _ember['default'].isPresent(parts[3]) ? parts[3] : '0px',
        inset: inset
      };

      // debugger;
      return data;
    },

    inset: composedValue('inset'),
    xOffset: composedValue('xOffset'),
    yOffset: composedValue('yOffset'),
    blur: composedValue('blur'),
    spread: composedValue('spread'),

    showColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('color'),
    showAltColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt_color'),

    xOffsetOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('x_offset', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: -50, max: 50, step: 1 },
        em: { min: -1, max: 1, step: 0.001 },
        rem: { min: -1, max: 1, step: 0.001 }
      }
    }),

    yOffsetOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('y_offset', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: -50, max: 50, step: 1 },
        em: { min: -1, max: 1, step: 0.001 },
        rem: { min: -1, max: 1, step: 0.001 }
      }
    }),

    blurOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('blur', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: 0, max: 100, step: 1 },
        em: { min: 0, max: 5, step: 0.001 },
        rem: { min: 0, max: 5, step: 0.001 }
      }
    }),

    spreadOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('blur', {
      available_units: ['px', 'em', 'rem']
    }),

    colorOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('color'),
    altColorOptions: _ember['default'].computed('colorOptions', function () {
      var options = _ember['default'].copy(this.get('colorOptions'));
      if (options.alt_label) {
        options.label = options.alt_label;
      }
      return options;
    })
  });
});
define("cornerstone/components/controls/control-box-shadow/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 7,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "xOffset", ["loc", [null, [6, 32], [6, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "xOffsetOptions", ["loc", [null, [6, 48], [6, 62]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [6, 6], [6, 64]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 9,
                  "column": 4
                },
                "end": {
                  "line": 11,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "yOffset", ["loc", [null, [10, 32], [10, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "yOffsetOptions", ["loc", [null, [10, 48], [10, 62]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [10, 6], [10, 64]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 13,
                  "column": 4
                },
                "end": {
                  "line": 15,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "blur", ["loc", [null, [14, 32], [14, 36]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "blurOptions", ["loc", [null, [14, 45], [14, 56]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [14, 6], [14, 59]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 23,
                    "column": 10
                  },
                  "end": {
                    "line": 26,
                    "column": 10
                  }
                },
                "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("            ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n            ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [24, 41], [24, 47]]], 0, 0, 0, 0]], [], [], 0, 0], "value", false, "icon", "sign-out"], ["loc", [null, [24, 12], [24, 77]]], 0, 0], ["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [25, 41], [25, 47]]], 0, 0, 0, 0]], [], [], 0, 0], "value", true, "icon", "sign-in"], ["loc", [null, [25, 12], [25, 75]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 17,
                  "column": 4
                },
                "end": {
                  "line": 29,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("ul");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              dom.setAttribute(el2, "style", "-webkit-flex: 0 0 48%; flex: 0 0 48%;");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              dom.setAttribute(el2, "style", "-webkit-flex: 0 0 48%; flex: 0 0 48%;");
              var el3 = dom.createTextNode("\n");
              dom.appendChild(el2, el3);
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1]);
              var morphs = new Array(2);
              morphs[0] = dom.createMorphAt(dom.childAt(element0, [1]), 1, 1);
              morphs[1] = dom.createMorphAt(dom.childAt(element0, [3]), 1, 1);
              return morphs;
            },
            statements: [["inline", "forms/unit-input", [], ["value", ["subexpr", "@mut", [["get", "spread", ["loc", [null, [20, 35], [20, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "spreadOptions", ["loc", [null, [20, 50], [20, 63]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [20, 10], [20, 65]]], 0, 0], ["block", "forms/choose-single", [], ["value", ["subexpr", "@mut", [["get", "inset", ["loc", [null, [23, 39], [23, 44]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [23, 10], [26, 34]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child4 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 34,
                      "column": 8
                    },
                    "end": {
                      "line": 36,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyAltColor", ["loc", [null, [35, 37], [35, 56]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "altColorOptions", ["loc", [null, [35, 65], [35, 80]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [35, 10], [35, 82]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 32,
                    "column": 6
                  },
                  "end": {
                    "line": 37,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyColor", ["loc", [null, [33, 35], [33, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "colorOptions", ["loc", [null, [33, 60], [33, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [33, 8], [33, 74]]], 0, 0], ["block", "if", [["get", "showAltColor", ["loc", [null, [34, 14], [34, 26]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [34, 8], [36, 15]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 31,
                  "column": 4
                },
                "end": {
                  "line": 38,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "controls/input-list-item", [], ["label", "Color"], 0, null, ["loc", [null, [32, 6], [37, 35]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 40,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(5);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
            morphs[4] = dom.createMorphAt(fragment, 9, 9, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "X-Offset"], 0, null, ["loc", [null, [5, 4], [7, 33]]]], ["block", "controls/input-list-item", [], ["label", "Y-Offset"], 1, null, ["loc", [null, [9, 4], [11, 33]]]], ["block", "controls/input-list-item", [], ["label", "Blur"], 2, null, ["loc", [null, [13, 4], [15, 33]]]], ["block", "controls/input-list-item", [], ["label", "Spread &amp;<br>Position"], 3, null, ["loc", [null, [17, 4], [29, 33]]]], ["block", "if", [["get", "showColor", ["loc", [null, [31, 10], [31, 19]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [31, 4], [38, 11]]]]],
          locals: [],
          templates: [child0, child1, child2, child3, child4]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 41,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [40, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 43,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-box-shadow/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [41, 22]]]], ["content", "yield", ["loc", [null, [42, 0], [42, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-breakpoints/component', ['exports', 'ember', 'npm:nouislider', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _npmNouislider, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({

    didInsertElement: function didInsertElement() {

      _ember['default'].run.scheduleOnce('afterRender', (function () {

        _npmNouislider['default'].create(this.$('.cs-bp-slider-xs .cs-unit-slider-target')[0], {
          start: 300,
          step: 1,
          connect: 'lower',
          range: {
            'min': 0,
            'max': 1500
          }
        });

        _npmNouislider['default'].create(this.$('.cs-bp-slider-sm .cs-unit-slider-target')[0], {
          start: [301, 600],
          step: 1,
          connect: true,
          range: {
            'min': 0,
            'max': 1500
          }
        });

        _npmNouislider['default'].create(this.$('.cs-bp-slider-md .cs-unit-slider-target')[0], {
          start: [601, 900],
          step: 1,
          connect: true,
          range: {
            'min': 0,
            'max': 1500
          }
        });

        _npmNouislider['default'].create(this.$('.cs-bp-slider-lg .cs-unit-slider-target')[0], {
          start: [901, 1200],
          step: 1,
          connect: true,
          range: {
            'min': 0,
            'max': 1500
          }
        });

        _npmNouislider['default'].create(this.$('.cs-bp-slider-xl .cs-unit-slider-target')[0], {
          start: 1201,
          step: 1,
          connect: 'upper',
          range: {
            'min': 0,
            'max': 1500
          }
        });
      }).bind(this));
    }

  });
});
define("cornerstone/components/controls/control-breakpoints/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 12,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-unit-slider cs-bp-slider-xs");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-unit-slider-target-container");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-unit-slider-target");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createElement("strong");
              var el4 = dom.createTextNode("XS");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 14,
                  "column": 4
                },
                "end": {
                  "line": 21,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-unit-slider cs-bp-slider-sm");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-unit-slider-target-container");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-unit-slider-target");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createElement("strong");
              var el4 = dom.createTextNode("SM");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 23,
                  "column": 4
                },
                "end": {
                  "line": 30,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-unit-slider cs-bp-slider-md");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-unit-slider-target-container");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-unit-slider-target");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createElement("strong");
              var el4 = dom.createTextNode("MD");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 32,
                  "column": 4
                },
                "end": {
                  "line": 39,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-unit-slider cs-bp-slider-lg");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-unit-slider-target-container");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-unit-slider-target");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createElement("strong");
              var el4 = dom.createTextNode("LG");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        var child4 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 41,
                  "column": 4
                },
                "end": {
                  "line": 48,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "cs-unit-slider cs-bp-slider-xl");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "cs-unit-slider-target-container");
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "cs-unit-slider-target");
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n        ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("span");
              var el3 = dom.createElement("strong");
              var el4 = dom.createTextNode("XL");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 50,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(5);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
            morphs[4] = dom.createMorphAt(fragment, 9, 9, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "<strong>300px</strong> &amp;<br>Below"], 0, null, ["loc", [null, [5, 4], [12, 33]]]], ["block", "controls/input-list-item", [], ["label", "<strong>301px</strong> to<br><strong>600px</strong>"], 1, null, ["loc", [null, [14, 4], [21, 33]]]], ["block", "controls/input-list-item", [], ["label", "<strong>601px</strong> to<br><strong>900px</strong>"], 2, null, ["loc", [null, [23, 4], [30, 33]]]], ["block", "controls/input-list-item", [], ["label", "<strong>901px</strong> to<br><strong>1200px</strong>"], 3, null, ["loc", [null, [32, 4], [39, 33]]]], ["block", "controls/input-list-item", [], ["label", "<strong>1201px</strong> &amp;<br>Above"], 4, null, ["loc", [null, [41, 4], [48, 33]]]]],
          locals: [],
          templates: [child0, child1, child2, child3, child4]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 52,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [50, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 54,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-breakpoints/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [52, 22]]]], ["content", "yield", ["loc", [null, [53, 0], [53, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-checkbox-list/component', ['exports', 'ember', 'cornerstone/components/controls/input-list-item/component'], function (exports, _ember, _cornerstoneComponentsControlsInputListItemComponent) {
  exports['default'] = _cornerstoneComponentsControlsInputListItemComponent['default'].extend({
    checkboxes: _ember['default'].computed('control.options.list', function () {

      var cbs = this.get('control.options.list');
      if (!_ember['default'].isArray(cbs)) {
        return _ember['default'].A();
      }

      return _ember['default'].copy(cbs, true).map(function (cb) {
        cb.keyPath = _ember['default'].String.camelize('key-' + cb.key);
        return cb;
      });
    })
  });
});
define("cornerstone/components/controls/control-checkbox-list/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 5,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-checkbox-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/checkbox-list", [], ["checkboxes", ["subexpr", "@mut", [["get", "checkboxes", ["loc", [null, [3, 35], [3, 45]]], 0, 0, 0, 0]], [], [], 0, 0], "proxy", ["subexpr", "@mut", [["get", "control", ["loc", [null, [3, 52], [3, 59]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 61]]], 0, 0], ["content", "yield", ["loc", [null, [4, 2], [4, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-checkbox-list/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [5, 22]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-choose-multi/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-choose-multi/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 11,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-choose-multi/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/choose-multi", [], ["visibilityObservation", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [4, 26], [4, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "choices", ["subexpr", "@mut", [["get", "control.options.choices", ["loc", [null, [5, 12], [5, 35]]], 0, 0, 0, 0]], [], [], 0, 0], "offValue", ["subexpr", "@mut", [["get", "options.off_value", ["loc", [null, [6, 13], [6, 30]]], 0, 0, 0, 0]], [], [], 0, 0], "delimiter", ["subexpr", "@mut", [["get", "options.delimiter", ["loc", [null, [7, 14], [7, 31]]], 0, 0, 0, 0]], [], [], 0, 0], "arrayOutput", ["subexpr", "@mut", [["get", "options.arrayOutput", ["loc", [null, [8, 16], [8, 35]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [9, 10], [9, 15]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [10, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 13,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-choose-multi/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [11, 22]]]], ["content", "yield", ["loc", [null, [12, 0], [12, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-choose-single/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-choose-single/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-choose-single/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/choose-single", [], ["visibilityObservation", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [3, 46], [3, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "choices", ["subexpr", "@mut", [["get", "control.options.choices", ["loc", [null, [3, 63], [3, 86]]], 0, 0, 0, 0]], [], [], 0, 0], "offValue", ["subexpr", "@mut", [["get", "options.off_value", ["loc", [null, [3, 96], [3, 113]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 120], [3, 125]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 127]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-choose-single/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-classic-dimensions/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  // import splitValue from '../../../util/split-on-whitespace';

  var dims = ['top', 'right', 'bottom', 'left', 'linked'];
  var defaultValue = ['0px', '0px', '0px', '0px', 'linked'];

  function valueProperty(dim) {

    return _ember['default'].computed('value', {
      get: function get() {
        return this.getWithDefault('value', defaultValue)[dims.indexOf(dim)];
      },
      set: function set(key, value) {

        var current = this.get('value');

        if (this.get('linked')) {
          current[0] = value;
          current[1] = value;
          current[2] = value;
          current[3] = value;
        } else {
          current[dims.indexOf(dim)] = value;
        }

        this.set('value', current.slice(0));
        this.set('recentlyChanged', dim);
        return value;
      }
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    labels: _ember['default'].computed('control.options.labels', function () {

      var labels = {};
      var defaults = {
        top: 'Top',
        right: 'Right',
        bottom: 'Bottom',
        left: 'Left'
      };

      var mappedLabels = this.getWithDefault('control.options.labels', {});
      Object.keys(defaults).forEach(function (label) {
        labels[label] = _ember['default'].isPresent(mappedLabels[label]) ? mappedLabels[label] : defaults[label];
      });

      return labels;
    }),

    top: valueProperty('top'),
    right: valueProperty('right'),
    bottom: valueProperty('bottom'),
    left: valueProperty('left'),

    linked: _ember['default'].computed('value', {
      get: function get() {
        return this.getWithDefault('value', defaultValue)[4] === 'linked';
      },
      set: function set(key, value) {

        var current = this.get('value');

        current[4] = value ? 'linked' : 'unlinked';

        if (value) {
          var recent = this.get('recentlyChanged');

          if (!recent) {
            recent = 'top';
          }

          var linkedVal = current[dims.indexOf(recent)];

          current[0] = linkedVal;
          current[1] = linkedVal;
          current[2] = linkedVal;
          current[3] = linkedVal;
        }

        this.set('value', current.slice(0));

        return value;
      }
    }),

    actions: {
      toggleLinked: function toggleLinked() {
        this.set('linked', !this.get('linked'));
      }
    }
  });
});
define("cornerstone/components/controls/control-classic-dimensions/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 16,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-classic-dimensions/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createElement("ul");
          dom.setAttribute(el1, "class", "cs-dimensions");
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("li");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("span");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("li");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("span");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("li");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("span");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("li");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("span");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("li");
          var el3 = dom.createTextNode("\n    ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("button");
          var el4 = dom.createTextNode("\n      ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("i");
          dom.setAttribute(el4, "class", "cs-fa-data-attr link");
          dom.setAttribute(el4, "data-cs-icon", "");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n      ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("i");
          dom.setAttribute(el4, "class", "cs-fa-data-attr unlink");
          dom.setAttribute(el4, "data-cs-icon", "");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n    ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n  ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [0]);
          var element1 = dom.childAt(element0, [1]);
          var element2 = dom.childAt(element0, [3]);
          var element3 = dom.childAt(element0, [5]);
          var element4 = dom.childAt(element0, [7]);
          var element5 = dom.childAt(element0, [9, 1]);
          var element6 = dom.childAt(element5, [1]);
          var element7 = dom.childAt(element5, [3]);
          var morphs = new Array(12);
          morphs[0] = dom.createMorphAt(element1, 0, 0);
          morphs[1] = dom.createMorphAt(dom.childAt(element1, [1]), 0, 0);
          morphs[2] = dom.createMorphAt(element2, 0, 0);
          morphs[3] = dom.createMorphAt(dom.childAt(element2, [1]), 0, 0);
          morphs[4] = dom.createMorphAt(element3, 0, 0);
          morphs[5] = dom.createMorphAt(dom.childAt(element3, [1]), 0, 0);
          morphs[6] = dom.createMorphAt(element4, 0, 0);
          morphs[7] = dom.createMorphAt(dom.childAt(element4, [1]), 0, 0);
          morphs[8] = dom.createAttrMorph(element5, 'class');
          morphs[9] = dom.createElementMorph(element5);
          morphs[10] = dom.createAttrMorph(element6, 'title');
          morphs[11] = dom.createAttrMorph(element7, 'title');
          return morphs;
        },
        statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "top", ["loc", [null, [4, 20], [4, 23]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [4, 6], [4, 25]]], 0, 0], ["content", "labels.top", ["loc", [null, [4, 31], [4, 45]]], 0, 0, 0, 0], ["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "right", ["loc", [null, [5, 20], [5, 25]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [5, 6], [5, 27]]], 0, 0], ["content", "labels.right", ["loc", [null, [5, 33], [5, 49]]], 0, 0, 0, 0], ["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "bottom", ["loc", [null, [6, 20], [6, 26]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [6, 6], [6, 28]]], 0, 0], ["content", "labels.bottom", ["loc", [null, [6, 34], [6, 51]]], 0, 0, 0, 0], ["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "left", ["loc", [null, [7, 20], [7, 24]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [7, 6], [7, 26]]], 0, 0], ["content", "labels.left", ["loc", [null, [7, 32], [7, 47]]], 0, 0, 0, 0], ["attribute", "class", ["concat", ["cs-link-dimensions ", ["subexpr", "if", [["get", "linked", ["loc", [null, [9, 43], [9, 49]]], 0, 0, 0, 0], "active"], [], ["loc", [null, [9, 38], [9, 60]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["toggleLinked"], [], ["loc", [null, [9, 62], [9, 87]]], 0, 0], ["attribute", "title", ["concat", [["subexpr", "t", ["content.dimensions-unlink"], [], ["loc", [null, [10, 69], [10, 102]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "title", ["concat", [["subexpr", "t", ["content.dimensions-link"], [], ["loc", [null, [11, 71], [11, 102]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 18,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-classic-dimensions/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [16, 22]]]], ["content", "yield", ["loc", [null, [17, 0], [17, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-classic-title/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {
    classNameBindings: ['monospace:cs-monospace-input']
  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-classic-title/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-classic-title/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "content/cs-title", [], ["title", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [3, 27], [3, 43]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 45]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-classic-title/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-color/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({

    showAlt: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt'),

    colorValue: _ember['default'].computed.alias('value'),
    altColorValue: _ember['default'].computed.alias('control.keyAlt'),

    baseOptions: _ember['default'].computed.alias('control.options'),
    altOptions: _ember['default'].computed('baseOptions', function () {
      var options = _ember['default'].merge({}, this.get('baseOptions'));
      if (options.alt_label) {
        options.label = options.alt_label;
      }
      return options;
    }),

    usePalette: _ember['default'].computed('baseOptions.palette', function () {
      return false !== this.get('baseOptions.palette');
    }),

    usePaletteAlt: _ember['default'].computed('baseOptions.palette', function () {
      return false !== this.get('altOptions.palette');
    })

  });
});
define("cornerstone/components/controls/control-color/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 5,
                "column": 2
              },
              "end": {
                "line": 7,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-color/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyAlt", ["loc", [null, [6, 31], [6, 45]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "altOptions", ["loc", [null, [6, 54], [6, 64]]], 0, 0, 0, 0]], [], [], 0, 0], "usePalette", ["subexpr", "@mut", [["get", "usePaletteAlt", ["loc", [null, [6, 76], [6, 89]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [6, 4], [6, 91]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 8,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-color/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("\n  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [4, 29], [4, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "baseOptions", ["loc", [null, [4, 43], [4, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "usePalette", ["subexpr", "@mut", [["get", "usePalette", ["loc", [null, [4, 66], [4, 76]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [4, 2], [4, 78]]], 0, 0], ["block", "if", [["get", "showAlt", ["loc", [null, [5, 8], [5, 15]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 2], [7, 9]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-color/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [8, 22]]]], ["content", "yield", ["loc", [null, [9, 0], [9, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-dimensions/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  var dims = ['top', 'right', 'bottom', 'left'];

  function dimensionOptions(dim) {
    return _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions(dim, {
      available_units: ['px', 'em', 'rem', '%'],
      ranges: {
        px: { min: 0, max: 100, step: 1 },
        em: { min: 0, max: 2.5, step: 0.001 },
        rem: { min: 0, max: 2.5, step: 0.001 },
        '%': { min: 0, max: 100, step: 0.1 }
      }
    }, function (options) {
      if (options.disabled && options.hasOwnProperty('fallback_value')) {
        options.unlinkedState = options.fallback_value;
      }
      return options;
    });
  }

  function dimensionProperty(dim) {

    return _ember['default'].computed('expandedValue', {
      get: function get() {
        return this.getWithDefault(dim + 'Options.unlinkedState', (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('expandedValue', ''))[dims.indexOf(dim)]);
      },
      set: function set(key, value) {

        var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('expandedValue', ''));

        if (this.get('linked')) {
          dims.forEach((function (side, index) {
            var unlinked = this.get(side + 'Options.unlinkedState');
            parts[index] = _ember['default'].isNone(unlinked) ? value : unlinked;
          }).bind(this));
        } else {
          parts[dims.indexOf(dim)] = value;
        }

        this.set('expandedValue', parts.join(' '));
        this.set('recentlyChanged', dim);
        return value;
      }
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    init: function init() {

      this._super.apply(this, arguments);

      // Linked detection
      var value = (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('value', ''));
      var linked = false;

      if (1 === value.length) {
        linked = true;
      } else {
        linked = 1 === dims.filter((function (dim) {
          return _ember['default'].isNone(this.get(dim + 'Options.unlinkedState'));
        }).bind(this)).map(function (dim) {
          return value[dims.indexOf(dim)];
        }).uniq().length;
      }

      if (linked) {
        this.set('linked', true);
      }
    },

    expandedValue: _ember['default'].computed('value', {
      get: function get() {
        var value = this.getWithDefault('value', '');

        if (1 === (0, _cornerstoneUtilSplitOnWhitespace['default'])(value).length) {
          return [value, value, value, value].join(' ');
        }

        return value;
      },
      set: function set(key, value) {
        var a = _ember['default'].A((0, _cornerstoneUtilSplitOnWhitespace['default'])(value));
        this.set('value', 1 === a.uniq().length ? a.get('firstObject') : value);
        return value;
      }
    }),

    labels: _ember['default'].computed('control.options.labels', function () {

      var labels = {};
      var defaults = {
        top: 'Top',
        right: 'Right',
        bottom: 'Bottom',
        left: 'Left'
      };

      var mappedLabels = this.getWithDefault('control.options.labels', {});
      Object.keys(defaults).forEach(function (label) {
        labels[label] = _ember['default'].isPresent(mappedLabels[label]) ? mappedLabels[label] : defaults[label];
      });

      return labels;
    }),

    linked: false,

    top: dimensionProperty('top'),
    right: dimensionProperty('right'),
    bottom: dimensionProperty('bottom'),
    left: dimensionProperty('left'),

    topOptions: dimensionOptions('top'),
    rightOptions: dimensionOptions('right'),
    bottomOptions: dimensionOptions('bottom'),
    leftOptions: dimensionOptions('left'),

    observeRecentDimension: _ember['default'].observer('linked', function () {

      if (!this.get('linked')) {
        return;
      }

      var recent = this.get('recentlyChanged');

      if (!recent) {
        recent = 'top';
      }

      this.set(recent, this.get(recent));
    })
  });
});
define("cornerstone/components/controls/control-dimensions/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 5,
                    "column": 6
                  },
                  "end": {
                    "line": 18,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [7, 17], [7, 23]]], 0, 0, 0, 0]], [], [], 0, 0], "value", false, "icon", "unlink", "tooltip", "Unlinked"], ["loc", [null, [6, 8], [11, 10]]], 0, 0], ["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [13, 17], [13, 23]]], 0, 0, 0, 0]], [], [], 0, 0], "value", true, "icon", "link", "tooltip", "Linked"], ["loc", [null, [12, 8], [17, 10]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 4,
                  "column": 4
                },
                "end": {
                  "line": 19,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "forms/choose-single", [], ["choices", ["subexpr", "@mut", [["get", "linkedChoices", ["loc", [null, [5, 37], [5, 50]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "linked", ["loc", [null, [5, 57], [5, 63]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [5, 6], [18, 30]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 21,
                  "column": 4
                },
                "end": {
                  "line": 23,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "top", ["loc", [null, [22, 32], [22, 35]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "topOptions", ["loc", [null, [22, 44], [22, 54]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [22, 6], [22, 56]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 25,
                  "column": 4
                },
                "end": {
                  "line": 27,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "right", ["loc", [null, [26, 32], [26, 37]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "rightOptions", ["loc", [null, [26, 46], [26, 58]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [26, 6], [26, 60]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 29,
                  "column": 4
                },
                "end": {
                  "line": 31,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "bottom", ["loc", [null, [30, 32], [30, 38]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "bottomOptions", ["loc", [null, [30, 47], [30, 60]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [30, 6], [30, 62]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child4 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 33,
                  "column": 4
                },
                "end": {
                  "line": 35,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "left", ["loc", [null, [34, 32], [34, 36]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "leftOptions", ["loc", [null, [34, 45], [34, 56]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [34, 6], [34, 58]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 37,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(5);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 6, 6, contextualElement);
            morphs[4] = dom.createMorphAt(fragment, 8, 8, contextualElement);
            dom.insertBoundary(fragment, 0);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Link Sides"], 0, null, ["loc", [null, [4, 4], [19, 33]]]], ["block", "controls/input-list-item", [], ["label", ["subexpr", "@mut", [["get", "labels.top", ["loc", [null, [21, 38], [21, 48]]], 0, 0, 0, 0]], [], [], 0, 0]], 1, null, ["loc", [null, [21, 4], [23, 33]]]], ["block", "controls/input-list-item", [], ["label", ["subexpr", "@mut", [["get", "labels.right", ["loc", [null, [25, 38], [25, 50]]], 0, 0, 0, 0]], [], [], 0, 0]], 2, null, ["loc", [null, [25, 4], [27, 33]]]], ["block", "controls/input-list-item", [], ["label", ["subexpr", "@mut", [["get", "labels.bottom", ["loc", [null, [29, 38], [29, 51]]], 0, 0, 0, 0]], [], [], 0, 0]], 3, null, ["loc", [null, [29, 4], [31, 33]]]], ["block", "controls/input-list-item", [], ["label", ["subexpr", "@mut", [["get", "labels.left", ["loc", [null, [33, 38], [33, 49]]], 0, 0, 0, 0]], [], [], 0, 0]], 4, null, ["loc", [null, [33, 4], [35, 33]]]]],
          locals: [],
          templates: [child0, child1, child2, child3, child4]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 39,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [37, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 41,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-dimensions/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [39, 22]]]], ["content", "yield", ["loc", [null, [40, 0], [40, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-flex-layout-attr/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  var linkedProperyKeys = ['flexDirection', 'reverseLayout', 'wrapChildren', 'horizontal', 'vertical'];

  function linkedProperty(key, parser) {

    if ('horizontal' === key) {
      parser = function (value) {
        return linkedAxis(value, 1);
      };
    }

    if ('vertical' === key) {
      parser = function (value) {
        return linkedAxis(value, 0);
      };
    }

    function linkedAxis(value, index) {
      var side = (value[1] || '').split('-')[index];
      return _ember['default'].isPresent(side) ? side.replace('top', 'start').replace('left', 'start').replace('right', 'end').replace('bottom', 'end') : 'start';
    }

    return _ember['default'].computed.apply(_ember['default'], ['value', {
      get: function get() {
        // if ( linkedProperty )
        return parser((0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('value', '')));
      },
      set: function set(key, value) {

        var otherKeys = linkedProperyKeys.filter(function (otherKey) {
          return key !== otherKey;
        });

        var args = this.getProperties(otherKeys);
        args[key] = value;

        var isRow = 'row' === args.flexDirection;
        var layout = isRow ? 'row' : 'col';

        if (args.wrapChildren) {
          layout += 's';
        }

        var map = {
          vertical: {
            start: 'top',
            end: 'bottom'
          },
          horizontal: {
            start: 'left',
            end: 'right'
          }
        };

        var vertical = map.vertical[args.vertical] ? map.vertical[args.vertical] : args.vertical;
        var horizontal = map.horizontal[args.horizontal] ? map.horizontal[args.horizontal] : args.horizontal;

        var reverse = args.reverseLayout ? ' rev' : '';

        // console.log(`${layout} ${vertical}-${horizontal}${reverse}`);

        this.set('value', layout + ' ' + vertical + '-' + horizontal + reverse);
        return value;
      }
    }]);
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    flexDirection: linkedProperty('flexDirection', function (value) {
      return ['col', 'cols'].includes(value[0]) ? 'col' : 'row';
    }),

    reverseLayout: linkedProperty('reverseLayout', function (value) {
      return 'rev' === value[2];
    }),

    wrapChildren: linkedProperty('wrapChildren', function (value) {
      return ['rows', 'cols'].includes(value[0]);
    }),

    horizontal: linkedProperty('horizontal'),

    vertical: linkedProperty('vertical'),

    baseOptions: [{ value: 'start', label: 'Start' }, { value: 'center', label: 'Center' }, { value: 'end', label: 'End' }],

    mainAxisOptions: [{ value: 'justify', label: 'Space Between' }, { value: 'spread', label: 'Space Around' }],

    crossAxisOptions: [{ value: 'stretch', label: 'Stretch' }],

    horizontalOptions: _ember['default'].computed('flexDirection', function () {
      return _ember['default'].A('row' === this.get('flexDirection') ? this.get('baseOptions').concat(this.get('mainAxisOptions')) : this.get('baseOptions').concat(this.get('crossAxisOptions')));
    }),

    verticalOptions: _ember['default'].computed('flexDirection', function () {
      return _ember['default'].A('row' === this.get('flexDirection') ? this.get('baseOptions').concat(this.get('crossAxisOptions')) : this.get('baseOptions').concat(this.get('mainAxisOptions')));
    }),

    horizontalOptionObserver: _ember['default'].observer('horizontalOptions', function () {

      var current = this.get('horizontal');

      if (!_ember['default'].isNone(this.get('horizontalOptions').find(function (opt) {
        return opt.value === current;
      }))) {
        return;
      }

      var fallback = 'start';

      if ('row' === this.get('flexDirection')) {
        if ('stretch' === current) {
          fallback = 'spread';
        }
      } else {
        if ('spread' === current) {
          fallback = 'stretch';
        }
      }

      this.set('horizontal', fallback);
    }),

    verticalOptionObserver: _ember['default'].observer('verticalOptions', function () {

      var current = this.get('vertical');

      if (!_ember['default'].isNone(this.get('verticalOptions').find(function (opt) {
        return opt.value === current;
      }))) {
        return;
      }

      var fallback = 'start';

      if ('row' === this.get('flexDirection')) {
        if ('spread' === current) {
          fallback = 'stretch';
        }
      } else {
        if ('stretch' === current) {
          fallback = 'spread';
        }
      }

      this.set('vertical', fallback);
    })

  });
});
define("cornerstone/components/controls/control-flex-layout-attr/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 6,
                    "column": 6
                  },
                  "end": {
                    "line": 9,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [7, 37], [7, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "row", "label", "Row"], ["loc", [null, [7, 8], [7, 69]]], 0, 0], ["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [8, 37], [8, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "col", "label", "Column"], ["loc", [null, [8, 8], [8, 72]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 11,
                    "column": 6
                  },
                  "end": {
                    "line": 13,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "wrapChildren", ["loc", [null, [12, 32], [12, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Wrap Children", "wide", true], ["loc", [null, [12, 8], [12, 78]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 14,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(3);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
              morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "forms/choose-single", [], ["value", ["subexpr", "@mut", [["get", "flexDirection", ["loc", [null, [6, 35], [6, 48]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [6, 6], [9, 30]]]], ["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "reverseLayout", ["loc", [null, [10, 30], [10, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Reverse Layout", "wide", true], ["loc", [null, [10, 6], [10, 78]]], 0, 0], ["block", "if", [["get", "control.options.allow_wrap", ["loc", [null, [11, 12], [11, 38]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [11, 6], [13, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 16,
                  "column": 4
                },
                "end": {
                  "line": 18,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "horizontal", ["loc", [null, [17, 34], [17, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "horizontalOptions", ["loc", [null, [17, 53], [17, 70]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [17, 6], [17, 73]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 20,
                  "column": 4
                },
                "end": {
                  "line": 22,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "vertical", ["loc", [null, [21, 34], [21, 42]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "verticalOptions", ["loc", [null, [21, 51], [21, 66]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [21, 6], [21, 69]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 24,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(3);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Layout"], 0, null, ["loc", [null, [5, 4], [14, 33]]]], ["block", "controls/input-list-item", [], ["label", "Horizontal"], 1, null, ["loc", [null, [16, 4], [18, 33]]]], ["block", "controls/input-list-item", [], ["label", "Vertical"], 2, null, ["loc", [null, [20, 4], [22, 33]]]]],
          locals: [],
          templates: [child0, child1, child2]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 26,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [24, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 28,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-flex-layout-attr/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [26, 22]]]], ["content", "yield", ["loc", [null, [27, 0], [27, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-flex-layout/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    canWrap: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('wrap'),
    canReverse: _ember['default'].computed('control.options.allow_reverse', function () {
      return false !== this.get('control.options.allow_reverse');
    }),

    wrapChildren: _ember['default'].computed.alias('control.keyWrap'),
    // wrapChildren: Ember.computed('control.keyWrap', {
    //   get() {
    //     return 'wrap' === this.get('control.keyWrap');
    //   },
    //   set(key,value) {
    //     this.set('control.keyWrap', value ? 'wrap' : '');
    //     return value;
    //   }
    // }),

    directionUpdated: 0,
    didReceiveAttrs: function didReceiveAttrs() {
      var direction = this.get('flexDirection');
      this.set('previousDirection', this.get('flexDirection'));
      this.set('isRow', 'row' === direction);
    },

    directionChange: _ember['default'].observer('flexDirection', function () {
      var previousDirection = this.get('previousDirection');
      var direction = this.get('flexDirection');
      if (direction !== previousDirection) {

        var align = this.get('control.keyAlign');
        var justify = this.get('control.keyJustify');
        this.set('control.keyAlign', justify);
        this.set('control.keyJustify', align);

        this.set('isRow', 'row' === direction);
        this.incrementProperty('directionUpdated');
        this.set('previousDirection', direction);
      }
    }),

    flexDirection: _ember['default'].computed('control.keyDirection', {
      get: function get() {
        return this.getWithDefault('control.keyDirection', 'row').split('-')[0];
      },

      set: function set(key, value) {
        var direction = value;
        if (this.get('canReverse') && this.get('reverseLayout')) {
          direction += '-reverse';
        }
        this.set('control.keyDirection', direction);
        return value;
      }
    }),

    reverseLayout: _ember['default'].computed('control.keyDirection', {
      get: function get() {
        return this.getWithDefault('control.keyDirection', 'row').includes('reverse');
      },

      set: function set(key, value) {
        var direction = this.getWithDefault('control.keyDirection', 'row').split('-')[0];
        if (value) {
          direction += '-reverse';
        }
        this.set('control.keyDirection', direction);
        return value;
      }
    }),

    flexDir: _ember['default'].computed.alias('flexDirection'),

    horizontalPath: _ember['default'].computed('flexDirection', function () {
      return 'row' === this.get('flexDirection') ? 'control.keyJustify' : 'control.keyAlign';
    }),

    verticalPath: _ember['default'].computed('flexDirection', function () {
      return 'row' === this.get('flexDirection') ? 'control.keyAlign' : 'control.keyJustify';
    }),

    baseOptions: [{ value: 'flex-start', label: 'Start' }, { value: 'center', label: 'Center' }, { value: 'flex-end', label: 'End' }],

    mainAxisOptions: [{ value: 'space-between', label: 'Space Between' }, { value: 'space-around', label: 'Space Around' }],

    crossAxisOptions: [{ value: 'stretch', label: 'Stretch' }],

    horizontalOptions: _ember['default'].computed('directionUpdated', function () {
      // console.log('option update', this.get('flexDirection') );
      return _ember['default'].A('row' === this.get('flexDirection') ? this.get('baseOptions').concat(this.get('mainAxisOptions')) : this.get('baseOptions').concat(this.get('crossAxisOptions')));
    }),

    verticalOptions: _ember['default'].computed('directionUpdated', function () {

      return _ember['default'].A('row' === this.get('flexDirection') ? this.get('baseOptions').concat(this.get('crossAxisOptions')) : this.get('baseOptions').concat(this.get('mainAxisOptions')));
    }),

    horizontalOptionObserver: _ember['default'].observer('horizontalOptions', function () {
      var isRow = this.get('isRow');
      var key = isRow ? 'control.keyJustify' : 'control.keyAlign';
      var current = this.get(key);

      if (!_ember['default'].isNone(this.get('horizontalOptions').find(function (opt) {
        return opt.value === current;
      }))) {
        return;
      }

      var fallback = 'flex-start';

      if (isRow) {
        if ('stretch' === current) {
          fallback = 'space-around';
        }
      } else {
        if ('space-around' === current) {
          fallback = 'stretch';
        }
      }

      this.set(key, fallback);
    }),

    verticalOptionObserver: _ember['default'].observer('verticalOptions', function () {

      var isRow = this.get('isRow');
      var key = isRow ? 'control.keyAlign' : 'control.keyJustify';
      var current = this.get(key);

      if (!_ember['default'].isNone(this.get('verticalOptions').find(function (opt) {
        return opt.value === current;
      }))) {
        return;
      }

      var fallback = 'flex-start';

      if ('row' === this.get('flexDirection')) {
        if ('space-around' === current) {
          fallback = 'stretch';
        }
      } else {
        if ('stretch' === current) {
          fallback = 'space-around';
        }
      }

      this.set(key, fallback);
    })

  });
});
define("cornerstone/components/controls/control-flex-layout/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 6,
                    "column": 6
                  },
                  "end": {
                    "line": 9,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [7, 37], [7, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "row", "label", "Row"], ["loc", [null, [7, 8], [7, 69]]], 0, 0], ["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "choose", ["loc", [null, [8, 37], [8, 43]]], 0, 0, 0, 0]], [], [], 0, 0], "value", "column", "label", "Column"], ["loc", [null, [8, 8], [8, 75]]], 0, 0]],
              locals: ["choose"],
              templates: []
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 10,
                    "column": 6
                  },
                  "end": {
                    "line": 12,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "reverseLayout", ["loc", [null, [11, 32], [11, 45]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Reverse Layout", "wide", true], ["loc", [null, [11, 8], [11, 80]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child2 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 13,
                    "column": 6
                  },
                  "end": {
                    "line": 15,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "wrapChildren", ["loc", [null, [14, 32], [14, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Wrap Children", "wide", true], ["loc", [null, [14, 8], [14, 78]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 16,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(3);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              morphs[2] = dom.createMorphAt(fragment, 2, 2, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "forms/choose-single", [], ["value", ["subexpr", "@mut", [["get", "flexDirection", ["loc", [null, [6, 35], [6, 48]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [6, 6], [9, 30]]]], ["block", "if", [["get", "canReverse", ["loc", [null, [10, 12], [10, 22]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [10, 6], [12, 13]]]], ["block", "if", [["get", "canWrap", ["loc", [null, [13, 12], [13, 19]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [13, 6], [15, 13]]]]],
            locals: [],
            templates: [child0, child1, child2]
          };
        })();
        var child1 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 19,
                    "column": 6
                  },
                  "end": {
                    "line": 21,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "control.keyJustify", ["loc", [null, [20, 36], [20, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "horizontalOptions", ["loc", [null, [20, 63], [20, 80]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [20, 8], [20, 83]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 21,
                    "column": 6
                  },
                  "end": {
                    "line": 23,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "control.keyAlign", ["loc", [null, [22, 36], [22, 52]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "horizontalOptions", ["loc", [null, [22, 61], [22, 78]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [22, 8], [22, 81]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 18,
                  "column": 4
                },
                "end": {
                  "line": 24,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "if", [["get", "isRow", ["loc", [null, [19, 12], [19, 17]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [19, 6], [23, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        var child2 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 27,
                    "column": 6
                  },
                  "end": {
                    "line": 29,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "control.keyAlign", ["loc", [null, [28, 36], [28, 52]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "verticalOptions", ["loc", [null, [28, 61], [28, 76]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [28, 8], [28, 79]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child1 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 29,
                    "column": 6
                  },
                  "end": {
                    "line": 31,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "control.keyJustify", ["loc", [null, [30, 36], [30, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "verticalOptions", ["loc", [null, [30, 63], [30, 78]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [30, 8], [30, 81]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 26,
                  "column": 4
                },
                "end": {
                  "line": 32,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "if", [["get", "isRow", ["loc", [null, [27, 12], [27, 17]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [27, 6], [31, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 34,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(3);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Layout"], 0, null, ["loc", [null, [5, 4], [16, 33]]]], ["block", "controls/input-list-item", [], ["label", "Horizontal"], 1, null, ["loc", [null, [18, 4], [24, 33]]]], ["block", "controls/input-list-item", [], ["label", "Vertical"], 2, null, ["loc", [null, [26, 4], [32, 33]]]]],
          locals: [],
          templates: [child0, child1, child2]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 36,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [34, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 38,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-flex-layout/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [36, 22]]]], ["content", "yield", ["loc", [null, [37, 0], [37, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-flex/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  function composedValue(name) {
    return _ember['default'].computed('value', {
      get: function get() {
        return this.destruct()[name];
      },
      set: function set(key, value) {
        var update = {};
        update[name] = value;
        this.set('value', this.reconstitute(update));
        return value;
      }
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    presetChoices: _ember['default'].A([{
      label: 'Standard',
      value: '0 1 auto'
    }, {
      label: 'No Shrink',
      value: '0 0 auto'
    }, {
      label: 'Fill Space',
      value: '1 0 auto'
    }, {
      label: 'Fill Space Equally',
      value: '1 0 0%'
    }]),

    flexGrow: composedValue('flexGrow'),
    flexShrink: composedValue('flexShrink'),
    flexBasis: composedValue('flexBasis'),

    reconstitute: function reconstitute(updates) {

      var data = this.destruct();

      for (var key in updates) {
        data[key] = updates[key];
      }

      return data.flexGrow + ' ' + data.flexShrink + ' ' + data.flexBasis;
    },

    destruct: function destruct() {

      var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('value', ''));

      return {
        flexGrow: _ember['default'].isPresent(parts[0]) ? parts[0] : '0',
        flexShrink: _ember['default'].isPresent(parts[1]) ? parts[1] : '01',
        flexBasis: _ember['default'].isPresent(parts[2]) ? parts[2] : 'auto'
      };
    },

    init: function init() {
      this._super.apply(this, arguments);
      this.detectMode();
      this.set('mode', _ember['default'].isNone(this.detectMode()) ? 'custom' : 'presets');
      window.tester = this;
    },

    detectMode: function detectMode() {

      var value = this.get('value');
      return this.get('presetChoices').find(function (preset) {
        return preset.value === value;
      });
    }

  });
});
define("cornerstone/components/controls/control-flex/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 7,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [6, 34], [6, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "presetChoices", ["loc", [null, [6, 48], [6, 61]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "Custom"], ["loc", [null, [6, 6], [6, 85]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 8,
                  "column": 4
                },
                "end": {
                  "line": 10,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "flexGrow", ["loc", [null, [9, 20], [9, 28]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [9, 6], [9, 30]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 11,
                  "column": 4
                },
                "end": {
                  "line": 13,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "flexShrink", ["loc", [null, [12, 20], [12, 30]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [12, 6], [12, 32]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 14,
                  "column": 4
                },
                "end": {
                  "line": 16,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "flexBasis", ["loc", [null, [15, 20], [15, 29]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [15, 6], [15, 31]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 18,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(4);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 4, 4, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Preset"], 0, null, ["loc", [null, [5, 4], [7, 33]]]], ["block", "controls/input-list-item", [], ["label", "Flex<br>Grow"], 1, null, ["loc", [null, [8, 4], [10, 33]]]], ["block", "controls/input-list-item", [], ["label", "Flex<br>Shrink"], 2, null, ["loc", [null, [11, 4], [13, 33]]]], ["block", "controls/input-list-item", [], ["label", "Flex<br>Basis"], 3, null, ["loc", [null, [14, 4], [16, 33]]]]],
          locals: [],
          templates: [child0, child1, child2, child3]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 20,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [18, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 22,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-flex/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [20, 22]]]], ["content", "yield", ["loc", [null, [21, 0], [21, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-font-family/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({
    fonts: _ember['default'].inject.service('templates/fonts')
  });
});
define("cornerstone/components/controls/control-font-family/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 8,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-font-family/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [4, 10], [4, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "fonts.fontFamilyOptions", ["loc", [null, [5, 12], [5, 35]]], 0, 0, 0, 0]], [], [], 0, 0], "visibilityObservation", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [6, 26], [6, 34]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [7, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-font-family/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [8, 22]]]], ["content", "yield", ["loc", [null, [9, 0], [9, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-font-weight/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({

    store: _ember['default'].inject.service(),
    fonts: _ember['default'].inject.service('templates/fonts'),

    fontWeightOptions: _ember['default'].computed('control.keyFontFamily', function () {
      var _this = this;

      var selectionID = this.get('control.keyFontFamily');

      var fontSelection = this.get('store').peekAll('templates/fonts/selection').find(function (choice) {
        return selectionID === choice.get('_id');
      });

      if ('inherit' === selectionID) {
        fontSelection = _ember['default'].Object.create({
          _id: 'inherit',
          weights: this.get('fonts.allWeights')
        });
      }

      var weights = _ember['default'].isNone(fontSelection) ? _ember['default'].A() : fontSelection.get('weights');
      var _idPrefix = _ember['default'].isNone(fontSelection) ? '' : fontSelection.get('_id') + ':';
      weights.sort();

      return weights.reduce(function (choices, weight) {
        if (!weight.includes('i')) {
          choices.push({
            value: '' + _idPrefix + weight,
            label: _this.get('i18n').t('app.font-weight.' + weight)
          });
        }
        return choices;
      }, _ember['default'].A());
    }),

    determineNewWeight: _ember['default'].computed(function () {

      var getWeight = (function (val) {
        return this.get('fonts').normalizeWeight(val).split(':')[1];
      }).bind(this);

      return function (newValue, oldValue) {
        return getWeight(newValue) === getWeight(oldValue.value ? oldValue.value : oldValue);
      };
    })

  });
});
define("cornerstone/components/controls/control-font-weight/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 8,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-font-weight/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [4, 10], [4, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "fontWeightOptions", ["loc", [null, [5, 12], [5, 29]]], 0, 0, 0, 0]], [], [], 0, 0], "assignDefaultLocator", ["subexpr", "@mut", [["get", "determineNewWeight", ["loc", [null, [6, 25], [6, 43]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [7, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-font-weight/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [8, 22]]]], ["content", "yield", ["loc", [null, [9, 0], [9, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-gradient/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    gradientState: 'linear-gradient',

    actions: {
      openLG: function openLG() {
        this.set('gradientState', 'linear-gradient');
      },
      openRLG: function openRLG() {
        this.set('gradientState', 'repeating-linear-gradient');
      },
      openRG: function openRG() {
        this.set('gradientState', 'radial-gradient');
      },
      openRRG: function openRRG() {
        this.set('gradientState', 'repeating-radial-gradient');
      }
    }

  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-gradient/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 12,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("ul");
              dom.setAttribute(el1, "class", "cs-choose cs-choose-condensed cols-4");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("li");
              var el3 = dom.createComment("");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1]);
              var element1 = dom.childAt(element0, [1]);
              var element2 = dom.childAt(element0, [3]);
              var element3 = dom.childAt(element0, [5]);
              var element4 = dom.childAt(element0, [7]);
              var morphs = new Array(12);
              morphs[0] = dom.createAttrMorph(element1, 'class');
              morphs[1] = dom.createElementMorph(element1);
              morphs[2] = dom.createMorphAt(element1, 0, 0);
              morphs[3] = dom.createAttrMorph(element2, 'class');
              morphs[4] = dom.createElementMorph(element2);
              morphs[5] = dom.createMorphAt(element2, 0, 0);
              morphs[6] = dom.createAttrMorph(element3, 'class');
              morphs[7] = dom.createElementMorph(element3);
              morphs[8] = dom.createMorphAt(element3, 0, 0);
              morphs[9] = dom.createAttrMorph(element4, 'class');
              morphs[10] = dom.createElementMorph(element4);
              morphs[11] = dom.createMorphAt(element4, 0, 0);
              return morphs;
            },
            statements: [["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "gradientState", ["loc", [null, [7, 28], [7, 41]]], 0, 0, 0, 0], "linear-gradient"], [], ["loc", [null, [7, 24], [7, 60]]], 0, 0], "cs-active"], [], ["loc", [null, [7, 19], [7, 74]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["openLG"], [], ["loc", [null, [7, 76], [7, 95]]], 0, 0], ["inline", "fa-icon", ["minus"], [], ["loc", [null, [7, 96], [7, 115]]], 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "gradientState", ["loc", [null, [8, 28], [8, 41]]], 0, 0, 0, 0], "repeating-linear-gradient"], [], ["loc", [null, [8, 24], [8, 70]]], 0, 0], "cs-active"], [], ["loc", [null, [8, 19], [8, 84]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["openRLG"], [], ["loc", [null, [8, 86], [8, 106]]], 0, 0], ["inline", "fa-icon", ["ellipsis-h"], [], ["loc", [null, [8, 107], [8, 131]]], 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "gradientState", ["loc", [null, [9, 28], [9, 41]]], 0, 0, 0, 0], "radial-gradient"], [], ["loc", [null, [9, 24], [9, 60]]], 0, 0], "cs-active"], [], ["loc", [null, [9, 19], [9, 74]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["openRG"], [], ["loc", [null, [9, 76], [9, 95]]], 0, 0], ["inline", "fa-icon", ["circle-thin"], [], ["loc", [null, [9, 96], [9, 121]]], 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "gradientState", ["loc", [null, [10, 28], [10, 41]]], 0, 0, 0, 0], "repeating-radial-gradient"], [], ["loc", [null, [10, 24], [10, 70]]], 0, 0], "cs-active"], [], ["loc", [null, [10, 19], [10, 84]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["openRRG"], [], ["loc", [null, [10, 86], [10, 106]]], 0, 0], ["inline", "fa-icon", ["bullseye"], [], ["loc", [null, [10, 107], [10, 129]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 14,
                  "column": 4
                },
                "end": {
                  "line": 34,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("select");
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("0deg");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("90deg");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("180deg");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("360deg");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("to top");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("to left");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("to right");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("to bottom");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("to bottom left");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle at top right");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle closest-side");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle closest-corner");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle farthest-side");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("circle farthest-corner");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("ellipsis");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("option");
              var el3 = dom.createTextNode("ellipsis farthest-side at right");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n      ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes() {
              return [];
            },
            statements: [],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 36,
                  "column": 4
                },
                "end": {
                  "line": 38,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["class", "cs-gradient-color", "value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [37, 46], [37, 51]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [37, 6], [37, 53]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 40,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(3);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Type"], 0, null, ["loc", [null, [5, 4], [12, 33]]]], ["block", "controls/input-list-item", [], ["label", "Style"], 1, null, ["loc", [null, [14, 4], [34, 33]]]], ["block", "controls/input-list-item", [], ["label", "Colors"], 2, null, ["loc", [null, [36, 4], [38, 33]]]]],
          locals: [],
          templates: [child0, child1, child2]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 42,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [40, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 44,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-gradient/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [42, 22]]]], ["content", "yield", ["loc", [null, [43, 0], [43, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-group/component', ['exports', 'cornerstone/components/controls/control-base/component'], function (exports, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-group/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-group/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "controls/input-list", [], ["controls", ["subexpr", "@mut", [["get", "control.controls", ["loc", [null, [3, 33], [3, 49]]], 0, 0, 0, 0]], [], [], 0, 0], "parentLevel", ["subexpr", "@mut", [["get", "level", ["loc", [null, [3, 62], [3, 67]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 69]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-group/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-icon/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({
    showAlt: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt'),
    baseOptions: _ember['default'].computed.alias('control.options'),
    altOptions: _ember['default'].computed('baseOptions', function () {
      var options = _ember['default'].merge({}, this.get('baseOptions'));
      if (options.alt_label) {
        options.label = options.alt_label;
      }
      return options;
    })
  });
});
define("cornerstone/components/controls/control-icon/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 6,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-icon/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "forms/icon-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyAlt", ["loc", [null, [5, 30], [5, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "altOptions", ["loc", [null, [5, 53], [5, 63]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [5, 4], [5, 65]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-icon/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["inline", "forms/icon-picker", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 28], [3, 33]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "baseOptions", ["loc", [null, [3, 42], [3, 53]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 55]]], 0, 0], ["block", "if", [["get", "showAlt", ["loc", [null, [4, 8], [4, 15]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [6, 9]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 9,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-icon/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [7, 22]]]], ["content", "yield", ["loc", [null, [8, 0], [8, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-image-source/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-image-source/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-image-source/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/image-upload", [], ["value", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [3, 29], [3, 45]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 47]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-image-source/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-image/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {

  function dimensionPreview(dimensionKey) {

    return _ember['default'].computed(dimensionKey, 'control.keyIsRetina', function () {

      var dim = this.get(dimensionKey);

      if (!dim || isNaN(dim)) {
        return '';
      }

      if (this.get('control.keyIsRetina')) {
        return Math.round(dim / 2); // (dim / 2).toFixed(4).replace(/\.?0+$/,'');
      }

      return dim;
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({
    defaultHeight: 2,

    useWidth: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('width'),
    useHeight: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('height'),
    useImgSource: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('img_source'),
    showLink: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('has_link'),
    showInfo: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('has_info'),
    showRetinaReady: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('is_retina'),
    showAltText: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt_text'),

    showDimensionPreview: _ember['default'].computed('useWidth', 'useHeight', function () {
      return this.get('useWidth') && this.get('useHeight');
    }),

    widthPreview: dimensionPreview('control.keyWidth'),
    heightPreview: dimensionPreview('control.keyHeight'),

    showDisplayFunction: _ember['default'].computed('showLink', 'showInfo', function () {
      return this.get('showLink') || this.get('showInfo');
    }),

    detectedHeight: _ember['default'].computed('showDimensionPreview', 'showAltText', 'showLink', 'showInfo', function () {

      var cols = Math.floor([{
        key: 'showAltText',
        weight: 1
      }, {
        key: 'showLink',
        weight: 0.5
      }, {
        key: 'showInfo',
        weight: 0.5
      }, {
        key: 'showDimensionPreview',
        weight: 1
      }].reduce((function (memo, item) {
        if (this.get(item.key)) {
          memo -= item.weight;
        }
        return memo;
      }).bind(this), 5));

      return cols;
    }),

    altTextPlaceholder: _ember['default'].computed('control.options', function () {
      var placeholder = this.get('control.options.alt_text_placeholder');
      return placeholder ? placeholder : 'Describe Your Image Here';
    }),

    actions: {
      toggleRetinaReady: function toggleRetinaReady() {
        this.set('control.keyIsRetina', !this.get('control.keyIsRetina'));
      },
      dimensionChange: function dimensionChange(_ref) {
        var width = _ref.width;
        var height = _ref.height;

        this.set('control.keyWidth', width ? width : 48);
        this.set('control.keyHeight', height ? height : 48);
      }
    }

  });
});
define("cornerstone/components/controls/control-image/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 4,
                  "column": 4
                },
                "end": {
                  "line": 6,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-image/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/image-upload", [], ["value", ["subexpr", "@mut", [["get", "control.keyImgSource", ["loc", [null, [5, 33], [5, 53]]], 0, 0, 0, 0]], [], [], 0, 0], "onDimensionChange", ["subexpr", "action", ["dimensionChange"], [], ["loc", [null, [5, 72], [5, 98]]], 0, 0]], ["loc", [null, [5, 6], [5, 101]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 6,
                  "column": 4
                },
                "end": {
                  "line": 8,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-image/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/image-upload", [], ["value", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [7, 33], [7, 49]]], 0, 0, 0, 0]], [], [], 0, 0], "onDimensionChange", ["subexpr", "action", ["dimensionChange"], [], ["loc", [null, [7, 68], [7, 94]]], 0, 0]], ["loc", [null, [7, 6], [7, 97]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 9,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-image/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "useImgSource", ["loc", [null, [4, 10], [4, 22]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [4, 4], [8, 11]]]]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      var child1 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 17,
                      "column": 10
                    },
                    "end": {
                      "line": 19,
                      "column": 10
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("            ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("button");
                  var el2 = dom.createComment("");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var element0 = dom.childAt(fragment, [1]);
                  var morphs = new Array(3);
                  morphs[0] = dom.createAttrMorph(element0, 'class');
                  morphs[1] = dom.createElementMorph(element0);
                  morphs[2] = dom.createMorphAt(element0, 0, 0);
                  return morphs;
                },
                statements: [["attribute", "class", ["concat", [["subexpr", "if", [["get", "control.keyIsRetina", ["loc", [null, [18, 32], [18, 51]]], 0, 0, 0, 0], "cs-active"], [], ["loc", [null, [18, 27], [18, 65]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["toggleRetinaReady"], [], ["loc", [null, [18, 67], [18, 97]]], 0, 0], ["inline", "fa-icon", ["eye"], [], ["loc", [null, [18, 98], [18, 115]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 13,
                    "column": 8
                  },
                  "end": {
                    "line": 28,
                    "column": 8
                  }
                },
                "moduleName": "cornerstone/components/controls/control-image/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("div");
                var el2 = dom.createTextNode("\n            ");
                dom.appendChild(el1, el2);
                var el2 = dom.createElement("span");
                var el3 = dom.createTextNode("W");
                dom.appendChild(el2, el3);
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("\n            ");
                dom.appendChild(el1, el2);
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("\n          ");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n          ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("div");
                var el2 = dom.createTextNode("\n            ");
                dom.appendChild(el1, el2);
                var el2 = dom.createElement("span");
                var el3 = dom.createTextNode("H");
                dom.appendChild(el2, el3);
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("\n            ");
                dom.appendChild(el1, el2);
                var el2 = dom.createComment("");
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("\n          ");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(3);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 3, 3);
                morphs[2] = dom.createMorphAt(dom.childAt(fragment, [4]), 3, 3);
                dom.insertBoundary(fragment, 0);
                return morphs;
              },
              statements: [["block", "if", [["get", "showRetinaReady", ["loc", [null, [17, 16], [17, 31]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [17, 10], [19, 17]]]], ["inline", "input", [], ["disabled", true, "value", ["subexpr", "@mut", [["get", "widthPreview", ["loc", [null, [22, 40], [22, 52]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [22, 12], [22, 54]]], 0, 0], ["inline", "input", [], ["disabled", true, "value", ["subexpr", "@mut", [["get", "heightPreview", ["loc", [null, [26, 40], [26, 53]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [26, 12], [26, 55]]], 0, 0]],
              locals: [],
              templates: [child0]
            };
          })();
          var child1 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 32,
                      "column": 8
                    },
                    "end": {
                      "line": 34,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "forms/image-upload", [], ["value", ["subexpr", "@mut", [["get", "control.keyImgSource", ["loc", [null, [33, 37], [33, 57]]], 0, 0, 0, 0]], [], [], 0, 0], "onDimensionChange", ["subexpr", "action", ["dimensionChange"], [], ["loc", [null, [33, 76], [33, 102]]], 0, 0]], ["loc", [null, [33, 10], [33, 105]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            var child1 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 34,
                      "column": 8
                    },
                    "end": {
                      "line": 36,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "forms/image-upload", [], ["value", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [35, 37], [35, 53]]], 0, 0, 0, 0]], [], [], 0, 0], "onDimensionChange", ["subexpr", "action", ["dimensionChange"], [], ["loc", [null, [35, 72], [35, 98]]], 0, 0]], ["loc", [null, [35, 10], [35, 101]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 31,
                    "column": 6
                  },
                  "end": {
                    "line": 37,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-image/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "if", [["get", "useImgSource", ["loc", [null, [32, 14], [32, 26]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [32, 8], [36, 15]]]]],
              locals: [],
              templates: [child0, child1]
            };
          })();
          var child2 = (function () {
            var child0 = (function () {
              var child0 = (function () {
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 41,
                        "column": 10
                      },
                      "end": {
                        "line": 43,
                        "column": 10
                      }
                    },
                    "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createTextNode("            ");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createComment("");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createTextNode("\n");
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                    return morphs;
                  },
                  statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "control.keyHasLink", ["loc", [null, [42, 36], [42, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Link", "half", true], ["loc", [null, [42, 12], [42, 79]]], 0, 0]],
                  locals: [],
                  templates: []
                };
              })();
              var child1 = (function () {
                return {
                  meta: {
                    "revision": "Ember@2.8.0",
                    "loc": {
                      "source": null,
                      "start": {
                        "line": 44,
                        "column": 10
                      },
                      "end": {
                        "line": 46,
                        "column": 10
                      }
                    },
                    "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                  },
                  isEmpty: false,
                  arity: 0,
                  cachedFragment: null,
                  hasRendered: false,
                  buildFragment: function buildFragment(dom) {
                    var el0 = dom.createDocumentFragment();
                    var el1 = dom.createTextNode("            ");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createComment("");
                    dom.appendChild(el0, el1);
                    var el1 = dom.createTextNode("\n");
                    dom.appendChild(el0, el1);
                    return el0;
                  },
                  buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                    var morphs = new Array(1);
                    morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                    return morphs;
                  },
                  statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "control.keyHasInfo", ["loc", [null, [45, 36], [45, 54]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "Info", "half", true], ["loc", [null, [45, 12], [45, 79]]], 0, 0]],
                  locals: [],
                  templates: []
                };
              })();
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 40,
                      "column": 8
                    },
                    "end": {
                      "line": 50,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(2);
                  morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                  morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  dom.insertBoundary(fragment, 0);
                  dom.insertBoundary(fragment, null);
                  return morphs;
                },
                statements: [["block", "if", [["get", "showLink", ["loc", [null, [41, 16], [41, 24]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [41, 10], [43, 17]]]], ["block", "if", [["get", "showInfo", ["loc", [null, [44, 16], [44, 24]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [44, 10], [46, 17]]]]],
                locals: [],
                templates: [child0, child1]
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 39,
                    "column": 6
                  },
                  "end": {
                    "line": 51,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-image/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], [], 0, null, ["loc", [null, [40, 8], [50, 37]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          var child3 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 54,
                      "column": 8
                    },
                    "end": {
                      "line": 56,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-image/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "input", [], ["type", "text", "placeholder", ["subexpr", "@mut", [["get", "altTextPlaceholder", ["loc", [null, [55, 42], [55, 60]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "control.keyAltText", ["loc", [null, [55, 67], [55, 85]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [55, 10], [55, 87]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 53,
                    "column": 6
                  },
                  "end": {
                    "line": 57,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-image/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "controls/input-list-item", [], ["label", "Alt Text"], 0, null, ["loc", [null, [54, 8], [56, 37]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 10,
                  "column": 4
                },
                "end": {
                  "line": 59,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-image/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(4);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
              morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
              morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
              return morphs;
            },
            statements: [["block", "controls/input-list-item", [], ["label", ["subexpr", "if", [["get", "showRetinaReady", ["loc", [null, [14, 20], [14, 35]]], 0, 0, 0, 0], "Retina & Dimensions", "Dimensions Preview"], [], ["loc", [null, [14, 16], [14, 80]]], 0, 0], "class", "cs-input-list-image-dimensions"], 0, null, ["loc", [null, [13, 8], [28, 37]]]], ["block", "controls/input-list-item", [], ["label", "Source", "defaultHeight", ["subexpr", "@mut", [["get", "detectedHeight", ["loc", [null, [31, 63], [31, 77]]], 0, 0, 0, 0]], [], [], 0, 0]], 1, null, ["loc", [null, [31, 6], [37, 35]]]], ["block", "if", [["get", "showDisplayFunction", ["loc", [null, [39, 12], [39, 31]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [39, 6], [51, 13]]]], ["block", "if", [["get", "showAltText", ["loc", [null, [53, 12], [53, 23]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [53, 6], [57, 13]]]]],
            locals: [],
            templates: [child0, child1, child2, child3]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 9,
                "column": 2
              },
              "end": {
                "line": 60,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-image/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [10, 4], [59, 28]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 62,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-image/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "unless", [["get", "firstLevel", ["loc", [null, [3, 12], [3, 22]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [3, 2], [60, 13]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 64,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-image/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [62, 22]]]], ["content", "yield", ["loc", [null, [63, 0], [63, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-link/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    // Cache old URL, update preview immediately
    typeChoices: [{ value: 'url', icon: 'link', tooltip: 'URL' }, { value: 'email', icon: 'envelope', tooltip: 'Email' }, { value: 'tel', icon: 'phone', tooltip: 'Phone' }],

    showContent: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('content'),
    showNewTab: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('new_tab'),
    showNofollow: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('nofollow'),

    showURL: _ember['default'].computed.equal('linkType', 'url'),
    showEmail: _ember['default'].computed.equal('linkType', 'email'),
    showPhone: _ember['default'].computed.equal('linkType', 'tel'),

    linkPreview: _ember['default'].computed('control.keyUrl', 'linkType', function () {
      switch (this.get('linkType')) {
        case 'email':
          {
            var subject = this.get('emailSubject');
            subject = subject ? '?subject=' + encodeURI(subject) : '';
            return 'mailto:' + this.get('emailAddress') + subject;
          }
        case 'tel':
          {
            return 'tel:' + encodeURI(this.get('phoneNumber'));
          }
      }

      return this.get('control.keyUrl');
    }),

    linkType: _ember['default'].computed('control.keyUrl', {
      get: function get() {

        var current = this.get('control.keyUrl') || '';

        if (current.match(/mailto:/)) {
          return 'email';
        }

        if (current.match(/tel:/)) {
          return 'tel';
        }

        return 'url';
      },
      set: function set(key, value) {
        return value;
      }
    }),

    emailAddress: _ember['default'].computed('control.keyUrl', {
      get: function get() {

        var current = this.get('control.keyUrl') || '';

        if (!current.match(/mailto:/)) {
          return '';
        }

        return current.replace(/mailto:(?:\/\/)?/g, '').replace(/\?.*/g, '');
      },
      set: function set(key, value) {
        var subject = this.get('emailSubject');
        subject = subject ? '?subject=' + encodeURI(subject) : '';
        value = value.replace(/mailto:(?:\/\/)?/g, '').replace(/\?.*/g, '');
        this.set('control.keyUrl', 'mailto:' + value + subject);

        return value;
      }
    }),

    emailSubject: _ember['default'].computed('control.keyUrl', {
      get: function get() {
        var current = this.get('control.keyUrl') || '';

        if (!current.match(/mailto:/)) {
          return '';
        }

        var matches = current.match(/\?subject=(.*)/) || '';
        if (!matches && !matches[1]) {
          return '';
        }
        return decodeURI(matches[1]);
      },
      set: function set(key, value) {

        var mailto = (this.get('control.keyUrl') || '').replace(/\?.*/g, '');
        var subject = value.length > 0 ? '?subject=' + encodeURI(value) : '';

        this.set('control.keyUrl', '' + mailto + subject);

        return value;
      }
    }),

    phoneNumber: _ember['default'].computed('control.keyUrl', {
      get: function get() {
        var current = this.get('control.keyUrl') || '';
        if (!current.match(/tel:/)) {
          return '';
        }
        return decodeURI(current.replace(/tel:(?:\/\/)?/g, ''));
      },
      set: function set(key, value) {
        this.set('control.keyUrl', '' === value ? '' : 'tel:' + encodeURI(value));
        return value;
      }
    })

  });
});
define("cornerstone/components/controls/control-link/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 7,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "linkPreview", ["loc", [null, [6, 20], [6, 31]]], 0, 0, 0, 0]], [], [], 0, 0], "disabled", "true"], ["loc", [null, [6, 6], [6, 49]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 9,
                  "column": 4
                },
                "end": {
                  "line": 11,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/choose-single", [], ["choices", ["subexpr", "@mut", [["get", "typeChoices", ["loc", [null, [10, 36], [10, 47]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "linkType", ["loc", [null, [10, 54], [10, 62]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [10, 6], [10, 64]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 13,
                  "column": 4
                },
                "end": {
                  "line": 15,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "control.keyContent", ["loc", [null, [14, 20], [14, 38]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [14, 6], [14, 40]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 19,
                    "column": 6
                  },
                  "end": {
                    "line": 21,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-link/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "control.keyNewTab", ["loc", [null, [20, 32], [20, 49]]], 0, 0, 0, 0]], [], [], 0, 0], "label", "New Tab", "half", true], ["loc", [null, [20, 8], [20, 77]]], 0, 0]],
              locals: [],
              templates: []
            };
          })();
          var child1 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 23,
                      "column": 8
                    },
                    "end": {
                      "line": 25,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-link/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createElement("code");
                  var el2 = dom.createTextNode("nofollow");
                  dom.appendChild(el1, el2);
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes() {
                  return [];
                },
                statements: [],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 22,
                    "column": 6
                  },
                  "end": {
                    "line": 26,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-link/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
                dom.insertBoundary(fragment, 0);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["block", "forms/rc-choice", [], ["value", ["subexpr", "@mut", [["get", "control.keyNofollow", ["loc", [null, [23, 33], [23, 52]]], 0, 0, 0, 0]], [], [], 0, 0], "half", true], 0, null, ["loc", [null, [23, 8], [25, 28]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 17,
                  "column": 4
                },
                "end": {
                  "line": 27,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(3);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
              morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "control.keyUrl", ["loc", [null, [18, 20], [18, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "e.g. http://theme.co/"], ["loc", [null, [18, 6], [18, 72]]], 0, 0], ["block", "if", [["get", "showNewTab", ["loc", [null, [19, 12], [19, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [19, 6], [21, 13]]]], ["block", "if", [["get", "showNofollow", ["loc", [null, [22, 12], [22, 24]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [22, 6], [26, 13]]]]],
            locals: [],
            templates: [child0, child1]
          };
        })();
        var child4 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 29,
                  "column": 4
                },
                "end": {
                  "line": 31,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "emailAddress", ["loc", [null, [30, 20], [30, 32]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "e.g. hello@example.com"], ["loc", [null, [30, 6], [30, 71]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child5 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 33,
                  "column": 4
                },
                "end": {
                  "line": 35,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "emailSubject", ["loc", [null, [34, 20], [34, 32]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "e.g. Howdy!"], ["loc", [null, [34, 6], [34, 60]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child6 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 37,
                  "column": 4
                },
                "end": {
                  "line": 39,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-link/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "phoneNumber", ["loc", [null, [38, 20], [38, 31]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "e.g. 18885551234"], ["loc", [null, [38, 6], [38, 64]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 41,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-link/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(7);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
            morphs[4] = dom.createMorphAt(fragment, 9, 9, contextualElement);
            morphs[5] = dom.createMorphAt(fragment, 11, 11, contextualElement);
            morphs[6] = dom.createMorphAt(fragment, 13, 13, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "Preview"], 0, null, ["loc", [null, [5, 4], [7, 33]]]], ["block", "controls/input-list-item", [], ["label", "Type"], 1, null, ["loc", [null, [9, 4], [11, 33]]]], ["block", "controls/input-list-item", [], ["label", "Content", "isVisible", ["subexpr", "@mut", [["get", "showContent", ["loc", [null, [13, 58], [13, 69]]], 0, 0, 0, 0]], [], [], 0, 0]], 2, null, ["loc", [null, [13, 4], [15, 33]]]], ["block", "controls/input-list-item", [], ["label", "URL", "isVisible", ["subexpr", "@mut", [["get", "showURL", ["loc", [null, [17, 54], [17, 61]]], 0, 0, 0, 0]], [], [], 0, 0]], 3, null, ["loc", [null, [17, 4], [27, 33]]]], ["block", "controls/input-list-item", [], ["label", "Email", "isVisible", ["subexpr", "@mut", [["get", "showEmail", ["loc", [null, [29, 56], [29, 65]]], 0, 0, 0, 0]], [], [], 0, 0]], 4, null, ["loc", [null, [29, 4], [31, 33]]]], ["block", "controls/input-list-item", [], ["label", "Subject", "isVisible", ["subexpr", "@mut", [["get", "showEmail", ["loc", [null, [33, 58], [33, 67]]], 0, 0, 0, 0]], [], [], 0, 0]], 5, null, ["loc", [null, [33, 4], [35, 33]]]], ["block", "controls/input-list-item", [], ["label", "Phone", "isVisible", ["subexpr", "@mut", [["get", "showPhone", ["loc", [null, [37, 56], [37, 65]]], 0, 0, 0, 0]], [], [], 0, 0]], 6, null, ["loc", [null, [37, 4], [39, 33]]]]],
          locals: [],
          templates: [child0, child1, child2, child3, child4, child5, child6]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 43,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-link/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [41, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 45,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-link/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [43, 22]]]], ["content", "yield", ["loc", [null, [44, 0], [44, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-number/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-number/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-number/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 16], [3, 21]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [3, 34], [3, 45]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 47]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-number/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-ratio/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {
    classNameBindings: ['monospace:cs-monospace-input']
  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-ratio/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-ratio/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/ratio-input", [], ["value", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [3, 28], [3, 44]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [3, 57], [3, 68]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 70]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-ratio/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-select/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({

    service: _ember['default'].inject.service('controls'),
    store: _ember['default'].inject.service(),

    choices: _ember['default'].computed('control.choices.[]', 'control.options.choices.[]', function () {

      var choices = this.getWithDefault('control.choices', this.getWithDefault('control.options.choices', _ember['default'].A()));

      if ('list:fonts' === choices) {
        return this.get('service').getOptionList('fonts');
      }

      if ('list:font-weights' === choices) {
        return this.get('service').getOptionList('font-weights');
      }

      if ('string' === typeof choices && 0 === choices.indexOf('dynamic:')) {
        return choices.replace('dynamic:', '');
      }

      return _ember['default'].isArray(choices) ? choices : _ember['default'].A();
    })

  });
});
define("cornerstone/components/controls/control-select/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-select/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/styled-select", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 30], [3, 35]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "choices", ["loc", [null, [3, 44], [3, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "visibilityObservation", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [3, 74], [3, 82]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 85]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-select/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-sortable/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({
    store: _ember['default'].inject.service(),

    addLabel: _ember['default'].computed('childType', function () {
      var label = '';
      var definition = this.get('store').peekRecord('element/definition', this.get('childType'));
      if (definition) {
        label = definition.getWithDefault('title', '');
      }
      return this.get('i18n').t('app.add-label', { label: label }).string;
    }),

    childType: _ember['default'].computed('control.options.element', function () {
      return this.getWithDefault('control.options.element', 'undefined');
    }),

    capacity: _ember['default'].computed('control.options.capacity', function () {
      return this.getWithDefault('control.options.capacity', 100);
    }),

    floor: _ember['default'].computed('control.options.floor', function () {
      return this.getWithDefault('control.options.floor', 0);
    }),

    canAdd: _ember['default'].computed('control.source.availableChildren.length', 'capacity', function () {
      return this.get('control.source.availableChildren.length') < this.get('capacity');
    }),

    canDelete: _ember['default'].computed('control.source.availableChildren.length', 'floor', function () {
      return this.get('control.source.availableChildren.length') > this.get('floor');
    }),

    orderSort: ['order'],
    sortedElements: _ember['default'].computed.sort('control.source.availableChildren', 'orderSort'),

    actions: {
      tryDelete: function tryDelete() {
        this.get('ui').notify('This element requires a minimum number of children.');
      },
      tryDuplicate: function tryDuplicate() {
        this.get('ui').notify('This element already has the maximum number of children.');
      }
    }
  });
});
define("cornerstone/components/controls/control-sortable/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 6,
                    "column": 6
                  },
                  "end": {
                    "line": 21,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-sortable/template.hbs"
              },
              isEmpty: false,
              arity: 1,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(1);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                return morphs;
              },
              statements: [["inline", "common/sortable-item", [], ["label", ["subexpr", "@mut", [["get", "element.indexedTitle", ["loc", [null, [8, 16], [8, 36]]], 0, 0, 0, 0]], [], [], 0, 0], "item", ["subexpr", "@mut", [["get", "element", ["loc", [null, [9, 15], [9, 22]]], 0, 0, 0, 0]], [], [], 0, 0], "showAddAfter", ["subexpr", "if", [["get", "canAdd", ["loc", [null, [10, 27], [10, 33]]], 0, 0, 0, 0], ["subexpr", "eq", [["get", "element.id", ["loc", [null, [10, 38], [10, 48]]], 0, 0, 0, 0], ["get", "sortedElements.lastObject.id", ["loc", [null, [10, 49], [10, 77]]], 0, 0, 0, 0]], [], ["loc", [null, [10, 34], [10, 78]]], 0, 0], false], [], ["loc", [null, [10, 23], [10, 86]]], 0, 0], "onInspect", ["subexpr", "route-action", ["inspectElement", ["get", "element", ["loc", [null, [11, 51], [11, 58]]], 0, 0, 0, 0]], [], ["loc", [null, [11, 20], [11, 60]]], 0, 0], "onDrop", ["subexpr", "route-action", ["moveElement"], [], ["loc", [null, [12, 17], [12, 46]]], 0, 0], "addLabel", ["subexpr", "@mut", [["get", "addLabel", ["loc", [null, [13, 19], [13, 27]]], 0, 0, 0, 0]], [], [], 0, 0], "onAddBefore", ["subexpr", "if", [["get", "canAdd", ["loc", [null, [14, 26], [14, 32]]], 0, 0, 0, 0], ["subexpr", "route-action", ["addSiblingElement", ["get", "element", ["loc", [null, [14, 67], [14, 74]]], 0, 0, 0, 0], ["subexpr", "hash", [], ["_type", ["get", "childType", ["loc", [null, [14, 87], [14, 96]]], 0, 0, 0, 0]], ["loc", [null, [14, 75], [14, 97]]], 0, 0], false, ["subexpr", "hash", [], ["indexedTitle", true], ["loc", [null, [14, 104], [14, 128]]], 0, 0]], [], ["loc", [null, [14, 33], [14, 129]]], 0, 0], false], [], ["loc", [null, [14, 22], [14, 136]]], 0, 0], "onAddAfter", ["subexpr", "if", [["get", "canAdd", ["loc", [null, [15, 25], [15, 31]]], 0, 0, 0, 0], ["subexpr", "route-action", ["addSiblingElement", ["get", "element", ["loc", [null, [15, 66], [15, 73]]], 0, 0, 0, 0], ["subexpr", "hash", [], ["_type", ["get", "childType", ["loc", [null, [15, 86], [15, 95]]], 0, 0, 0, 0]], ["loc", [null, [15, 74], [15, 96]]], 0, 0], true, ["subexpr", "hash", [], ["indexedTitle", true], ["loc", [null, [15, 102], [15, 126]]], 0, 0]], [], ["loc", [null, [15, 32], [15, 127]]], 0, 0], false], [], ["loc", [null, [15, 21], [15, 134]]], 0, 0], "onDuplicate", ["subexpr", "if", [["get", "canAdd", ["loc", [null, [16, 26], [16, 32]]], 0, 0, 0, 0], ["subexpr", "route-action", ["duplicateElement", ["get", "element", ["loc", [null, [16, 66], [16, 73]]], 0, 0, 0, 0]], [], ["loc", [null, [16, 33], [16, 74]]], 0, 0], ["subexpr", "action", ["tryDuplicate"], [], ["loc", [null, [16, 75], [16, 98]]], 0, 0]], [], ["loc", [null, [16, 22], [16, 100]]], 0, 0], "onDelete", ["subexpr", "if", [["get", "canDelete", ["loc", [null, [17, 23], [17, 32]]], 0, 0, 0, 0], ["subexpr", "route-action", ["deleteElement", ["get", "element", ["loc", [null, [17, 63], [17, 70]]], 0, 0, 0, 0]], [], ["loc", [null, [17, 33], [17, 71]]], 0, 0], ["subexpr", "action", ["tryDelete"], [], ["loc", [null, [17, 72], [17, 92]]], 0, 0]], [], ["loc", [null, [17, 19], [17, 94]]], 0, 0], "onMouseEnter", ["subexpr", "route-action", ["observeStart", ["get", "element", ["loc", [null, [18, 52], [18, 59]]], 0, 0, 0, 0]], [], ["loc", [null, [18, 23], [18, 60]]], 0, 0], "onMouseLeave", ["subexpr", "route-action", ["observeEnd", ["get", "element", ["loc", [null, [19, 50], [19, 57]]], 0, 0, 0, 0]], [], ["loc", [null, [19, 23], [19, 58]]], 0, 0]], ["loc", [null, [7, 8], [20, 10]]], 0, 0]],
              locals: ["element"],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 22,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-sortable/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "each", [["get", "sortedElements", ["loc", [null, [6, 14], [6, 28]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [6, 6], [21, 15]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 23,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-sortable/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "common/sortable-container", [], [], 0, null, ["loc", [null, [5, 4], [22, 34]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      var child1 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 24,
                  "column": 4
                },
                "end": {
                  "line": 30,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-sortable/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "workspace/workspace-full-button", [], ["action", ["subexpr", "route-action", ["addElement", ["get", "control.source", ["loc", [null, [26, 42], [26, 56]]], 0, 0, 0, 0], ["subexpr", "hash", [], ["_type", ["get", "childType", ["loc", [null, [26, 69], [26, 78]]], 0, 0, 0, 0]], ["loc", [null, [26, 57], [26, 79]]], 0, 0], ["subexpr", "hash", [], ["indexedTitle", true], ["loc", [null, [26, 80], [26, 104]]], 0, 0]], [], ["loc", [null, [26, 15], [26, 105]]], 0, 0], "icon", ["subexpr", "icon", ["plus-square"], [], ["loc", [null, [27, 13], [27, 33]]], 0, 0], "message", ["subexpr", "@mut", [["get", "addLabel", ["loc", [null, [28, 16], [28, 24]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [25, 6], [29, 8]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 23,
                "column": 2
              },
              "end": {
                "line": 31,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-sortable/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "canAdd", ["loc", [null, [24, 10], [24, 16]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [24, 4], [30, 11]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 33,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-sortable/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["block", "if", [["get", "sortedElements", ["loc", [null, [4, 8], [4, 22]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [4, 2], [31, 9]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 35,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-sortable/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [33, 22]]]], ["content", "yield", ["loc", [null, [34, 0], [34, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-text-editor/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-text-editor/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 8,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-text-editor/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/expandable-text-editor", [], ["placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [4, 16], [4, 27]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [5, 10], [5, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "mode", ["subexpr", "@mut", [["get", "control.options.mode", ["loc", [null, [6, 9], [6, 29]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [7, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-text-editor/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [8, 22]]]], ["content", "yield", ["loc", [null, [9, 0], [9, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-text-shadow/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder', 'cornerstone/util/split-on-whitespace'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder, _cornerstoneUtilSplitOnWhitespace) {

  function composedValue(name) {
    return _ember['default'].computed('value', {
      get: function get() {
        return this.destruct()[name];
      },
      set: function set(key, value) {
        var update = {};
        update[name] = value;
        this.set('value', this.reconstitute(update));
        return value;
      }
    });
  }

  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {

    reconstitute: function reconstitute(updates) {

      var data = this.destruct();

      for (var key in updates) {
        data[key] = updates[key];
      }

      return data.xOffset + ' ' + data.yOffset + ' ' + data.blur;
    },

    destruct: function destruct() {

      var parts = (0, _cornerstoneUtilSplitOnWhitespace['default'])(this.getWithDefault('value', ''));

      var data = {
        xOffset: _ember['default'].isPresent(parts[0]) ? parts[0] : '0px',
        yOffset: _ember['default'].isPresent(parts[1]) ? parts[1] : '0px',
        blur: _ember['default'].isPresent(parts[2]) ? parts[2] : '0px'
      };

      return data;
    },

    xOffset: composedValue('xOffset'),
    yOffset: composedValue('yOffset'),
    blur: composedValue('blur'),
    showColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('color'),
    showAltColor: _cornerstoneComponentsControlsControlBaseComponent['default'].isKeyMapped('alt_color'),

    xOffsetOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('x_offset', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: -50, max: 50, step: 1 },
        em: { min: -1, max: 1, step: 0.001 },
        rem: { min: -1, max: 1, step: 0.001 }
      }
    }),

    yOffsetOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('y_offset', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: -50, max: 50, step: 1 },
        em: { min: -1, max: 1, step: 0.001 },
        rem: { min: -1, max: 1, step: 0.001 }
      }
    }),

    blurOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('blur', {
      available_units: ['px', 'em', 'rem'],
      ranges: {
        px: { min: 0, max: 50, step: 1 },
        em: { min: 0, max: 2.5, step: 0.001 },
        rem: { min: 0, max: 2.5, step: 0.001 }
      }
    }),

    colorOptions: _cornerstoneComponentsControlsControlBaseComponent['default'].subOptions('color'),
    altColorOptions: _ember['default'].computed('colorOptions', function () {
      var options = _ember['default'].copy(this.get('colorOptions'));
      if (options.alt_label) {
        options.label = options.alt_label;
      }
      return options;
    })
  });
});
define("cornerstone/components/controls/control-text-shadow/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 7,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "xOffset", ["loc", [null, [6, 32], [6, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "xOffsetOptions", ["loc", [null, [6, 48], [6, 62]]], 0, 0, 0, 0]], [], [], 0, 0], "debug", true], ["loc", [null, [6, 6], [6, 75]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 9,
                  "column": 4
                },
                "end": {
                  "line": 11,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "yOffset", ["loc", [null, [10, 32], [10, 39]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "yOffsetOptions", ["loc", [null, [10, 48], [10, 62]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [10, 6], [10, 65]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child2 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 13,
                  "column": 4
                },
                "end": {
                  "line": 15,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "blur", ["loc", [null, [14, 32], [14, 36]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "blurOptions", ["loc", [null, [14, 45], [14, 56]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [14, 6], [14, 58]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child3 = (function () {
          var child0 = (function () {
            var child0 = (function () {
              return {
                meta: {
                  "revision": "Ember@2.8.0",
                  "loc": {
                    "source": null,
                    "start": {
                      "line": 20,
                      "column": 8
                    },
                    "end": {
                      "line": 22,
                      "column": 8
                    }
                  },
                  "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
                },
                isEmpty: false,
                arity: 0,
                cachedFragment: null,
                hasRendered: false,
                buildFragment: function buildFragment(dom) {
                  var el0 = dom.createDocumentFragment();
                  var el1 = dom.createTextNode("          ");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createComment("");
                  dom.appendChild(el0, el1);
                  var el1 = dom.createTextNode("\n");
                  dom.appendChild(el0, el1);
                  return el0;
                },
                buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                  var morphs = new Array(1);
                  morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                  return morphs;
                },
                statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyAltColor", ["loc", [null, [21, 37], [21, 56]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "altColorOptions", ["loc", [null, [21, 65], [21, 80]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [21, 10], [21, 82]]], 0, 0]],
                locals: [],
                templates: []
              };
            })();
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 18,
                    "column": 6
                  },
                  "end": {
                    "line": 23,
                    "column": 6
                  }
                },
                "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                var el1 = dom.createComment("");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
                var morphs = new Array(2);
                morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
                morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
                dom.insertBoundary(fragment, null);
                return morphs;
              },
              statements: [["inline", "forms/color-picker", [], ["value", ["subexpr", "@mut", [["get", "control.keyColor", ["loc", [null, [19, 35], [19, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "colorOptions", ["loc", [null, [19, 60], [19, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [19, 8], [19, 74]]], 0, 0], ["block", "if", [["get", "showAltColor", ["loc", [null, [20, 14], [20, 26]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [20, 8], [22, 15]]]]],
              locals: [],
              templates: [child0]
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 17,
                  "column": 4
                },
                "end": {
                  "line": 24,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "controls/input-list-item", [], ["label", "Color"], 0, null, ["loc", [null, [18, 6], [23, 35]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 2
              },
              "end": {
                "line": 26,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(4);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
            morphs[3] = dom.createMorphAt(fragment, 7, 7, contextualElement);
            return morphs;
          },
          statements: [["block", "controls/input-list-item", [], ["label", "X-Offset"], 0, null, ["loc", [null, [5, 4], [7, 33]]]], ["block", "controls/input-list-item", [], ["label", "Y-Offset"], 1, null, ["loc", [null, [9, 4], [11, 33]]]], ["block", "controls/input-list-item", [], ["label", "Blur"], 2, null, ["loc", [null, [13, 4], [15, 33]]]], ["block", "if", [["get", "showColor", ["loc", [null, [17, 10], [17, 19]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [17, 4], [24, 11]]]]],
          locals: [],
          templates: [child0, child1, child2, child3]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 27,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "controls/input-list", [], [], 0, null, ["loc", [null, [3, 2], [26, 26]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 29,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-text-shadow/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [27, 22]]]], ["content", "yield", ["loc", [null, [28, 0], [28, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-text/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {
    classNameBindings: ['monospace:cs-monospace-input']
  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-text/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-text/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "control.keyValue", ["loc", [null, [3, 16], [3, 32]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [3, 45], [3, 56]]], 0, 0, 0, 0]], [], [], 0, 0], "class", ["subexpr", "if", [["get", "control.options.monospace", ["loc", [null, [3, 67], [3, 92]]], 0, 0, 0, 0], "cs-input-code"], [], ["loc", [null, [3, 63], [3, 109]]], 0, 0]], ["loc", [null, [3, 2], [3, 111]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/control-text/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-textarea/component', ['exports', 'cornerstone/components/controls/control-base/component', 'cornerstone/mixins/controls/placeholder'], function (exports, _cornerstoneComponentsControlsControlBaseComponent, _cornerstoneMixinsControlsPlaceholder) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend(_cornerstoneMixinsControlsPlaceholder['default'], {
    classNameBindings: ['monospace:cs-monospace-input'],
    defaultHeight: 5
  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-textarea/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-textarea/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "textarea", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 19], [3, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholder", ["loc", [null, [3, 37], [3, 48]]], 0, 0, 0, 0]], [], [], 0, 0], "class", ["subexpr", "if", [["get", "control.options.monospace", ["loc", [null, [3, 59], [3, 84]]], 0, 0, 0, 0], "cs-input-code"], [], ["loc", [null, [3, 55], [3, 101]]], 0, 0]], ["loc", [null, [3, 2], [3, 103]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/controls/control-textarea/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-toggle/component', ['exports', 'ember', 'cornerstone/components/controls/control-base/component'], function (exports, _ember, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({

    state: _ember['default'].computed('value', function () {
      return this.normalize(this.get('value'));
    }),

    toggleStateClass: _ember['default'].computed('state', function () {
      return this.get('state') ? 'on' : 'off';
    }),

    // Detect various forms of boolean storage and play along

    normalize: function normalize(value) {

      if ('1' === value || 'true' === value) {
        return true;
      }

      if ('' === value || 'false' === value) {
        return false;
      }

      return !!value;
    },

    invert: function invert(value) {

      if ('true' === value) {
        return 'false';
      }

      if ('false' === value) {
        return 'true';
      }

      if ('1' === value) {
        return '';
      }

      if ('' === value) {
        return '1';
      }

      return !value;
    },

    actions: {
      toggle: function toggle() {
        this.set('value', this.invert(this.get('value')));
      }
    }
  });
});
define("cornerstone/components/controls/control-toggle/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-toggle/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/cs-toggle", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 26], [3, 31]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 33]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/controls/control-toggle/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-unit-slider/component', ['exports', 'cornerstone/components/controls/control-base/component'], function (exports, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-unit-slider/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-unit-slider/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/unit-slider", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [3, 28], [3, 33]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "control.options", ["loc", [null, [3, 42], [3, 57]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [3, 59]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 5,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/controls/control-unit-slider/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [4, 22]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/control-unit/component', ['exports', 'cornerstone/components/controls/control-base/component'], function (exports, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({});
});
// import Ember from 'ember';
define("cornerstone/components/controls/control-unit/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/control-unit/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/unit-input", [], ["value", ["subexpr", "@mut", [["get", "value", ["loc", [null, [4, 10], [4, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "options", ["subexpr", "@mut", [["get", "control.options", ["loc", [null, [5, 12], [5, 27]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 2], [6, 4]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 8,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/controls/control-unit/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["block", "common/defer-view", [], ["class", ["subexpr", "@mut", [["get", "containerClass", ["loc", [null, [2, 27], [2, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "defer", ["subexpr", "@mut", [["get", "firstLevel", ["loc", [null, [2, 48], [2, 58]]], 0, 0, 0, 0]], [], [], 0, 0], "hide", ["subexpr", "@mut", [["get", "isHidden", ["loc", [null, [2, 64], [2, 72]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [2, 0], [7, 22]]]], ["content", "yield", ["loc", [null, [8, 0], [8, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/controls/input-list-item/component', ['exports', 'cornerstone/components/controls/control-base/component'], function (exports, _cornerstoneComponentsControlsControlBaseComponent) {
  exports['default'] = _cornerstoneComponentsControlsControlBaseComponent['default'].extend({
    level: 2,
    tagName: 'li',
    control: {
      type: 'aggregate'
    }
  });
});
// import Ember from 'ember';
define("cornerstone/components/controls/input-list-item/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/input-list-item/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [2]);
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createAttrMorph(element0, 'class');
        morphs[2] = dom.createMorphAt(element0, 0, 0);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "partial", [["get", "headerTemplate", ["loc", [null, [1, 10], [1, 24]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 26]]], 0, 0], ["attribute", "class", ["concat", [["get", "containerClass", ["loc", [null, [2, 14], [2, 28]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "yield", ["loc", [null, [2, 32], [2, 41]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/controls/input-list/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'ul',
    classNames: ['cs-control-input-list'],

    level: _ember['default'].computed('parentLevel', function () {
      return this.getWithDefault('parentLevel', 1) + 1;
    })
  });
});
define("cornerstone/components/controls/input-list/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/input-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 6,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/controls/input-list/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "component", [["subexpr", "locate-component", [["subexpr", "concat", ["controls/control-", ["get", "control.type", ["loc", [null, [5, 62], [5, 74]]], 0, 0, 0, 0]], [], ["loc", [null, [5, 34], [5, 76]]], 0, 0], "controls/input-list-item"], [], ["loc", [null, [5, 16], [5, 104]]], 0, 0]], ["control", ["subexpr", "@mut", [["get", "control", ["loc", [null, [5, 113], [5, 120]]], 0, 0, 0, 0]], [], [], 0, 0], "level", ["subexpr", "@mut", [["get", "level", ["loc", [null, [5, 127], [5, 132]]], 0, 0, 0, 0]], [], [], 0, 0], "tagName", "li"], ["loc", [null, [5, 4], [5, 147]]], 0, 0]],
          locals: ["control"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/controls/input-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "controls", ["loc", [null, [4, 10], [4, 18]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [6, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 8,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/controls/input-list/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [7, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/cs-islands/component', ['exports', 'ember'], function (exports, _ember) {
  var $ = _ember['default'].$;
  var assert = _ember['default'].assert;
  var Component = _ember['default'].Component;
  var getOwner = _ember['default'].getOwner;
  exports['default'] = _ember['default'].Component.extend({
    tagName: '',

    init: function init() {
      this._super.apply(this, arguments);
      this.renderComponent = getRenderComponentFor(this);
      this.componentsToRender = queryIslandComponents();
      this.renderedComponents = [];
    },

    didInsertElement: function didInsertElement() {
      this.renderedComponents = this.componentsToRender.map(this.renderComponent);
    },

    didDestroyElement: function didDestroyElement() {
      this.renderedComponents.forEach(function (renderedComponent) {
        renderedComponent.destroy();
      });
    }
  });

  function componentAttributes(element) {
    var attrs = undefined;
    var attrsJSON = element.getAttribute('data-attrs');

    if (attrsJSON) {
      attrs = JSON.parse(attrsJSON);
    } else {
      attrs = {};
    }

    attrs.innerContent = element.innerHTML;
    return attrs;
  }

  function getRenderComponentFor(emberObject) {
    var owner = getOwner(emberObject);

    return function renderComponent(_ref) {
      var name = _ref.name;
      var attrs = _ref.attrs;
      var element = _ref.element;

      var component = lookupComponent(owner, name);
      assert('ember-islands could not find a component named "' + name + '" in your Ember appliction.', component);

      // Work around for #replaceIn bug
      $(element).empty();
      var componentInstance = component.create(attrs);
      componentInstance.appendTo(element);
      _ember['default'].run.scheduleOnce('afterRender', function () {
        $(element).contents().unwrap();
      });

      return componentInstance;
    };
  }

  function queryIslandComponents() {
    var components = [];

    $('[data-cs-component]').each(function () {
      var name = this.getAttribute('data-cs-component');
      var attrs = componentAttributes(this);
      components.push({ attrs: attrs, name: name, element: this });
    });

    return components;
  }

  function lookupComponent(owner, name) {
    var componentLookupKey = 'component:' + name;
    var layoutLookupKey = 'template:components/' + name;
    var layout = owner.lookup(layoutLookupKey);

    if (layout) {
      owner.inject(componentLookupKey, 'layout', layoutLookupKey);
    }

    var component = owner.factoryFor(componentLookupKey);

    if (layout && !component) {
      owner.register(componentLookupKey, Component);
      component = owner.factoryFor(componentLookupKey);
    }

    return component;
  }
});
// Ember Islands, modified per https://github.com/mitchlloyd/ember-islands/issues/7#issuecomment-241179736
define("cornerstone/components/cs-islands/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 2,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/cs-islands/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/debug/module-data/component', ['exports', 'ember', 'cornerstone/mixins/debug/component'], function (exports, _ember, _cornerstoneMixinsDebugComponent) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsDebugComponent['default'], {
    tagName: 'pre',
    classNames: ['cs-debug-module-data'],
    storeAttsFind: '',
    storeAttsReplace: '',

    attsObserver: _ember['default'].observer('module.attsUpdated', function () {
      this.rerender();
    }),

    actions: {
      storeAtts: function storeAtts() {
        var atts = this.get('module').getCleanAtts();
        this.set('ui.debugStoredType', atts._type);
        delete atts._type;
        delete atts._region;
        this.set('ui.debugStoredAtts', atts);
      },
      restoreAtts: function restoreAtts() {
        var atts = this.get('ui.debugStoredAtts');

        var find = this.getWithDefault('storeAttsFind', '');
        var replace = this.getWithDefault('storeAttsReplace', '');

        var defaults = Object.keys(this.get('module.definition.defaults'));
        for (var key in atts) {
          if (atts.hasOwnProperty(key) && 0 === key.indexOf(find)) {
            var newKey = '' === replace ? key : key.replace(find, replace);
            if (defaults.includes(newKey)) {
              this.set('module.atts.' + newKey, atts[key]);
            }
          }
        }
      }
    }

  });
});
define("cornerstone/components/debug/module-data/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 7,
              "column": 0
            },
            "end": {
              "line": 9,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/debug/module-data/template.hbs"
        },
        isEmpty: false,
        arity: 2,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode(": ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["content", "key", ["loc", [null, [8, 0], [8, 7]]], 0, 0, 0, 0], ["content", "value", ["loc", [null, [8, 9], [8, 18]]], 0, 0, 0, 0]],
        locals: ["key", "value"],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 10,
              "column": 0
            },
            "end": {
              "line": 12,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/debug/module-data/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "module.atts.content", ["loc", [null, [11, 16], [11, 35]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [11, 2], [11, 37]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 14,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/debug/module-data/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("button");
        var el2 = dom.createTextNode("Store");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("span");
        var el2 = dom.createTextNode("Storing: ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("button");
        var el2 = dom.createTextNode("Restore");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var element1 = dom.childAt(fragment, [8]);
        var morphs = new Array(9);
        morphs[0] = dom.createElementMorph(element0);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        morphs[3] = dom.createMorphAt(fragment, 6, 6, contextualElement);
        morphs[4] = dom.createElementMorph(element1);
        morphs[5] = dom.createMorphAt(fragment, 10, 10, contextualElement);
        morphs[6] = dom.createMorphAt(fragment, 12, 12, contextualElement);
        morphs[7] = dom.createMorphAt(fragment, 13, 13, contextualElement);
        morphs[8] = dom.createMorphAt(fragment, 14, 14, contextualElement);
        return morphs;
      },
      statements: [["element", "action", ["storeAtts"], [], ["loc", [null, [1, 8], [1, 30]]], 0, 0], ["content", "ui.debugStoredType", ["loc", [null, [2, 15], [2, 37]]], 0, 0, 0, 0], ["inline", "input", [], ["placeholder", "Find: toggle_", "value", ["subexpr", "@mut", [["get", "storeAttsFind", ["loc", [null, [3, 42], [3, 55]]], 0, 0, 0, 0]], [], [], 0, 0], "enter", ["subexpr", "action", ["storeAtts"], [], ["loc", [null, [3, 62], [3, 82]]], 0, 0]], ["loc", [null, [3, 0], [3, 85]]], 0, 0], ["inline", "input", [], ["placeholder", "Replace: toggle_", "value", ["subexpr", "@mut", [["get", "storeAttsReplace", ["loc", [null, [4, 45], [4, 61]]], 0, 0, 0, 0]], [], [], 0, 0], "enter", ["subexpr", "action", ["storeAtts"], [], ["loc", [null, [4, 68], [4, 88]]], 0, 0]], ["loc", [null, [4, 0], [4, 91]]], 0, 0], ["element", "action", ["restoreAtts"], [], ["loc", [null, [5, 8], [5, 32]]], 0, 0], ["content", "module.id", ["loc", [null, [6, 0], [6, 13]]], 0, 0, 0, 0], ["block", "each-in", [["get", "module.atts", ["loc", [null, [7, 11], [7, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [7, 0], [9, 12]]]], ["block", "if", [["subexpr", "eq", [["get", "module.atts._type", ["loc", [null, [10, 10], [10, 27]]], 0, 0, 0, 0], "text"], [], ["loc", [null, [10, 6], [10, 35]]], 0, 0]], [], 1, null, ["loc", [null, [10, 0], [12, 7]]]], ["content", "yield", ["loc", [null, [13, 0], [13, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/debug/module-preview/component', ['exports', 'ember', 'npm:Faker'], function (exports, _ember, _npmFaker) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: ['li'],
    classNames: ['cs-module-preview'],
    xfr: _ember['default'].inject.service(),
    store: _ember['default'].inject.service(),

    childrenSorting: ['order'],
    sortedChildren: _ember['default'].computed.sort('entity.availableChildren', 'childrenSorting'),
    init: function init() {
      this._super.apply(this, arguments);
      // this.set('entity', this.get('store').peekRecord('element', this.get('entityId') ) );
      //this.updateObservers();
    },

    actions: {
      test: function test() {
        this.rerender();
      },
      addChild: function addChild() {
        this.get('entity').addChild({
          first_name: _npmFaker['default'].Name.firstName(),
          last_name: _npmFaker['default'].Name.lastName() // this.get('xfr.agent.xfrOrigin'),
        });
      },
      deleteItem: function deleteItem() {
        this.get('entity').selfDestruct();
      },
      dupe: function dupe() {
        this.get('entity').duplicate();
      },
      moveUp: function moveUp() {
        this.get('entity.updatePosition')(this.get('entity.order') - 1);
      },
      moveDown: function moveDown() {
        this.get('entity.updatePosition')(this.get('entity.order') + 1);
      }
    }
  });
});
define("cornerstone/components/debug/module-preview/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 10,
              "column": 0
            },
            "end": {
              "line": 12,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/debug/module-preview/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "debug/module-preview", [], ["entity", ["subexpr", "@mut", [["get", "child", ["loc", [null, [11, 32], [11, 37]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [11, 2], [11, 39]]], 0, 0]],
        locals: ["child"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 14,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/debug/module-preview/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("ul");
        dom.setAttribute(el1, "class", "children");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "debug/module-data", [], ["module", ["subexpr", "@mut", [["get", "entity", ["loc", [null, [8, 32], [8, 38]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [8, 5], [8, 40]]], 0, 0], ["block", "each", [["get", "sortedChildren", ["loc", [null, [10, 8], [10, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [10, 0], [12, 9]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/elements/element-library/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['cs-element-library'],
    classicRevealed: _ember['default'].computed.alias('ui.revealClassicElements'),

    actions: {
      revealClassic: function revealClassic() {
        this.set('classicRevealed', true);
      }
    }
  });
});
define("cornerstone/components/elements/element-library/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 9,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/elements/element-library/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "elements/library-item", [], ["onClickElement", ["subexpr", "@mut", [["get", "onClickElement", ["loc", [null, [3, 19], [3, 33]]], 0, 0, 0, 0]], [], [], 0, 0], "definition", ["subexpr", "@mut", [["get", "definition", ["loc", [null, [4, 15], [4, 25]]], 0, 0, 0, 0]], [], [], 0, 0], "canDrag", ["subexpr", "@mut", [["get", "draggable", ["loc", [null, [5, 12], [5, 21]]], 0, 0, 0, 0]], [], [], 0, 0], "onDragStart", ["subexpr", "@mut", [["get", "onDragStart", ["loc", [null, [6, 16], [6, 27]]], 0, 0, 0, 0]], [], [], 0, 0], "onDragEnd", ["subexpr", "@mut", [["get", "onDragEnd", ["loc", [null, [7, 14], [7, 23]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [2, 2], [8, 4]]], 0, 0]],
        locals: ["definition"],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          var child0 = (function () {
            return {
              meta: {
                "revision": "Ember@2.8.0",
                "loc": {
                  "source": null,
                  "start": {
                    "line": 13,
                    "column": 6
                  },
                  "end": {
                    "line": 18,
                    "column": 8
                  }
                },
                "moduleName": "cornerstone/components/elements/element-library/template.hbs"
              },
              isEmpty: false,
              arity: 0,
              cachedFragment: null,
              hasRendered: false,
              buildFragment: function buildFragment(dom) {
                var el0 = dom.createDocumentFragment();
                var el1 = dom.createTextNode("        ");
                dom.appendChild(el0, el1);
                var el1 = dom.createElement("h6");
                dom.setAttribute(el1, "class", "cs-element-library-subset-title");
                var el2 = dom.createTextNode("\n          ");
                dom.appendChild(el1, el2);
                var el2 = dom.createElement("span");
                var el3 = dom.createTextNode("Classic Elements");
                dom.appendChild(el2, el3);
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("\n          ");
                dom.appendChild(el1, el2);
                var el2 = dom.createElement("small");
                var el3 = dom.createTextNode("Does not include advanced controls.");
                dom.appendChild(el2, el3);
                dom.appendChild(el1, el2);
                var el2 = dom.createTextNode("\n        ");
                dom.appendChild(el1, el2);
                dom.appendChild(el0, el1);
                var el1 = dom.createTextNode("\n");
                dom.appendChild(el0, el1);
                return el0;
              },
              buildRenderNodes: function buildRenderNodes() {
                return [];
              },
              statements: [],
              locals: [],
              templates: []
            };
          })();
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 12,
                  "column": 4
                },
                "end": {
                  "line": 19,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/elements/element-library/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["block", "unless", [["get", "isSearching", ["loc", [null, [13, 16], [13, 27]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [13, 6], [18, 19]]]]],
            locals: [],
            templates: [child0]
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 20,
                  "column": 4
                },
                "end": {
                  "line": 29,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/elements/element-library/template.hbs"
            },
            isEmpty: false,
            arity: 1,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "elements/library-item", [], ["onClickElement", ["subexpr", "@mut", [["get", "onClickElement", ["loc", [null, [22, 23], [22, 37]]], 0, 0, 0, 0]], [], [], 0, 0], "definition", ["subexpr", "@mut", [["get", "definition", ["loc", [null, [23, 19], [23, 29]]], 0, 0, 0, 0]], [], [], 0, 0], "classic", true, "canDrag", ["subexpr", "@mut", [["get", "draggable", ["loc", [null, [25, 16], [25, 25]]], 0, 0, 0, 0]], [], [], 0, 0], "onDragStart", ["subexpr", "@mut", [["get", "onDragStart", ["loc", [null, [26, 20], [26, 31]]], 0, 0, 0, 0]], [], [], 0, 0], "onDragEnd", ["subexpr", "@mut", [["get", "onDragEnd", ["loc", [null, [27, 18], [27, 27]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [21, 6], [28, 8]]], 0, 0]],
            locals: ["definition"],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 11,
                "column": 2
              },
              "end": {
                "line": 30,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/elements/element-library/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(2);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "elements", ["loc", [null, [12, 10], [12, 18]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [12, 4], [19, 11]]]], ["block", "each", [["get", "classicElements", ["loc", [null, [20, 12], [20, 27]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [20, 4], [29, 13]]]]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 30,
                "column": 2
              },
              "end": {
                "line": 32,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/elements/element-library/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("button");
            dom.setAttribute(el1, "class", "cs-element-library-reveal-button");
            var el2 = dom.createTextNode("Reveal Classic Elements →");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element0 = dom.childAt(fragment, [1]);
            var morphs = new Array(1);
            morphs[0] = dom.createElementMorph(element0);
            return morphs;
          },
          statements: [["element", "action", ["revealClassic"], [], ["loc", [null, [31, 53], [31, 79]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 10,
              "column": 0
            },
            "end": {
              "line": 33,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/elements/element-library/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "classicRevealed", ["loc", [null, [11, 8], [11, 23]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [11, 2], [32, 9]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 34,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/elements/element-library/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "each", [["get", "elements", ["loc", [null, [1, 8], [1, 16]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [9, 9]]]], ["block", "if", [["get", "classicElements", ["loc", [null, [10, 6], [10, 21]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [10, 0], [33, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/elements/library-item/component', ['exports', 'ember', 'cornerstone/mixins/dragula-events'], function (exports, _ember, _cornerstoneMixinsDragulaEvents) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsDragulaEvents['default'], {

    classNames: ['cs-element-library-item'],
    classNameBindings: ['classic:cs-element-library-item-classic', 'canDrag:draggable'],
    dragulaEvents: ['element'],

    draggable: _ember['default'].computed('canDrag', 'ui.skeletonModeActive', function () {
      if (!this.get('canDrag') || this.get('ui.skeletonModeActive')) {
        return null;
      }
      return 'true';
    }),

    dragulaDrag: function dragulaDrag() {
      if (!this.get('isDestroyed')) {
        this.sendAction('onDragStart', this.get('definition.id'));
      }
    },

    dragulaDragendCopy: function dragulaDragendCopy() {
      if (!this.get('isDestroyed')) {
        this.sendAction('onDragEnd');
      }
    },

    click: function click() {
      if (this.get('onClickElement')) {
        this.sendAction('onClickElement', this.get('definition'));
      }
    }
  });
});
define("cornerstone/components/elements/library-item/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 5,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/elements/library-item/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("span");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["inline", "icon", ["arrows"], [], ["loc", [null, [4, 8], [4, 25]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 6,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/elements/library-item/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("h4");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 0, 0);
        morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["inline", "icon", [["get", "definition.iconPath", ["loc", [null, [1, 7], [1, 26]]], 0, 0, 0, 0]], [], ["loc", [null, [1, 0], [1, 28]]], 0, 0], ["content", "definition.title", ["loc", [null, [2, 4], [2, 24]]], 0, 0, 0, 0], ["block", "if", [["get", "canDrag", ["loc", [null, [3, 6], [3, 13]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [3, 0], [5, 7]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/ember-selectize', ['exports', 'ember-cli-selectize/components/ember-selectize'], function (exports, _emberCliSelectizeComponentsEmberSelectize) {
  exports['default'] = _emberCliSelectizeComponentsEmberSelectize['default'];
});
define('cornerstone/components/flash-message', ['exports', 'ember-cli-flash/components/flash-message'], function (exports, _emberCliFlashComponentsFlashMessage) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberCliFlashComponentsFlashMessage['default'];
    }
  });
});
define('cornerstone/components/forms/aspect-ratio-input/component', ['exports', 'ember'], function (exports, _ember) {

  function normalizeRatioValue(value, index) {
    var parts = (value || '').split(':');
    return 'undefined' !== typeof index ? parts[index] : parts;
  }

  exports['default'] = _ember['default'].Component.extend({
    tagName: 'ul',
    classNames: ['cs-form-aspect-ratio-input'],

    placeholderA: _ember['default'].computed('placeholder', function () {
      return normalizeRatioValue(this.get('placeholder') || '', 0);
    }),

    placeholderB: _ember['default'].computed('placeholder', function () {
      return normalizeRatioValue(this.get('placeholder') || '', 1);
    })

  });
});
define("cornerstone/components/forms/aspect-ratio-input/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 4,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/aspect-ratio-input/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("li");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("li");
        var el2 = dom.createTextNode(":");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("li");
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(dom.childAt(fragment, [0]), 0, 0);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [4]), 0, 0);
        return morphs;
      },
      statements: [["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "width", ["loc", [null, [1, 18], [1, 23]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholderA", ["loc", [null, [1, 36], [1, 48]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [1, 4], [1, 50]]], 0, 0], ["inline", "input", [], ["value", ["subexpr", "@mut", [["get", "height", ["loc", [null, [3, 18], [3, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", ["subexpr", "@mut", [["get", "placeholderB", ["loc", [null, [3, 37], [3, 49]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [3, 4], [3, 51]]], 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/forms/checkbox-list/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({});
});
define("cornerstone/components/forms/checkbox-list/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/checkbox-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [2, 2], [2, 11]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 4
                },
                "end": {
                  "line": 7,
                  "column": 4
                }
              },
              "moduleName": "cornerstone/components/forms/checkbox-list/template.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("      ");
              dom.appendChild(el0, el1);
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
              return morphs;
            },
            statements: [["inline", "forms/rc-checkbox", [], ["value", ["subexpr", "mut", [["subexpr", "get", [["get", "proxy", ["loc", [null, [6, 42], [6, 47]]], 0, 0, 0, 0], ["get", "checkbox.keyPath", ["loc", [null, [6, 48], [6, 64]]], 0, 0, 0, 0]], [], ["loc", [null, [6, 37], [6, 65]]], 0, 0]], [], ["loc", [null, [6, 32], [6, 66]]], 0, 0], "label", ["subexpr", "@mut", [["get", "checkbox.label", ["loc", [null, [6, 73], [6, 87]]], 0, 0, 0, 0]], [], [], 0, 0], "half", ["subexpr", "@mut", [["get", "checkbox.half", ["loc", [null, [6, 93], [6, 106]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [6, 6], [6, 108]]], 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 8,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/forms/checkbox-list/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "if", [["get", "checkbox.keyPath", ["loc", [null, [5, 10], [5, 26]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [5, 4], [7, 11]]]]],
          locals: ["checkbox"],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 9,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/checkbox-list/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "checkboxes", ["loc", [null, [4, 10], [4, 20]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [8, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/checkbox-list/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [9, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/choose-choice/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    tagName: 'li',
    classNameBindings: ['class', 'selected:cs-active'],

    selected: _ember['default'].computed('choose.value', 'choose.valueUpdated', 'value', function () {

      if (this.get('choose.multi')) {

        var selected = this.get('choose.arrayOutput') ? this.getWithDefault('choose.value', []) : this.getWithDefault('choose.value', '').split(this.getWithDefault('choose.delimiter', ' '));

        return selected.includes(this.get('value'));
      } else {
        return this.get('choose.value') === this.get('value');
      }
    }),

    click: function click() {
      this.get('choose').send('select', this.get('value'));
    }

  });
});
define("cornerstone/components/forms/choose-choice/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 2
            },
            "end": {
              "line": 4,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/choose-choice/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [3, 4], [3, 13]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 5,
                "column": 4
              },
              "end": {
                "line": 7,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/choose-choice/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "icon", [["get", "icon", ["loc", [null, [6, 13], [6, 17]]], 0, 0, 0, 0]], [], ["loc", [null, [6, 6], [6, 19]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 7,
                "column": 4
              },
              "end": {
                "line": 9,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/choose-choice/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createUnsafeMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["content", "label", ["loc", [null, [8, 6], [8, 17]]], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 4,
              "column": 2
            },
            "end": {
              "line": 10,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/choose-choice/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "icon", ["loc", [null, [5, 10], [5, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [5, 4], [9, 11]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 11,
            "column": 7
          }
        },
        "moduleName": "cornerstone/components/forms/choose-choice/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("abbr");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var morphs = new Array(2);
        morphs[0] = dom.createAttrMorph(element0, 'title');
        morphs[1] = dom.createMorphAt(element0, 1, 1);
        return morphs;
      },
      statements: [["attribute", "title", ["concat", [["get", "tooltip", ["loc", [null, [1, 15], [1, 22]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "hasBlock", ["loc", [null, [2, 8], [2, 16]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [2, 2], [10, 9]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/choose-icon/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-icons-outer'],
    rendered: false,
    ready: false,
    searchQuery: '',
    scrollReset: 0,

    init: function init() {
      var _this = this;

      this._super.apply(this, arguments);
      this.get('ui').getFaIcons().then(function (icons) {
        if (_this.isDestroyed) {
          return;
        }
        var reduced = [];
        for (var key in icons) {
          reduced.push({
            id: icons[key][0],
            title: icons[key].length > 1 ? icons[key].join(', ') : icons[key][0]
          });
        }

        _this.set('icons', reduced);
        _this.set('ready', true);
      });
    },

    observeScrollToSelectedOn: _ember['default'].observer('scrollToSelectedOn', function () {
      this.get('scrollToSelectedOn');
      this.scrollToSelected();
    }),

    loaded: _ember['default'].computed('ready', 'rendered', function () {
      return this.get('ready') && this.get('rendered');
    }),

    afterLoad: _ember['default'].observer('loaded', function () {
      this.scrollToSelected();
    }),

    scrollToSelected: function scrollToSelected() {
      var _this2 = this;

      if (!this.get('loaded')) {
        return;
      }

      _ember['default'].run.scheduleOnce('afterRender', function () {
        var value = _this2.get('value');
        if (_ember['default'].isPresent(value)) {
          _this2.set('scrollTo', {
            selector: 'li[data-choice=' + value + ']',
            offset: 1
          });
        } else {
          _this2.incrementProperty('scrollReset');
        }
      });
    },

    didInsertElement: function didInsertElement() {
      var _this3 = this;

      _ember['default'].run.scheduleOnce('afterRender', function () {
        _this3.set('rendered', true);
      });
    },

    actions: {
      select: function select(icon) {
        this.set('value', icon);
      }
    },

    onSearchQuery: _ember['default'].observer('searchQuery', function () {
      _ember['default'].run.debounce(this, this.searchUpdate, 25);
    }),

    searchUpdate: function searchUpdate() {
      var _this4 = this;

      _ember['default'].run.scheduleOnce('afterRender', function () {

        var $ul = _this4.$('ul.cs-choose');
        var query = _this4.get('searchQuery');

        $ul.find('li').show();
        if ('' !== query) {
          $ul.find('li:not([title*="' + query + '"])').hide();
          _this4.incrementProperty('scrollReset');
        } else {
          _this4.scrollToSelected();
        }
      });
    }

  });
});
define("cornerstone/components/forms/choose-icon/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 6,
                  "column": 8
                },
                "end": {
                  "line": 12,
                  "column": 8
                }
              },
              "moduleName": "cornerstone/components/forms/choose-icon/template.hbs"
            },
            isEmpty: false,
            arity: 1,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("          ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("li");
              var el2 = dom.createComment("");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1]);
              var morphs = new Array(5);
              morphs[0] = dom.createAttrMorph(element0, 'data-choice');
              morphs[1] = dom.createAttrMorph(element0, 'title');
              morphs[2] = dom.createAttrMorph(element0, 'class');
              morphs[3] = dom.createElementMorph(element0);
              morphs[4] = dom.createMorphAt(element0, 0, 0);
              return morphs;
            },
            statements: [["attribute", "data-choice", ["concat", [["get", "icon.id", ["loc", [null, [8, 27], [8, 34]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "title", ["concat", [["get", "icon.title", ["loc", [null, [9, 21], [9, 31]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "icon.id", ["loc", [null, [10, 28], [10, 35]]], 0, 0, 0, 0], ["get", "value", ["loc", [null, [10, 36], [10, 41]]], 0, 0, 0, 0]], [], ["loc", [null, [10, 24], [10, 42]]], 0, 0], "cs-active"], [], ["loc", [null, [10, 19], [10, 57]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["select", ["get", "icon.id", ["loc", [null, [7, 32], [7, 39]]], 0, 0, 0, 0]], [], ["loc", [null, [7, 14], [7, 41]]], 0, 0], ["inline", "fa-icon", [["get", "icon.id", ["loc", [null, [11, 21], [11, 28]]], 0, 0, 0, 0]], [], ["loc", [null, [11, 11], [11, 30]]], 0, 0]],
            locals: ["icon"],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 4
              },
              "end": {
                "line": 14,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/choose-icon/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("ul");
            dom.setAttribute(el1, "class", "cs-choose cols-6 single");
            var el2 = dom.createTextNode("\n");
            dom.appendChild(el1, el2);
            var el2 = dom.createComment("");
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("      ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
            return morphs;
          },
          statements: [["block", "each", [["get", "icons", ["loc", [null, [6, 16], [6, 21]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [6, 8], [12, 17]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 14,
                "column": 4
              },
              "end": {
                "line": 16,
                "column": 4
              }
            },
            "moduleName": "cornerstone/components/forms/choose-icon/template.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "cs-icons-loading");
            var el2 = dom.createTextNode("…");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 2
            },
            "end": {
              "line": 17,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/choose-icon/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "loaded", ["loc", [null, [4, 10], [4, 16]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [4, 4], [16, 11]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 19,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/choose-icon/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "cs-icons-inner");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(dom.childAt(fragment, [2]), 1, 1);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["inline", "common/search-bar", [], ["query", ["subexpr", "@mut", [["get", "searchQuery", ["loc", [null, [1, 26], [1, 37]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "Search Icons", "focusOnShortcut", false], ["loc", [null, [1, 0], [1, 88]]], 0, 0], ["block", "common/scroll-box", [], ["scrollTo", ["subexpr", "@mut", [["get", "scrollTo", ["loc", [null, [3, 32], [3, 40]]], 0, 0, 0, 0]], [], [], 0, 0], "resetScrollOn", ["subexpr", "@mut", [["get", "scrollReset", ["loc", [null, [3, 55], [3, 66]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [3, 2], [17, 24]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/forms/choose-multi/component', ['exports', 'ember', 'cornerstone/components/forms/choose-single/component'], function (exports, _ember, _cornerstoneComponentsFormsChooseSingleComponent) {
  exports['default'] = _cornerstoneComponentsFormsChooseSingleComponent['default'].extend({

    multi: true,
    assignDefaultMulti: true,
    arrayOutput: false,
    assignDefaultMultiDelimeter: _ember['default'].computed('delimiter', function () {
      return this.getWithDefault('delimiter', ' ');
    }),

    valueUpdated: 0,
    valueObserver: _ember['default'].computed('value.[]', function () {
      this.incrementProperty('valueUpdated');
    }),

    actions: {
      select: function select(choice) {

        var selected = this.get('arrayOutput') ? this.getWithDefault('value', []) : this.getWithDefault('value', '').split(this.getWithDefault('delimiter', ' '));
        var offValue = this.get('offValue');

        // Remove offValue

        if (!_ember['default'].isNone(offValue)) {
          var offValueIndex = selected.indexOf(offValue);
          if (-1 !== offValueIndex) {
            selected.splice(offValueIndex, 1);
          }
        }

        // Add/Remove choice
        var choiceIndex = selected.indexOf(choice);
        if (-1 === choiceIndex) {
          selected.push(choice);
        } else {
          selected.splice(choiceIndex, 1);
        }

        if (!_ember['default'].isNone(offValue) && selected.length < 1) {
          selected.push(offValue);
        }

        selected.sort();
        if (this.get('arrayOutput')) {
          this.set('value', selected.slice(0));
        } else {
          this.set('value', selected.join(this.getWithDefault('delimiter', ' ')));
        }

        console.log('selected', this.get('value'));
      }
    }

  });
});
define("cornerstone/components/forms/choose-multi/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/choose-multi/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["get", "this", ["loc", [null, [2, 10], [2, 14]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 2], [2, 17]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 11,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/forms/choose-multi/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "this", ["loc", [null, [6, 13], [6, 17]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "choice.value", ["loc", [null, [7, 12], [7, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "icon", ["subexpr", "@mut", [["get", "choice.icon", ["loc", [null, [8, 11], [8, 22]]], 0, 0, 0, 0]], [], [], 0, 0], "label", ["subexpr", "@mut", [["get", "choice.label", ["loc", [null, [9, 12], [9, 24]]], 0, 0, 0, 0]], [], [], 0, 0], "tooltip", ["subexpr", "@mut", [["get", "choice.tooltip", ["loc", [null, [10, 14], [10, 28]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [5, 4], [10, 30]]], 0, 0]],
          locals: ["choice"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 12,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/choose-multi/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "choices", ["loc", [null, [4, 10], [4, 17]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [11, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 7
          }
        },
        "moduleName": "cornerstone/components/forms/choose-multi/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [12, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/choose-single/component', ['exports', 'ember', 'cornerstone/mixins/forms/visibility-observation', 'cornerstone/mixins/forms/assign-default'], function (exports, _ember, _cornerstoneMixinsFormsVisibilityObservation, _cornerstoneMixinsFormsAssignDefault) {
  exports['default'] = _ember['default'].Component.extend(_cornerstoneMixinsFormsVisibilityObservation['default'], _cornerstoneMixinsFormsAssignDefault['default'], {

    tagName: 'ul',
    classNames: ['cs-choose'],
    classNameBindings: ['condensed:cs-choose-condensed', 'cols'],
    assignDefaultOptionsPath: 'choices',

    init: function init() {
      this._super.apply(this, arguments);
      if (!_ember['default'].isNone(this.get('offValue'))) {
        this.set('assignDefaultSourcePath', 'offValue');
      }
    },

    // delimiter: null, // If delimiter is null, treat as an array - otherwise make a string

    condensed: true,
    cols: _ember['default'].computed('choices', 'foundCols', function () {
      var number = !this.get('choices') ? this.get('foundCols') : this.get('choices.length');
      return 'cols-' + number;
    }),

    didRender: function didRender() {

      if (!this.get('choices')) {
        _ember['default'].run.scheduleOnce('afterRender', (function () {
          this.set('foundCols', this.$('li').length);
        }).bind(this));
      }
    },

    actions: {
      isVisible: function isVisible() {
        this.send('assignDefaultOption');
      },
      select: function select(choice) {

        var offValue = this.get('offValue');

        if (!_ember['default'].isNone(offValue) && choice === this.get('value')) {
          choice = offValue;
        }

        this.set('value', choice);
      }
    }

  });
});
define("cornerstone/components/forms/choose-single/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/choose-single/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["get", "this", ["loc", [null, [2, 10], [2, 14]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 2], [2, 17]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 2
              },
              "end": {
                "line": 6,
                "column": 2
              }
            },
            "moduleName": "cornerstone/components/forms/choose-single/template.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["inline", "forms/choose-choice", [], ["choose", ["subexpr", "@mut", [["get", "this", ["loc", [null, [5, 33], [5, 37]]], 0, 0, 0, 0]], [], [], 0, 0], "value", ["subexpr", "@mut", [["get", "choice.value", ["loc", [null, [5, 44], [5, 56]]], 0, 0, 0, 0]], [], [], 0, 0], "icon", ["subexpr", "@mut", [["get", "choice.icon", ["loc", [null, [5, 62], [5, 73]]], 0, 0, 0, 0]], [], [], 0, 0], "label", ["subexpr", "@mut", [["get", "choice.label", ["loc", [null, [5, 80], [5, 92]]], 0, 0, 0, 0]], [], [], 0, 0], "tooltip", ["subexpr", "@mut", [["get", "choice.tooltip", ["loc", [null, [5, 101], [5, 115]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [5, 4], [5, 117]]], 0, 0]],
          locals: ["choice"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/choose-single/template.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "choices", ["loc", [null, [4, 10], [4, 17]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [4, 2], [6, 11]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 8,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/choose-single/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [7, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define('cornerstone/components/forms/color-input/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    colorService: _ember['default'].inject.service('templates/colors'),

    onInit: _ember['default'].on('init', function () {
      var _this = this;

      if (!this.get('usePalette')) {
        this.set('ready', true);
        return;
      }

      this.get('colorService.paletteItemsPromise').then(function (items) {

        if (_this.isDestroyed) {
          return;
        }

        _this.set('paletteItems', items);
        _this.set('ready', true);

        if (_this.get('selected')) {
          _this.get('updating', false);
          _this.set('value', _this.get('colorService').lookupColor(_this.get('selected')));
          if (_this.get('picker')) {
            _this.get('picker').send('stateChange');
          }
        }
      });
    }),

    classNames: ['cs-form-color-input'],

    valueObserver: _ember['default'].observer('value', function () {
      if (!this.get('updating')) {
        var value = this.get('value');
        this.$input.val(value);

        this.$('.huebert-picker-control-output-value').val(value);
        this.$input.trigger('change', { ember: true });
      }
      this.set('updating', false);
    }),

    selectedObserver: _ember['default'].observer('selected', function () {
      if (!this.get('updating')) {
        var incoming = this.getWithDefault('selected', '').replace(/\ /g, '');
        var current = this.getWithDefault('huebertValue', '').replace(/\ /g, '');
        if (incoming !== current) {
          var lookup = this.get('colorService').lookupColor(this.get('selected'));
          this.set('value', lookup);
        }
      }
    }),

    colorValue: _ember['default'].computed('value', 'colorService.paletteItems.[]', function () {
      if (!this.get('usePalette')) {
        return this.get('value');
      }
      return this.get('colorService').lookupColor(this.get('value'));
    }),

    huebertValueObserver: _ember['default'].observer('huebertValue', function () {
      this.set('updating', true);
      this.set('selected', this.get('huebertValue'));
      this.set('value', this.get('huebertValue'));
    }),

    didInsertElement: function didInsertElement() {
      this.set('canRender', true);
      this.renderWhenReady();
    },

    observeReady: _ember['default'].observer('ready', function () {
      this.renderWhenReady();
    }),

    renderWhenReady: function renderWhenReady() {
      var _this2 = this;

      if (!this.get('canRender') || this.get('isRendered')) {
        return;
      }

      this.set('isRendered', true);

      this.$input = this.$('input[type=text]');
      this.$input.val(this.get('value'));

      this.$input.on('change', function (e, params) {
        if (params && params.ember) {
          return;
        }
        _this2.set('huebertValue', _this2.$input.val());
      });

      _ember['default'].run.scheduleOnce('afterRender', function () {
        var opts = {
          outputFormat: _this2.getWithDefault('options.output_format', null),
          label: _this2.getWithDefault('options.label', null),
          canToggle: !_this2.getWithDefault('inline', false),
          scrollEvent: 'ps-scroll-x ps-scroll-y'
        };
        _this2.$input.huebert(opts);

        _this2.$('.huebert-picker-control-slider-a').after(_this2.$('.cs-form-color-input-palette'));
      });
    },

    actions: {
      select: function select(item) {
        this.set('selected', 'global-color:' + _ember['default'].get(item, 'id'));
      }
    }
  });
});
define('cornerstone/components/forms/color-input/palette-item/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-form-color-input-palette-item'],
    classNameBindings: ['active:cs-active'],
    attributeBindings: ['style', 'title'],
    title: _ember['default'].computed.alias('item.label'),
    colorStyle: _ember['default'].computed('item.value', function () {
      return _ember['default'].String.htmlSafe('background-color: ' + this.getWithDefault('item.value', 'transparent') + ';');
    }),

    active: _ember['default'].computed('item.id', 'selected', function () {
      return 'global-color:' + this.get('item.id') === this.getWithDefault('selected', null);
    }),

    didInsertElement: function didInsertElement() {
      var _this = this;

      this.$().on('click', function () {
        return _this.sendAction('select');
      });
    }

  });
});
define("cornerstone/components/forms/color-input/palette-item/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/color-input/palette-item/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var morphs = new Array(2);
        morphs[0] = dom.createAttrMorph(element0, 'style');
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        return morphs;
      },
      statements: [["attribute", "style", ["get", "colorStyle", ["loc", [null, [1, 13], [1, 23]]], 0, 0, 0, 0], 0, 0, 0, 0], ["content", "yield", ["loc", [null, [2, 0], [2, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define("cornerstone/components/forms/color-input/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 2
            },
            "end": {
              "line": 9,
              "column": 2
            }
          },
          "moduleName": "cornerstone/components/forms/color-input/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/color-input/palette-item", [], ["item", ["subexpr", "@mut", [["get", "item", ["loc", [null, [5, 11], [5, 15]]], 0, 0, 0, 0]], [], [], 0, 0], "selected", ["subexpr", "@mut", [["get", "selected", ["loc", [null, [6, 15], [6, 23]]], 0, 0, 0, 0]], [], [], 0, 0], "select", ["subexpr", "action", ["select", ["get", "item", ["loc", [null, [7, 30], [7, 34]]], 0, 0, 0, 0]], [], ["loc", [null, [7, 13], [7, 35]]], 0, 0]], ["loc", [null, [4, 4], [8, 6]]], 0, 0]],
        locals: ["item"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 9
          }
        },
        "moduleName": "cornerstone/components/forms/color-input/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("input");
        dom.setAttribute(el1, "type", "text");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [2]);
        var morphs = new Array(3);
        morphs[0] = dom.createAttrMorph(element0, 'class');
        morphs[1] = dom.createMorphAt(element0, 1, 1);
        morphs[2] = dom.createMorphAt(fragment, 4, 4, contextualElement);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["attribute", "class", ["concat", ["cs-form-color-input-palette ", ["subexpr", "unless", [["get", "paletteItems", ["loc", [null, [2, 49], [2, 61]]], 0, 0, 0, 0], "cs-hide"], [], ["loc", [null, [2, 40], [2, 73]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "each", [["get", "paletteItems", ["loc", [null, [3, 10], [3, 22]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [3, 2], [9, 11]]]], ["content", "yield", ["loc", [null, [12, 0], [12, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/forms/color-picker/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    colorService: _ember['default'].inject.service('templates/colors'),

    classNames: ['cs-form-color-picker'],

    onInit: _ember['default'].on('init', function () {
      var _this = this;

      if (!this.get('usePalette')) {
        this.set('ready', true);
        return;
      }

      this.get('colorService.paletteItemsPromise').then(function () {
        if (!_this.isDestroyed) {
          _this.incrementProperty('swatchUpdate');
        }
      });
    }),

    swatchColor: _ember['default'].computed('value', 'colorService.paletteItems.[]', function () {
      if (!this.get('usePalette')) {
        return this.get('value');
      }
      return this.get('colorService').lookupColor(this.get('value'));
    }),

    label: _ember['default'].computed('options.label', function () {
      return this.getWithDefault('options.label', 'Select Color');
    }),

    content: _ember['default'].computed('value', 'swatchUpdate', function () {
      return _ember['default'].String.htmlSafe('<div class="cs-picker-swatch-content" style="background-color: ' + this.get('swatchColor') + ';"></div>');
    }),

    swatchUpdate: 0,
    actions: {
      stateChange: function stateChange() {
        this.incrementProperty('swatchUpdate');
      }
    }

  });
});
define("cornerstone/components/forms/color-picker/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 7,
              "column": 0
            }
          },
          "moduleName": "cornerstone/components/forms/color-picker/template.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "forms/color-input", [], ["inline", true, "selected", ["subexpr", "@mut", [["get", "value", ["loc", [null, [6, 43], [6, 48]]], 0, 0, 0, 0]], [], [], 0, 0], "usePalette", ["subexpr", "@mut", [["get", "usePalette", ["loc", [null, [6, 60], [6, 70]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [6, 2], [6, 73]]], 0, 0]],
        locals: ["picker"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 8,
            "column": 0
          }
        },
        "moduleName": "cornerstone/components/forms/color-picker/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "common/cs-picker", [], ["onStateChange", ["subexpr", "action", ["stateChange"], [], ["loc", [null, [2, 16], [2, 38]]], 0, 0], "label", ["subexpr", "@mut", [["get", "label", ["loc", [null, [3, 8], [3, 13]]], 0, 0, 0, 0]], [], [], 0, 0], "content", ["subexpr", "@mut", [["get", "content", ["loc", [null, [4, 10], [4, 17]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [1, 0], [7, 21]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define('cornerstone/components/forms/cs-toggle/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    tagName: 'ul',
    classNames: ['cs-toggle'],
    classNameBindings: ['state:on:off'],

    state: _ember['default'].computed('value', function () {
      return this.normalize(this.get('value'));
    }),

    // Detect various forms of boolean storage and play along

    normalize: function normalize(value) {

      if ('1' === value || 'true' === value) {
        return true;
      }

      if ('' === value || 'false' === value) {
        return false;
      }

      return !!value;
    },

    invert: function invert(value) {

      if ('true' === value) {
        return 'false';
      }

      if ('false' === value) {
        return 'true';
      }

      if ('1' === value) {
        return '';
      }

      if ('' === value) {
        return '1';
      }

      return !value;
    },

    click: function click() {
      this.send('toggle');
    },

    actions: {
      toggle: function toggle() {
        var _this = this;

        var $el = this.$();
        var on = $el.hasClass('on');
        $el.toggleClass('on', !on).toggleClass('off', !!on);

        _ember['default'].run.next(function () {
          _this.set('value', _this.invert(_this.get('value')));
        });
      }
    }

  });
});
define("cornerstone/components/forms/cs-toggle/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 3,
            "column": 37
          }
        },
        "moduleName": "cornerstone/components/forms/cs-toggle/template.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("li");
        dom.setAttribute(el1, "class", "on");
        var el2 = dom.createElement("span");
        var el3 = dom.createTextNode("On");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("li");
        dom.setAttribute(el1, "class", "off");
        var el2 = dom.createElement("span");
        var el3 = dom.createTextNode("Off");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define('cornerstone/components/forms/expandable-text-editor/component', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({

    classNames: ['cs-expandable-rich-text'],

    content: _ember['default'].computed('value', 'placeholder', function () {
      var content = this.getWithDefault('value', this.getWithDefault('placeholder', ''));
      return _ember['default'].String.htmlSafe('<input type="text" value="' + content + '" disabled>');
    })

  });
});
define("cornerstone/components/forms/expandable-text-editor/template", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end"