<?php

/**
 * Localize strings for javascript
 */

return array(


	// General
	'welcome'         => __('<strong>It&apos;s buildin&apos; time!</strong> Make a selection from the workspace to see a preview.', 'cornerstone'),
	'sections'        => __( 'Sections', 'cornerstone' ),
	'section'         => __( 'Section', 'cornerstone' ),
	'section-numeric' => __( 'Section %s', 'cornerstone' ),
	'section-format'  => __( 'Section &ndash; %s', 'cornerstone' ),
	'rows'            => __( 'Rows', 'cornerstone' ),
	'row'             => __( 'Row', 'cornerstone' ),
	'row-numeric'     => __( 'Row %s', 'cornerstone' ),
	'column'          => __( 'Column', 'cornerstone' ),
	'column-format'   => __( 'Column &ndash; %s', 'cornerstone' ),


	// Index
	'search-by-title'          => __( 'Search by Title', 'cornerstone' ),
  'no-content-found'         => __( 'No Content Found', 'cornerstone' ),
  'no-content-found-message' => __( 'Try refining your search to locate your desired content.', 'cornerstone' ),

	// Footer
	'footer-button-save'       => __( 'Save', 'cornerstone' ),
	'footer-dashboard-confirm' => __( 'Are you sure you wish to return to the Dashbord?', 'cornerstone' ),

	// Layout
	'layout-heading'                => __( 'Layout', 'cornerstone' ),
	'layout-return'                 => __( 'Back to Layout', 'cornerstone' ),
	'layout-add-row'                => __( 'Add Row', 'cornerstone' ),
	'layout-add-section'            => __( 'Add Section', 'cornerstone' ),
	'layout-templates'              => __( 'Templates', 'cornerstone' ),


	'layout-section-delete-confirm' => __( 'Are you sure you want to delete this section along with all it&apos;s contents?', 'cornerstone' ),
	'layout-row-delete-confirm'     => __( 'Are you sure you want to delete this row along with all it&apos;s contents?', 'cornerstone' ),
	'layout-row-subtext'            => __( 'Click a row to manage columns. Drag to reorder.', 'cornerstone' ),
	'layout-info-title'             => __( 'Just getting started?', 'cornerstone' ),
	'layout-info-description'       => __( 'Add a section then click on it to manage column layouts or drag it to reorder.', 'cornerstone' ),

	// Layout - Columns
	'columns-info-title'       => __( 'Want to add content?', 'cornerstone' ),
	'columns-info-description' => __( 'Choose a layout, click the <strong class="glue">{{icon}} Elements</strong> icon above, then drag elements into a column.', 'cornerstone' ),
	'columns-layout-custom'    => __( 'Custom', 'cornerstone' ),
	'columns-layout-label'     => __( 'Column Layout', 'cornerstone' ),
	//'columns-layout-tooltip'   => __( 'Choose from one of our predefined column layouts, or specify your own using the input below. Columns cannot be any smaller than 1/6 and must add up to a whole.', 'cornerstone' ),
	'columns-order-label'      => __( 'Column Order', 'cornerstone' ),
	//'columns-order-tooltip'    => __( 'Click and drag to reorder your columns.', 'cornerstone' ),
	'columns-erase-confirm'    => __( 'This will remove all elements from this column. Are you sure you want to continue?', 'cornerstone' ),


	// Layout - Templates
	'templates-info-title'        => __( 'Blocks and pages?', 'cornerstone' ),
	'templates-info-description'  => __( '<strong>Blocks</strong> are appended to your content, whereas <strong>Pages</strong> will replace your content.', 'cornerstone' ),
	'templates-save'              => __( 'Save', 'cornerstone' ),
	'templates-upload'            => __( 'Upload', 'cornerstone' ),
	'templates-title'             => __( 'My Custom Template', 'cornerstone' ),
	'templates-upload-button'     => __( 'Add to layout', 'cornerstone' ),
	'templates-download'          => __( 'Download', 'cornerstone' ),
	'templates-save-library'      => __( 'To Library', 'cornerstone' ),
	'templates-saved'             => __( 'Template saved.', 'cornerstone' ),
	'templates-save-message'      => __( 'How would you like this page stored in your library?', 'cornerstone' ),
	'templates-save-yep'          => __( 'Page', 'cornerstone' ),
	'templates-save-nope'         => __( 'Block', 'cornerstone' ),
	'templates-upload-message'    => __( 'How would you like this added to your page? Remember, using a page will ERASE your current page contents.', 'cornerstone' ),
	'templates-upload-yep'        => __( 'Page', 'cornerstone' ),
	'templates-upload-nope'       => __( 'Block', 'cornerstone' ),
	'templates-upload-start'      => __( 'Your template is being uploaded...', 'cornerstone' ),
	'templates-insert'            => __( 'Insert', 'cornerstone' ),
	'templates-themeco-pages'     => __( 'Themeco Pages', 'cornerstone' ),
	'templates-themeco-blocks'    => __( 'Themeco Blocks', 'cornerstone' ),
	'templates-user-pages'        => __( 'My Pages', 'cornerstone' ),
	'templates-user-blocks'       => __( 'My Blocks', 'cornerstone' ),
	'templates-overwrite-message' => __( 'Using a page will <span style="color: #e74c3c;">erase</span> your current page contents. Are you sure you wish to proceed?', 'cornerstone' ),
	'templates-overwrite-yep'     => __( 'Yep', 'cornerstone' ),
	'templates-overwrite-nope'    => __( 'Nope', 'cornerstone' ),
	'templates-error-read'        => __( 'Unable to read file', 'cornerstone' ),
	'templates-error-upload'      => __( 'Sorry! Your file is not properly formatted.', 'cornerstone' ),
	'templates-error-save'        => __( 'Unable to save template.', 'cornerstone' ),
	'templates-error-import'      => __( 'Could not load template.', 'cornerstone' ),
	'templates-remove-label'      => __( 'Remove Templates', 'cornerstone' ),
	'templates-remove'            => __( 'Delete', 'cornerstone' ),
	'templates-remove-block'      => __( '(Block) %s', 'cornerstone' ),
	'templates-remove-page'       => __( '(Page) %s', 'cornerstone' ),
	'templates-remove-message'    => __( 'Are you sure you wish to delete this template? This can not be undone.', 'cornerstone' ),
	'templates-delete-success'    => __( 'Template removed from library.', 'cornerstone' ),
	'templates-error-delete'      => __( 'Unable to delete stored template.', 'cornerstone' ),
	'templates-page-updated'      => __( 'Page updated.', 'cornerstone' ),
	'templates-block-inserted'      => __( 'Block inserted.', 'cornerstone' ),


	// Elements
	'elements-heading' => __( 'Elements', 'cornerstone' ),
	'elements-search'  => __( 'Search Elements', 'cornerstone' ),
	'elements-return'  => __( 'Back to Elements', 'cornerstone' ),

	'no-elements-found'         => __( 'No Elements Found', 'cornerstone' ),
  'no-elements-found-message' => __( 'Try refining your search to locate your desired element.', 'cornerstone' ),

	// Inspector
	'inspector-heading'            => __( 'Inspector', 'cornerstone' ),
	'inspector-return'             => __( 'Back to Inspector', 'cornerstone' ),
	'inspector-blank-title'        => __( 'No elements are selected!', 'cornerstone' ),
	'inspector-blank-pane-title'   => __( 'Nothing Selected', 'cornerstone' ),
	'inspector-blank-pane-message' => __( 'Click on an element in the site preview to begin inspecting it.', 'cornerstone' ),
	'inspector-blank-sub'          => __( 'Inspect an element by clicking on it in the preview pane.', 'cornerstone' ),
	'inspector-duplicate'          => __( 'Duplicate', 'cornerstone' ),
	'inspector-delete'             => __( 'Delete', 'cornerstone' ),
	'inspector-really-delete'      => __( 'Really Delete?', 'cornerstone' ),
	'inspector-delete-confirm'     => __( 'Are you sure you wish to delete this element?', 'cornerstone' ),
	'inspector-erase'              => __( 'Erase', 'cornerstone' ),
	'inspector-really-erase'       => __( 'Really Erase?', 'cornerstone' ),
	'inspector-manage-layout'      => __( 'Manage Layout', 'cornerstone' ),

	// Controls
	'controls-on'           => __( 'On', 'cornerstone' ),
	'controls-off'          => __( 'Off', 'cornerstone' ),
	'dimensions-top'        => __( 'Top', 'cornerstone' ),
	'dimensions-right'      => __( 'Right', 'cornerstone' ),
	'dimensions-bottom'     => __( 'Bottom', 'cornerstone' ),
	'dimensions-left'       => __( 'Left', 'cornerstone' ),
	'dimensions-link'       => __( 'Link', 'cornerstone' ),
	'dimensions-unlink'     => __( 'Unlink', 'cornerstone' ),
	'tooltip-inspect'       => __( 'Inspect', 'cornerstone' ),
	'tooltip-manage-layout' => __( 'Manage Layout', 'cornerstone' ),
	'tooltip-erase'         => __( 'Erase', 'cornerstone' ),
	'tooltip-copy'          => __( 'Duplicate', 'cornerstone' ),
	'tooltip-delete'        => __( 'Delete', 'cornerstone' ),
	'sortable-add'          => __( 'Add', 'cornerstone' ),
	'sortable-remove'       => __( 'Are you sure you wish to remove this item?', 'cornerstone' ),
	'sortable-at-floor'     => __( 'The last item can&apos;t be deleted, but would you like to reset it to defaults?', 'cornerstone' ),
	'sortable-at-cap'       => __( 'This element has reached it&apos;s capacity. You can&apos;t add any more.', 'cornerstone' ),
	'sortable-default'      => __( 'New Item %s', 'cornerstone' ),
	'sortable-duplicate'    => __( 'Copy of %s', 'cornerstone' ),
	'sortable-empty'        => __( 'No items!', 'cornerstone' ),
	'sortable-empty-sub'    => __( 'Add some to continue building.', 'cornerstone' ),
	'expand-control'        => __( 'Expand', 'cornerstone' ),

	// Settings
	'settings-heading'       => __( 'Settings', 'cornerstone' ),
	'settings-return'        => __( 'Back to Settings', 'cornerstone' ),
	'settings-loading'       => __( 'Please wait while the settings are loaded.', 'cornerstone' ),
	'settings-css-editor'    => __( 'Custom CSS', 'cornerstone' ),
	'settings-js-editor'     => __( 'Custom JS', 'cornerstone' ),
	'settings-js-denied'     => __( 'Your user role does not permit editing javascript.', 'cornerstone' ),
	'settings-js-message'    => __( 'Remember to save to see your script applied.', 'cornerstone' ),
	'settings-wp-changed'    => __( 'You&apos;ve updated a WordPress setting. Please save your page to apply the changes.', 'cornerstone' ),
	'settings-theme-changed' => __( 'You&apos;ve updated a theme setting. Please save your page to apply the changes.', 'cornerstone' ),
  'settings-done'          => __( 'Done', 'cornerstone'),

	// Home
	'home-unsaved'          => __( 'You have not saved any changes!', 'cornerstone' ),
	'home-saved-last'       => __( 'Last saved: %s.', 'cornerstone' ),
	'home-view-site'        => __( 'View Page', 'cornerstone' ),
	'home-dashboard'        => __( 'Dashboard', 'cornerstone' ),
	'home-onbeforeunload'   => __( 'Wait! You have unsaved changes.', 'cornerstone' ),

	// Options
	'options-help-text'             => __( 'Help Text', 'cornerstone' ),
	'options-help-text-sub'         => __( 'Enables tooltips when you hover over control labels and other bits of informational text througout the interface.', 'cornerstone' ),
	'options-editor-position'       => __( 'Editor Position', 'cornerstone' ),
	'options-editor-position-left'  => __( 'Left', 'cornerstone' ),
	'options-editor-position-right' => __( 'Right', 'cornerstone' ),
	'options-editor-position-sub'   => __( 'Move the editor to your preferred side of the window.', 'cornerstone' ),

	// Respond

	'respond-xl-title' => __( 'Extra Large', 'cornerstone' ),
	'respond-lg-title' => __( 'Large', 'cornerstone' ),
	'respond-md-title' => __( 'Medium', 'cornerstone' ),
	'respond-sm-title' => __( 'Small', 'cornerstone' ),
	'respond-xs-title' => __( 'Extra Small', 'cornerstone' ),
	'respond-xl-desc'  => __( '1200px &amp; Up', 'cornerstone' ),
	'respond-lg-desc'  => __( '980px &ndash; 1199px', 'cornerstone' ),
	'respond-md-desc'  => __( '768px &ndash; 979px', 'cornerstone' ),
	'respond-sm-desc'  => __( '481px &ndash; 767px', 'cornerstone' ),
	'respond-xs-desc'  => __( '480px &amp; Smaller', 'cornerstone' ),

	//Confirm
	'confirm-message'                 => __( 'Are you sure?', 'cornerstone' ),
	'confirm-yep'                     => __( 'Yes, proceed', 'cornerstone' ),
	'confirm-nope'                    => __( 'No, go back', 'cornerstone' ),
	'confirm-back'                    => __( 'Back', 'cornerstone' ),

	'confirm-element-delete'          => __( 'Are you sure you wish to delete this %s?', 'cornerstone' ),
	'confirm-element-delete-contents' => __( 'Are you sure you wish to delete this %s, along with its contents?', 'cornerstone' ),

	//Save Complete
	'save-error'             => __( 'Unable to save page.', 'cornerstone' ),
	'save-complete-simple'   => __( 'Content saved.', 'cornerstone' ),
	'save-complete-messages' => array(
		__( 'Woohoo!', 'cornerstone' ),
		__( 'Rock On!', 'cornerstone' ),
		__( 'Radical!', 'cornerstone' ),
		__( 'Tubular!', 'cornerstone' ),
		__( 'Spiffy!', 'cornerstone' ),
		__( 'Yahoo!', 'cornerstone' ),
		__( 'Yippee!', 'cornerstone' ),
		__( 'Have Fun!', 'cornerstone' ),
		__( 'Neat-O!', 'cornerstone' ),
		__( 'Bodacious!', 'cornerstone' ),
		__( 'Scintillating!', 'cornerstone' )
	),


	// Messaging
	'message-notice'  => __( 'Hey!', 'cornerstone' ),
	'message-success' => __( 'Awesome!', 'cornerstone' ),
	'message-error'   => __( 'Uh oh!', 'cornerstone' ),

	'moment-months'         => __( 'January_February_March_April_May_June_July_August_September_October_November_December', 'cornerstone' ),
	'moment-months-short'   => __( 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec', 'cornerstone' ),
	'moment-weekdays'       => __( 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday', 'cornerstone' ),
	'moment-weekdays-short' => __( 'Sun_Mon_Tue_Wed_Thu_Fri_Sat', 'cornerstone' ),
	'moment-weekdays-min'   => __( 'Su_Mo_Tu_We_Th_Fr_Sa', 'cornerstone' ),
	'prev-month'            => __( 'Previous Month', 'cornerstone' ),
	'next-month'            => __( 'Next Month', 'cornerstone' ),

	// Errors
	'browser-no-can'            => __( "We're sorry! Your web browser does not support this action.", 'cornerstone' ),
	'no-preview'                => __( "%s (Preview Unsupported)", 'cornerstone' ),
	'preview-failure1'          => __( "An unidentifiable error is preventing the live preview from loading. Switching to Skeleton Mode.", 'cornerstone' ),
	'preview-failure2'          => __( "A suitable content area for the live preview couldn't be identified. Switching to Skeleton Mode.", 'cornerstone' ),
	'skeleton-locked'           => __( "Skeleton Mode can not be closed because the live preview is unavailable.", 'cornerstone' ),
	'preview-late'              => __( "Loading the preview took longer than expected. There may be script conflicts on this page.", 'cornerstone' ),
	'htmlhint-intro'            => __( "We found some invalid HTML in your content.", 'cornerstone' ),
	'htmlhint-tag-pair'         => __( "You have unclosed HTML tags.", 'cornerstone' ),
	'htmlhint-spec-char-escape' => __( "If not part of an HTML tag, consider using HTML entities for angle brackets by converting <span class=\"monospace\">&lt;</span> to <span class=\"monospace\">&amp;lt;</span> and <span class=\"monospace\">&gt;</span> to <span class=\"monospace\">&amp;gt;</span>", 'cornerstone' ),

	// Skeleton Mode
	'skeleton-main-title' => __( "Skeleton Mode", 'cornerstone' ),
	'skeleton-item-handle' => __("{{type}} - {{title}}", 'cornerstone')

);
